/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.ExistingEntityHandler;
import com.bradmcevoy.http.FileItem;
import com.bradmcevoy.http.GetableResource;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.Range;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.RequestParseException;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetHandler
extends ExistingEntityHandler {
    private static final Logger log = LoggerFactory.getLogger(GetHandler.class);

    public GetHandler(HttpManager manager) {
        super(manager);
    }

    @Override
    protected void process(HttpManager milton, Request request, Response response, Resource resource) throws NotAuthorizedException {
        GetableResource r = (GetableResource)resource;
        if (this.checkConditional(r, request)) {
            this.respondNotModified(r, response, request);
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, FileItem> files = new HashMap<String, FileItem>();
        try {
            request.parseRequestParameters(params, files);
        }
        catch (RequestParseException ex) {
            log.warn("exception parsing request. probably interrupted upload", (Throwable)ex);
            return;
        }
        this.manager.onGet(request, response, resource, params);
        this.sendContent(request, response, r, params);
    }

    public Range getRange(Request requestInfo) {
        String rangeHeader = requestInfo.getRangeHeader();
        if (rangeHeader == null) {
            return null;
        }
        Matcher matcher = Pattern.compile("\\s*bytes\\s*=\\s*(\\d+)-(\\d+)").matcher(rangeHeader);
        if (matcher.matches()) {
            return new Range(Long.parseLong(matcher.group(1)), Long.parseLong(matcher.group(2)));
        }
        return null;
    }

    protected boolean checkConditional(GetableResource resource, Request request) {
        if (this.checkIfMatch(resource, request)) {
            return true;
        }
        if (this.checkIfModifiedSince(resource, request)) {
            return true;
        }
        return this.checkIfNoneMatch(resource, request);
    }

    protected void respondNotModified(GetableResource resource, Response response, Request request) {
        this.getResponseHandler().respondNotModified(resource, response, request);
    }

    protected boolean checkIfMatch(GetableResource handler, Request requestInfo) {
        return false;
    }

    protected boolean checkIfModifiedSince(GetableResource handler, Request requestInfo) {
        Date dtRequest = requestInfo.getIfModifiedHeader();
        if (dtRequest == null) {
            return false;
        }
        Date dtCurrent = handler.getModifiedDate();
        if (dtCurrent == null) {
            return true;
        }
        long timeActual = dtCurrent.getTime();
        long timeRequest = dtRequest.getTime() + 1000L;
        boolean unchangedSince = timeRequest >= timeActual;
        return unchangedSince;
    }

    protected boolean checkIfNoneMatch(GetableResource handler, Request requestInfo) {
        return false;
    }

    @Override
    protected Request.Method method() {
        return Request.Method.GET;
    }

    @Override
    protected boolean isCompatible(Resource handler) {
        return handler instanceof GetableResource;
    }

    protected void sendContent(Request request, Response response, GetableResource resource, Map<String, String> params) throws NotAuthorizedException {
        Range range = this.getRange(request);
        if (range != null) {
            this.getResponseHandler().respondPartialContent(resource, response, request, params, range);
        } else {
            this.getResponseHandler().respondContent(resource, response, request, params);
        }
    }

    @Override
    protected boolean doCheckRedirect(Request request, Response response, Resource resource) {
        String redirectUrl = resource.checkRedirect(request);
        if (redirectUrl != null) {
            this.respondRedirect(response, request, redirectUrl);
            return true;
        }
        return false;
    }
}

