/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.LockInfo;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LockInfoSaxHandler
extends DefaultHandler {
    private LockInfo info = new LockInfo();
    private StringBuilder owner;
    private Stack<String> elementPath = new Stack();

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        this.elementPath.push(localName);
        if (localName.equals("owner")) {
            this.owner = new StringBuilder();
        }
        super.startElement(uri, localName, name, attributes);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.owner != null) {
            this.owner.append(ch, start, length);
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        this.elementPath.pop();
        if (localName.equals("owner")) {
            this.getInfo().owner = this.owner.toString();
        }
        if (this.elementPath.size() > 1) {
            if (((String)this.elementPath.get(1)).equals("lockscope")) {
                this.getInfo().scope = localName.equals("exclusive") ? LockInfo.LockScope.EXCLUSIVE : (localName.equals("shared") ? LockInfo.LockScope.SHARED : LockInfo.LockScope.NONE);
            } else if (((String)this.elementPath.get(1)).equals("locktype")) {
                this.getInfo().type = localName.equals("read") ? LockInfo.LockType.READ : (localName.equals("write") ? LockInfo.LockType.WRITE : LockInfo.LockType.WRITE);
            }
        }
        super.endElement(uri, localName, name);
    }

    public LockInfo getInfo() {
        return this.info;
    }
}

