/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.Request;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockTimeout {
    private static Logger log = LoggerFactory.getLogger(LockTimeout.class);
    private static final String INFINITE = "Infinite";
    final Long seconds;
    final Long[] otherSeconds;

    public static LockTimeout parseTimeout(Request request) {
        String sTimeout = request.getTimeoutHeader();
        log.debug("..requested timeout: " + sTimeout);
        return LockTimeout.parseTimeout(sTimeout);
    }

    public static LockTimeout parseTimeout(String s) {
        if (s == null) {
            return new LockTimeout((List<Long>)null);
        }
        if ((s = s.trim()).length() == 0) {
            return new LockTimeout((List<Long>)null);
        }
        ArrayList<Long> list = new ArrayList<Long>();
        for (String part : s.split(",")) {
            if ((part = part.trim()).equalsIgnoreCase(INFINITE)) {
                list.add(Long.MAX_VALUE);
                continue;
            }
            Long seconds = LockTimeout.parseTimeoutPart(part);
            if (seconds == null) continue;
            list.add(seconds);
        }
        LockTimeout timeout = new LockTimeout(list);
        return timeout;
    }

    static String trim(String s) {
        if (s == null) {
            return "";
        }
        return s.trim();
    }

    static boolean isPresent(String s) {
        return s != null && s.length() > 0;
    }

    private static Long parseTimeoutPart(String part) {
        if (part == null || part.length() == 0) {
            return null;
        }
        int pos = part.indexOf("-");
        if (pos <= 0) {
            return null;
        }
        String s = part.substring(pos + 1, part.length());
        long l = 0L;
        try {
            l = Long.parseLong(s);
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            log.error("Number format exception parsing timeout: " + s);
            return null;
        }
    }

    public LockTimeout(Long timeout) {
        this.seconds = timeout;
        this.otherSeconds = null;
    }

    private LockTimeout(List<Long> timeouts) {
        if (timeouts == null || timeouts.size() == 0) {
            this.seconds = null;
            this.otherSeconds = null;
        } else {
            this.seconds = timeouts.get(0);
            timeouts.remove(0);
            this.otherSeconds = new Long[timeouts.size()];
            timeouts.toArray(this.otherSeconds);
        }
    }

    public Long getSeconds() {
        return this.seconds;
    }

    public Long[] getOtherSeconds() {
        return this.otherSeconds;
    }

    public String toString() {
        if (this.seconds.equals(Long.MAX_VALUE)) {
            return INFINITE;
        }
        return "Second-" + this.seconds;
    }

    public DateAndSeconds getLockedUntil(Long defaultSeconds, Long maxSeconds) {
        Long l = this.getSeconds();
        if (l == null) {
            if (defaultSeconds != null) {
                return this.addSeconds(defaultSeconds);
            }
            if (maxSeconds != null) {
                return this.addSeconds(maxSeconds);
            }
            return this.addSeconds(60L);
        }
        if (maxSeconds != null) {
            if (this.getSeconds() > maxSeconds) {
                return this.addSeconds(maxSeconds);
            }
            return this.addSeconds(l);
        }
        return this.addSeconds(l);
    }

    private DateAndSeconds addSeconds(Long l) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        int secs = (int)l.longValue();
        cal.add(13, secs);
        DateAndSeconds das = new DateAndSeconds();
        das.date = cal.getTime();
        das.seconds = l;
        return das;
    }

    private Date getNow() {
        return new Date();
    }

    public class DateAndSeconds {
        public Date date;
        public Long seconds;
    }
}

