/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.CollectionResource;
import com.bradmcevoy.http.CustomProperty;
import com.bradmcevoy.http.CustomPropertyResource;
import com.bradmcevoy.http.DateUtils;
import com.bradmcevoy.http.ExistingEntityHandler;
import com.bradmcevoy.http.GetableResource;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.LockInfo;
import com.bradmcevoy.http.LockToken;
import com.bradmcevoy.http.LockableResource;
import com.bradmcevoy.http.PropFindSaxHandler;
import com.bradmcevoy.http.PropFindableResource;
import com.bradmcevoy.http.PropertyConsumer;
import com.bradmcevoy.http.PropertyWriter;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.Utils;
import com.bradmcevoy.http.XmlWriter;
import com.bradmcevoy.io.StreamToStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropFindHandler
extends ExistingEntityHandler {
    private Logger log = LoggerFactory.getLogger(PropFindHandler.class);
    private static final String CUSTOM_NS_PREFIX = "R";
    final Map<String, PropertyWriter> writersMap = new HashMap<String, PropertyWriter>();

    public PropFindHandler(HttpManager manager) {
        super(manager);
        this.add(new ContentLengthPropertyWriter());
        this.add(new ContentTypePropertyWriter());
        this.add(new CreationDatePropertyWriter());
        this.add(new DisplayNamePropertyWriter());
        this.add(new LastModifiedDatePropertyWriter());
        this.add(new ResourceTypePropertyWriter());
        this.add(new EtagPropertyWriter());
        this.add(new SupportedLockPropertyWriter());
        this.add(new LockDiscoveryPropertyWriter());
        this.add(new MSHrefPropertyWriter());
        this.add(new MSIsCollectionPropertyWriter());
        this.add(new MSNamePropertyWriter());
    }

    private void add(PropertyWriter pw) {
        this.writersMap.put(pw.fieldName(), pw);
    }

    @Override
    public Request.Method method() {
        return Request.Method.PROPFIND;
    }

    @Override
    protected boolean isCompatible(Resource handler) {
        return handler instanceof PropFindableResource;
    }

    @Override
    protected void process(HttpManager milton, Request request, Response response, Resource resource) {
        Set<String> requestedFields;
        PropFindableResource pfr = (PropFindableResource)resource;
        int depth = request.getDepthHeader();
        response.setStatus(Response.Status.SC_MULTI_STATUS);
        response.setContentTypeHeader("text/xml; charset=UTF-8");
        try {
            requestedFields = this.getRequestedFields(request);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (SAXException ex) {
            throw new RuntimeException(ex);
        }
        String url = request.getAbsoluteUrl();
        this.process(url, pfr, depth, requestedFields, response);
    }

    protected String generateNamespaceDeclarations() {
        return " xmlns:D=\"DAV:\"";
    }

    public void appendResponses(PropertyConsumer consumer, PropFindableResource resource, int requestedDepth, Set<String> requestedFields, String encodedCollectionUrl) {
        this.log.debug("appendresponses: fields size: " + requestedFields.size());
        try {
            String collectionHref = this.suffixSlash(encodedCollectionUrl);
            URI parentUri = new URI(collectionHref);
            collectionHref = parentUri.toASCIIString();
            this.sendResponse(consumer, resource, requestedFields, collectionHref, requestedDepth, 0, collectionHref);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    void sendResponse(PropertyConsumer consumer, PropFindableResource resource, Set<String> requestedFields, String href, int requestedDepth, int currentDepth, String collectionHref) {
        HashSet<PropertyWriter> unknownProperties = new HashSet<PropertyWriter>();
        HashSet<PropertyWriter> knownProperties = new HashSet<PropertyWriter>();
        if (resource instanceof CollectionResource && !href.endsWith("/")) {
            href = href + "/";
        }
        CustomPropertyResource cpr = null;
        if (resource instanceof CustomPropertyResource) {
            cpr = (CustomPropertyResource)resource;
        }
        for (String field : requestedFields) {
            void var14_14;
            PropertyWriter pw = null;
            Object var14_15 = null;
            if (cpr != null) {
                CustomProperty customProperty = cpr.getProperty(field);
            }
            if (var14_14 == null) {
                pw = this.writersMap.get(field);
            }
            if (var14_14 != null) {
                this.log.debug("..custom prop: " + field);
                CustomPropertyWriter customPw = new CustomPropertyWriter(field, (CustomProperty)var14_14);
                knownProperties.add(customPw);
                continue;
            }
            if (pw != null) {
                this.log.debug("..standard prop: " + field);
                knownProperties.add(pw);
                continue;
            }
            unknownProperties.add(new UnknownPropertyWriter(field));
        }
        consumer.consumeProperties(knownProperties, unknownProperties, href, resource, currentDepth);
        if (requestedDepth > currentDepth && resource instanceof CollectionResource) {
            CollectionResource col = (CollectionResource)((Object)resource);
            ArrayList<? extends Resource> list = new ArrayList<Resource>(col.getChildren());
            for (Resource resource2 : list) {
                if (!(resource2 instanceof PropFindableResource)) continue;
                String childHref = collectionHref + Utils.percentEncode(resource2.getName());
                this.sendResponse(consumer, (PropFindableResource)resource2, requestedFields, childHref, requestedDepth, currentDepth + 1, href + col.getName());
            }
        }
    }

    private void process(String url, PropFindableResource pfr, int depth, Set<String> requestedFields, Response response) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            XmlWriter writer = new XmlWriter(out);
            XmlWriterPropertyConsumer consumer = new XmlWriterPropertyConsumer(writer);
            writer.writeXMLHeader();
            writer.open("D:multistatus" + this.generateNamespaceDeclarations());
            writer.newLine();
            this.appendResponses(consumer, pfr, depth, requestedFields, url);
            writer.close("D:multistatus");
            writer.flush();
            response.getOutputStream().write(out.toByteArray());
        }
        catch (IOException ex) {
            this.log.warn("ioexception sending output", (Throwable)ex);
        }
    }

    private String suffixSlash(String s) {
        if (!s.endsWith("/")) {
            s = s + "/";
        }
        return s;
    }

    private String nameEncode(String s) {
        return Utils.escapeXml(s);
    }

    protected void sendStringProp(XmlWriter writer, String name, String value) {
        String s = value;
        if (s == null) {
            writer.writeProperty(null, name);
        } else {
            writer.writeProperty(null, name, s);
        }
    }

    void sendDateProp(XmlWriter writer, String name, Date date) {
        this.sendStringProp(writer, name, date == null ? null : DateUtils.formatDate(date));
    }

    protected boolean isFolder(PropFindableResource resource) {
        return resource instanceof CollectionResource;
    }

    private Set<String> getRequestedFields(Request request) throws IOException, SAXException, FileNotFoundException {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        InputStream in = request.getInputStream();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        StreamToStream.readTo(in, bout, false, true);
        byte[] arr = bout.toByteArray();
        if (arr.length > 1) {
            ByteArrayInputStream bin = new ByteArrayInputStream(arr);
            XMLReader reader = XMLReaderFactory.createXMLReader();
            PropFindSaxHandler handler = new PropFindSaxHandler();
            reader.setContentHandler(handler);
            reader.parse(new InputSource(bin));
            set.addAll(handler.getAttributes().keySet());
        }
        if (set.size() == 0) {
            set.add("creationdate");
            set.add("getlastmodified");
            set.add("displayname");
            set.add("resourcetype");
            set.add("getcontenttype");
            set.add("getcontentlength");
            set.add("getetag");
        }
        return set;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CustomPropertyWriter
    implements PropertyWriter<Object> {
        final String fieldName;
        final CustomProperty prop;

        public CustomPropertyWriter(String fieldName, CustomProperty prop) {
            this.fieldName = fieldName;
            this.prop = prop;
        }

        @Override
        public String fieldName() {
            return this.fieldName;
        }

        @Override
        public void append(XmlWriter writer, PropFindableResource res, String href) {
            String s = this.prop.getFormattedValue();
            s = Utils.escapeXml(s);
            PropFindHandler.this.sendStringProp(writer, "R:" + this.fieldName(), s);
        }

        @Override
        public Object getValue(PropFindableResource res, String href) {
            return this.prop.getTypedValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class UnknownPropertyWriter
    implements PropertyWriter<String> {
        final String name;

        public UnknownPropertyWriter(String name) {
            this.name = name;
        }

        @Override
        public void append(XmlWriter writer, PropFindableResource res, String href) {
            PropFindHandler.this.sendStringProp(writer, "D:" + this.fieldName(), null);
        }

        @Override
        public String getValue(PropFindableResource res, String href) {
            return null;
        }

        @Override
        public String fieldName() {
            return this.name;
        }
    }

    class MSIsCollectionPropertyWriter
    extends ResourceTypePropertyWriter {
        MSIsCollectionPropertyWriter() {
        }

        public void append(XmlWriter writer, PropFindableResource res, String href) {
            String s = this.getValue(res, href) != false ? "true" : "false";
            PropFindHandler.this.sendStringProp(writer, "D:" + this.fieldName(), s);
        }

        public String fieldName() {
            return "iscollection";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MSHrefPropertyWriter
    implements PropertyWriter<String> {
        MSHrefPropertyWriter() {
        }

        @Override
        public void append(XmlWriter writer, PropFindableResource res, String href) {
            PropFindHandler.this.sendStringProp(writer, "D:" + this.fieldName(), href);
        }

        @Override
        public String getValue(PropFindableResource res, String href) {
            return href;
        }

        @Override
        public String fieldName() {
            return "href";
        }
    }

    class MSNamePropertyWriter
    extends DisplayNamePropertyWriter {
        MSNamePropertyWriter() {
        }

        public String fieldName() {
            return "name";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SupportedLockPropertyWriter
    implements PropertyWriter<Object> {
        SupportedLockPropertyWriter() {
        }

        @Override
        public void append(XmlWriter writer, PropFindableResource resource, String href) {
            if (resource instanceof LockableResource) {
                XmlWriter.Element lockentry = writer.begin("lockentry").open();
                writer.begin("lockscope").open().writeText("<D:exclusive/>").close();
                writer.begin("locktype").open().writeText("<D:write/>").close();
                lockentry.close();
            }
        }

        @Override
        public Object getValue(PropFindableResource res, String href) {
            return null;
        }

        @Override
        public String fieldName() {
            return "supportedlock";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LockDiscoveryPropertyWriter
    implements PropertyWriter<LockToken> {
        LockDiscoveryPropertyWriter() {
        }

        @Override
        public void append(XmlWriter writer, PropFindableResource resource, String href) {
            LockToken token = this.getValue(resource, href);
            if (token == null) {
                return;
            }
            XmlWriter.Element lockentry = writer.begin("D:lockdiscovery").open();
            if (token != null) {
                LockInfo info = token.info;
                writer.begin("D:lockscope").open().writeText("<D:" + info.scope.name().toLowerCase() + "/>").close();
                writer.begin("D:locktype").open().writeText("<D:" + info.type.name().toLowerCase() + "/>").close();
                writer.begin("D:depth").open().writeText("0").close();
                writer.begin("D:owner").open().writeText(info.owner).close();
                writer.begin("D:timeout").open().writeText(token.timeout.toString()).close();
                XmlWriter.Element elToken = writer.begin("D:locktoken").open();
                writer.begin("D:href").open().writeText("urn:uuid:" + token.tokenId).close();
                writer.begin("D:lockroot").open().writeText(href).close();
                elToken.close();
            }
            lockentry.close();
        }

        @Override
        public LockToken getValue(PropFindableResource res, String href) {
            if (!(res instanceof LockableResource)) {
                return null;
            }
            LockableResource lr = (LockableResource)((Object)res);
            LockToken token = lr.getCurrentLock();
            return token;
        }

        @Override
        public String fieldName() {
            return "supportedlock";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EtagPropertyWriter
    implements PropertyWriter<String> {
        EtagPropertyWriter() {
        }

        @Override
        public void append(XmlWriter writer, PropFindableResource resource, String href) {
            String etag = this.getValue(resource, href);
            if (etag != null) {
                PropFindHandler.this.sendStringProp(writer, "D:getetag", etag);
            }
        }

        @Override
        public String getValue(PropFindableResource res, String href) {
            return res.getUniqueId();
        }

        @Override
        public String fieldName() {
            return "getetag";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ContentLengthPropertyWriter
    implements PropertyWriter<Long> {
        ContentLengthPropertyWriter() {
        }

        @Override
        public void append(XmlWriter xmlWriter, PropFindableResource res, String href) {
            Long ll = this.getValue(res, href);
            PropFindHandler.this.sendStringProp(xmlWriter, "D:" + this.fieldName(), ll == null ? "" : ll.toString());
        }

        @Override
        public Long getValue(PropFindableResource res, String href) {
            if (res instanceof GetableResource) {
                GetableResource getable = (GetableResource)((Object)res);
                Long l = getable.getContentLength();
                return l;
            }
            return null;
        }

        @Override
        public String fieldName() {
            return "getcontentlength";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ContentTypePropertyWriter
    implements PropertyWriter<String> {
        ContentTypePropertyWriter() {
        }

        @Override
        public void append(XmlWriter xmlWriter, PropFindableResource res, String href) {
            String ct = this.getValue(res, href);
            PropFindHandler.this.sendStringProp(xmlWriter, "D:" + this.fieldName(), ct);
        }

        @Override
        public String getValue(PropFindableResource res, String href) {
            if (res instanceof GetableResource) {
                GetableResource getable = (GetableResource)((Object)res);
                return getable.getContentType(null);
            }
            return "";
        }

        @Override
        public String fieldName() {
            return "getcontenttype";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ResourceTypePropertyWriter
    implements PropertyWriter<Boolean> {
        ResourceTypePropertyWriter() {
        }

        @Override
        public void append(XmlWriter writer, PropFindableResource resource, String href) {
            String rt = this.getValue(resource, href) != false ? "<D:collection/>" : "";
            PropFindHandler.this.sendStringProp(writer, "D:resourcetype", rt);
        }

        @Override
        public Boolean getValue(PropFindableResource res, String href) {
            return PropFindHandler.this.isFolder(res);
        }

        @Override
        public String fieldName() {
            return "resourcetype";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CreationDatePropertyWriter
    implements PropertyWriter<Date> {
        CreationDatePropertyWriter() {
        }

        @Override
        public void append(XmlWriter xmlWriter, PropFindableResource res, String href) {
            PropFindHandler.this.sendDateProp(xmlWriter, "D:" + this.fieldName(), this.getValue(res, href));
        }

        @Override
        public Date getValue(PropFindableResource res, String href) {
            return res.getCreateDate();
        }

        @Override
        public String fieldName() {
            return "creationdate";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LastModifiedDatePropertyWriter
    implements PropertyWriter<Date> {
        LastModifiedDatePropertyWriter() {
        }

        @Override
        public void append(XmlWriter xmlWriter, PropFindableResource res, String href) {
            Date dt = res.getModifiedDate();
            String f = dt == null ? "" : DateUtils.formatForWebDavModifiedDate(res.getModifiedDate());
            PropFindHandler.this.sendStringProp(xmlWriter, "D:" + this.fieldName(), f);
        }

        @Override
        public String fieldName() {
            return "getlastmodified";
        }

        @Override
        public Date getValue(PropFindableResource res, String href) {
            return res.getModifiedDate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DisplayNamePropertyWriter
    implements PropertyWriter<String> {
        DisplayNamePropertyWriter() {
        }

        @Override
        public void append(XmlWriter writer, PropFindableResource res, String href) {
            PropFindHandler.this.sendStringProp(writer, "D:" + this.fieldName(), PropFindHandler.this.nameEncode(this.getValue(res, href)));
        }

        @Override
        public String getValue(PropFindableResource res, String href) {
            return res.getName();
        }

        @Override
        public String fieldName() {
            return "displayname";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class XmlWriterPropertyConsumer
    implements PropertyConsumer {
        final XmlWriter writer;

        public XmlWriterPropertyConsumer(XmlWriter writer) {
            this.writer = writer;
        }

        public void startResource(String href) {
            this.writeProp("D:href", href);
        }

        public XmlWriter.Element open(String elementName) {
            return this.writer.begin(elementName).open();
        }

        void writeProp(String elementName, String value) {
            this.writer.writeProperty(null, elementName, value);
        }

        @Override
        public void consumeProperties(Set<PropertyWriter> knownProperties, Set<PropertyWriter> unknownProperties, String href, PropFindableResource resource, int depth) {
            XmlWriter.Element el = this.writer.begin("D:response");
            if (resource instanceof CustomPropertyResource) {
                CustomPropertyResource cpr = (CustomPropertyResource)resource;
                el.writeAtt("xmlns:R", cpr.getNameSpaceURI());
            }
            el.open();
            this.startResource(href);
            this.sendResponseProperties(resource, knownProperties, href, "HTTP/1.1 200 Ok");
            this.sendResponseProperties(resource, unknownProperties, href, "HTTP/1.1 404 Not Found");
            el.close();
        }

        void sendResponseProperties(PropFindableResource resource, Set<PropertyWriter> properties, String href, String status) {
            if (!properties.isEmpty()) {
                XmlWriter.Element elPropStat = this.writer.begin("D:propstat").open();
                XmlWriter.Element elProp = this.writer.begin("D:prop").open();
                for (PropertyWriter pw : properties) {
                    pw.append(this.writer, resource, href);
                }
                elProp.close();
                this.writeProp("D:status", status);
                elPropStat.close();
            }
        }
    }
}

