/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.PropPatchHandler;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PropPatchSaxHandler
extends DefaultHandler {
    private Stack<String> elementPath = new Stack();
    private Map<String, String> attributesCurrent;
    private Map<String, String> attributesSet = new LinkedHashMap<String, String>();
    private Map<String, String> attributesRemove = new LinkedHashMap<String, String>();
    private StringBuilder sb = new StringBuilder();
    private boolean inSet;
    private boolean inRemove;
    private boolean inProp;

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (this.elementPath.size() > 0) {
            if (this.attributesCurrent != null) {
                if (this.elementPath.peek().endsWith("prop")) {
                    this.inProp = true;
                }
            } else {
                if (this.elementPath.peek().endsWith("set")) {
                    this.attributesCurrent = this.attributesSet;
                }
                if (this.elementPath.peek().endsWith("remove")) {
                    this.attributesCurrent = this.attributesRemove;
                }
            }
        }
        this.elementPath.push(localName);
        super.startElement(uri, localName, name, attributes);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inProp) {
            this.sb.append(ch, start, length);
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        this.elementPath.pop();
        if (this.elementPath.size() > 0) {
            if (this.elementPath.peek().endsWith("prop")) {
                if (this.sb != null) {
                    String s = this.sb.toString().trim();
                    this.attributesCurrent.put(localName, s);
                    System.out.println(localName + " = " + s);
                }
                this.sb = new StringBuilder();
            } else if (this.elementPath.peek().endsWith("set")) {
                this.attributesCurrent = null;
            } else if (this.elementPath.peek().endsWith("remove")) {
                this.attributesCurrent = null;
            }
        }
        super.endElement(uri, localName, name);
    }

    PropPatchHandler.Fields getFields() {
        PropPatchHandler.Fields fields = new PropPatchHandler.Fields();
        for (Map.Entry<String, String> entry : this.attributesSet.entrySet()) {
            fields.setFields.add(new PropPatchHandler.SetField(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<String, String> entry : this.attributesRemove.entrySet()) {
            fields.removeFields.add(new PropPatchHandler.Field(entry.getKey()));
        }
        return fields;
    }
}

