/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.setup;

import java.util.List;
import java.util.Vector;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.setup.ConstraintImpl;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class ConstraintImpl_PK
implements ConstraintImpl {
    private String _name = null;
    private DatabaseType _dbtype = null;
    private List<String> _fields = null;

    public ConstraintImpl_PK(String name, DatabaseType dbtype, Node node) throws SAXException {
        this._name = name;
        this._dbtype = dbtype;
        this._fields = new Vector<String>();
        NodeList listFields = node.getChildNodes();
        int numFields = listFields.getLength();
        for (int iField = 0; iField < numFields; ++iField) {
            node = listFields.item(iField);
            if (!node.getNodeName().equalsIgnoreCase("field")) continue;
            NamedNodeMap attrs = node.getAttributes();
            if (attrs.getLength() != 1) {
                throw new SAXException("Primary key field element must have only 1 attribute and it must be 'ref'");
            }
            Node refAttr = attrs.item(0);
            if (!refAttr.getNodeName().equalsIgnoreCase("ref")) {
                throw new SAXException("Primary key field element must have only 1 attribute and it must be 'ref'");
            }
            this._fields.add(refAttr.getNodeValue());
        }
    }

    @Override
    public void getPostCreateCommands(List postCreateCommands) {
    }

    @Override
    public String getCreateString() {
        if (this._name == null) {
            this._name = "";
        }
        return ", CONSTRAINT " + this._name + " PRIMARY KEY (" + this.listItems(this._fields) + ")";
    }

    private String listItems(List<String> list) {
        StringBuffer ret_items = new StringBuffer();
        if (list != null) {
            for (String string : list) {
                if (ret_items.length() > 0) {
                    ret_items.append(", ");
                }
                ret_items.append(string);
            }
        }
        return ret_items.toString();
    }
}

