/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.mysql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.database.DatabaseQueryUtility;
import org.rhq.plugins.mysql.MySqlDatabaseComponent;

public class MySqlTableDiscoveryComponent
implements ResourceDiscoveryComponent {
    private Log log = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set discoverResources(ResourceDiscoveryContext rdc) throws InvalidPluginConfigurationException, Exception {
        HashSet<DiscoveredResourceDetails> set = new HashSet<DiscoveredResourceDetails>();
        MySqlDatabaseComponent parent = (MySqlDatabaseComponent)rdc.getParentResourceComponent();
        Connection conn = parent.getConnection();
        if (conn != null) {
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = conn.createStatement();
                rs = stmt.executeQuery("show tables from " + parent.getName());
                while (rs.next()) {
                    String tableName = rs.getString(1);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Discovered Table " + tableName));
                    }
                    Configuration config = new Configuration();
                    config.put((Property)new PropertySimple("tableName", (Object)tableName));
                    DiscoveredResourceDetails details = new DiscoveredResourceDetails(rdc.getResourceType(), tableName, tableName + " Table", null, tableName + " MySql Table", config, null);
                    set.add(details);
                }
                DatabaseQueryUtility.close((Statement)stmt, (ResultSet)rs);
            }
            catch (SQLException se) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Unable to Discover Tables", (Throwable)se);
                }
            }
            finally {
                DatabaseQueryUtility.close((Statement)stmt, rs);
            }
        }
        return set;
    }
}

