/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.discovery.AvailabilityReport;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementData;
import org.rhq.core.domain.measurement.MeasurementDataRequest;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.core.pc.ServerServices;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pc.measurement.MeasurementManager;
import org.rhq.core.pc.operation.OperationContextImpl;
import org.rhq.core.pc.plugin.FileSystemPluginFinder;
import org.rhq.core.pluginapi.operation.OperationContext;
import org.rhq.core.pluginapi.operation.OperationServices;
import org.rhq.core.pluginapi.operation.OperationServicesResult;
import org.rhq.core.pluginapi.operation.OperationServicesResultCode;
import org.rhq.core.system.SystemInfoFactory;

public class StandaloneContainer {
    private PluginContainer pc;
    private int resourceId;
    private Resource platform;
    InventoryManager inventoryManager;
    Integer opId = 0;
    List<String> history = new ArrayList<String>(10);
    Map<Integer, Configuration> resConfigMap = new HashMap<Integer, Configuration>();
    int dollarR = 0;
    private static final String HISTORY_HELP = "!! : repeat the last action\n!? : show the history of commands issued\n!h : show this help\n!nn : repeat history item with number nn\n!w fileName : write history to file with name fileName\n!dnn : delete history item with number nn";

    public static void main(String[] argv) {
        StandaloneContainer sc = new StandaloneContainer();
        BufferedReader br = null;
        if (argv.length == 0) {
            br = new BufferedReader(new InputStreamReader(System.in));
        } else {
            try {
                br = new BufferedReader(new InputStreamReader(new FileInputStream(argv[0])));
            }
            catch (FileNotFoundException fnfe) {
                System.err.println("File " + argv[0] + " not found");
                System.exit(1);
            }
        }
        sc.run(br);
    }

    private void run(BufferedReader br) {
        boolean shouldQuit = false;
        System.out.println("\nStarting the plugin container.");
        this.pc = PluginContainer.getInstance();
        File pluginDir = new File("plugins");
        File dataDir = new File("data");
        PluginContainerConfiguration pcConfig = new PluginContainerConfiguration();
        pcConfig.setPluginFinder(new FileSystemPluginFinder(pluginDir));
        pcConfig.setPluginDirectory(pluginDir);
        pcConfig.setDataDirectory(dataDir);
        pcConfig.setInsideAgent(false);
        pcConfig.setRootPluginClassLoaderRegex(PluginContainerConfiguration.getDefaultClassLoaderFilter());
        pcConfig.setCreateResourceClassloaders(true);
        pcConfig.setServerServices(new ServerServices());
        this.pc.setConfiguration(pcConfig);
        System.out.println("Loading plugins");
        this.pc.initialize();
        for (String plugin : this.pc.getPluginManager().getMetadataManager().getPluginNames()) {
            System.out.println("...Loaded plugin: " + plugin);
        }
        this.inventoryManager = this.pc.getInventoryManager();
        this.platform = this.inventoryManager.getPlatform();
        System.out.println("\nReady.");
        while (!shouldQuit) {
            try {
                String[] tokens;
                System.out.print("[" + this.history.size() + "]:" + this.resourceId + " > ");
                String answer = br.readLine();
                if (answer == null) break;
                if ((answer = this.handleHistory(answer)).startsWith("!") || (tokens = answer.split(" ")).length <= 0) continue;
                shouldQuit = this.dispatchCommand(tokens);
            }
            catch (Throwable throwable) {
                System.err.println("Exception happened: " + throwable + "\n");
            }
        }
        System.out.println("Shutting down ...");
        this.pc.shutdown();
    }

    private String handleHistory(String answer) {
        if (!answer.startsWith("!")) {
            this.history.add(answer);
            return answer;
        }
        if (answer.startsWith("!?")) {
            for (int i = 0; i < this.history.size(); ++i) {
                System.out.println("[" + i + "]: " + this.history.get(i));
            }
        } else {
            if (answer.startsWith("!h")) {
                System.out.println(HISTORY_HELP);
                return "!";
            }
            if (answer.startsWith("!!")) {
                String text = this.history.get(this.history.size() - 1);
                System.out.println(text);
                this.history.add(text);
                return text;
            }
            if (answer.matches("![0-9]+")) {
                Integer i;
                String id = answer.substring(1);
                try {
                    i = Integer.valueOf(id);
                }
                catch (NumberFormatException nfe) {
                    System.err.println(id + " is no valid history position");
                    return "!";
                }
                if (i > this.history.size()) {
                    System.err.println(i + " is no valid history position");
                    return "!";
                }
                String text = this.history.get(i);
                System.out.println(text);
                this.history.add(text);
                return text;
            }
            if (answer.startsWith("!w")) {
                String[] tokens = answer.split(" ");
                if (tokens.length < 2) {
                    System.err.println("Not enough parameters. You need to give a file name");
                }
                File file = new File(tokens[1]);
                try {
                    file.createNewFile();
                    if (file.canWrite()) {
                        FileWriter writer = new FileWriter(file);
                        for (String item : this.history) {
                            writer.write(item);
                            writer.write("\n");
                        }
                        ((Writer)writer).flush();
                        ((Writer)writer).close();
                    } else {
                        System.err.println("Can not write to file " + file);
                    }
                }
                catch (IOException ioe) {
                    System.err.println("Saving the history to file " + file + " failed: " + ioe.getMessage());
                }
                return "!";
            }
            if (answer.matches("!d[0-9]+")) {
                Integer i;
                String id = answer.substring(2);
                try {
                    i = Integer.valueOf(id);
                }
                catch (NumberFormatException nfe) {
                    System.err.println(id + " is no valid history position");
                    return "!";
                }
                if (i > this.history.size()) {
                    System.err.println(i + " is no valid history position");
                    return "!";
                }
                this.history.remove(i);
                return "!";
            }
            System.err.println(answer + " is no valid history command");
            return "!";
        }
        return "!";
    }

    private boolean dispatchCommand(String[] tokens) throws Exception {
        if (tokens.length == 0) {
            return false;
        }
        if (tokens[0].startsWith("#")) {
            return false;
        }
        Command com = Command.get(tokens[0]);
        if (com == null) {
            System.err.println("Command " + tokens[0] + " is unknown");
            return false;
        }
        int minArgs = com.getMinArgs();
        if (tokens.length < minArgs + 1) {
            System.err.println("Command " + (Object)((Object)com) + " needs " + minArgs + " parameter(s): " + com.getArgs());
            return false;
        }
        switch (com) {
            case ASCAN: {
                AvailabilityReport aReport = this.pc.getDiscoveryAgentService().executeAvailabilityScanImmediately(false);
                System.out.println(aReport);
                break;
            }
            case AVAIL: {
                this.avail(tokens);
                break;
            }
            case CHILDREN: {
                this.children(tokens);
                break;
            }
            case DISCOVER: {
                this.discover(tokens);
                break;
            }
            case FIND: {
                this.find(tokens);
                break;
            }
            case HELP: {
                for (Command comm : EnumSet.allOf(Command.class)) {
                    System.out.println((Object)((Object)comm) + " ( " + comm.getAbbrev() + " ), " + comm.getArgs() + " : " + comm.getHelp());
                }
                System.out.println("Also check out !h for help on history commands");
                break;
            }
            case INVOKE: {
                this.invokeOps(tokens);
                break;
            }
            case MEASURE: {
                this.measure(tokens);
                break;
            }
            case NATIVE: {
                this.doNative(tokens);
                break;
            }
            case QUIT: {
                System.out.println("Terminating ..");
                return true;
            }
            case RESOURCES: {
                this.resources();
                break;
            }
            case SET: {
                this.set(tokens);
                break;
            }
            case WAIT: {
                Thread.sleep(Integer.valueOf(tokens[1]).intValue());
                break;
            }
            case P_CONFIG: {
                this.showPluginConfig();
                break;
            }
            case R_CONFIG: {
                this.showResourceConfig();
            }
        }
        return false;
    }

    private void invokeOps(String[] tokens) throws Exception {
        OperationServicesResult res;
        if (this.resourceId == 0) {
            System.err.println("No resource selected");
            return;
        }
        String operation = tokens[1];
        if (operation.equals("-list")) {
            ResourceType rt = this.getTypeForResourceId();
            Set opDefs = rt.getOperationDefinitions();
            for (OperationDefinition def : opDefs) {
                System.out.println(def.getName() + " : " + def.getDescription());
                ConfigurationDefinition params = def.getParametersConfigurationDefinition();
                if (params == null || params.getPropertyDefinitions() == null || params.getPropertyDefinitions().isEmpty()) continue;
                System.out.println("  Parameters:");
                for (Map.Entry param : params.getPropertyDefinitions().entrySet()) {
                    System.out.println("    " + (String)param.getKey());
                }
            }
            if (opDefs.isEmpty()) {
                System.out.println("Resource has no operations");
            }
            return;
        }
        OperationContextImpl operationContext = new OperationContextImpl(this.resourceId);
        OperationServices operationServices = operationContext.getOperationServices();
        Integer i$ = this.opId;
        Integer def = this.opId = Integer.valueOf(this.opId + 1);
        Configuration config = null;
        if (tokens.length > 2) {
            config = this.createConfigurationFromString(tokens[2]);
        }
        if ((res = operationServices.invokeOperation((OperationContext)operationContext, tokens[1], config, 2000L)).getResultCode() == OperationServicesResultCode.FAILURE) {
            System.err.println("Failure executing the operation: \n" + res.getErrorStackTrace());
        } else if (res.getResultCode() == OperationServicesResultCode.TIMED_OUT) {
            System.err.println("Operation timed out ");
        } else {
            Configuration result = res.getComplexResults();
            if (result == null) {
                System.out.println("Operation did not return a result");
            } else {
                System.out.println(result.getProperties());
            }
        }
    }

    private ResourceType getTypeForResourceId() {
        ResourceContainer rc = this.inventoryManager.getResourceContainer(this.resourceId);
        Resource res = rc.getResource();
        return res.getResourceType();
    }

    private void doNative(String[] tokens) {
        String what = tokens[1];
        if (what.startsWith("e")) {
            SystemInfoFactory.enableNativeSystemInfo();
            System.out.println("Native layer enabled.");
        } else if (what.startsWith("d")) {
            SystemInfoFactory.disableNativeSystemInfo();
            System.out.println("Native layer disabled.");
        } else if (what.startsWith("s")) {
            System.out.println(SystemInfoFactory.isNativeSystemInfoAvailable() ? "Available" : "Not Available");
            System.out.println(SystemInfoFactory.isNativeSystemInfoDisabled() ? "Disabled" : "Enabled");
            System.out.println(SystemInfoFactory.isNativeSystemInfoInitialized() ? "Initialized" : "Not initialized");
        } else {
            System.err.println("Unknown option. Only 'e', 'd' and 's' are applicable (enable/disable/status)");
            return;
        }
    }

    private void event(String[] tokens) {
        if (this.resourceId == 0) {
            return;
        }
        System.err.println("Not yet implemented");
    }

    private void resources() {
        Set<Resource> resources = this.getResources();
        for (Resource res : resources) {
            System.out.println(res);
        }
    }

    private void avail(String[] tokens) {
        Set<Resource> resources = this.getResources();
        int id = 0;
        if (tokens.length > 1) {
            id = Integer.valueOf(tokens[1]);
        }
        for (Resource res : resources) {
            if (id != 0 && (id == 0 || res.getId() != id)) continue;
            Availability availability = this.inventoryManager.getCurrentAvailability(res);
            System.out.println(res.getName() + "( " + res.getId() + " ):" + availability.getAvailabilityType());
        }
    }

    private void children(String[] tokens) {
        int id = Integer.valueOf(tokens[1]);
        ResourceContainer resourceContainer = this.inventoryManager.getResourceContainer(id);
        if (resourceContainer != null) {
            Resource r = resourceContainer.getResource();
            Set resources = r.getChildResources();
            for (Resource res : resources) {
                System.out.println(res);
            }
        } else {
            System.err.println("There is no resource with id " + id);
        }
    }

    private Set<Resource> getResources() {
        HashSet<Resource> resources = new HashSet<Resource>();
        Stack<Resource> stack = new Stack<Resource>();
        stack.push(this.platform);
        while (!stack.isEmpty()) {
            Resource r = (Resource)stack.pop();
            resources.add(r);
            stack.addAll(r.getChildResources());
        }
        return resources;
    }

    private void find(String[] tokens) {
        String pattern = tokens[2];
        pattern = pattern.replaceAll("\\*", "\\.\\*");
        if (tokens[1].equals("r")) {
            Set<Resource> resources = this.getResources();
            for (Resource res : resources) {
                if (!res.getName().matches(pattern)) continue;
                System.out.println(res.getId() + ": " + res.getName() + " (parent= " + res.getParentResource() + " )");
                this.dollarR = res.getId();
            }
        } else if (tokens[1].equals("t")) {
            Set types = this.pc.getPluginManager().getMetadataManager().getAllTypes();
            for (ResourceType type : types) {
                if (!type.getName().matches(pattern)) continue;
                System.out.println(type.getId() + ": " + type.getName() + " (" + type.getPlugin() + " )");
            }
        } else if (tokens[1].equals("rt")) {
            Set types = this.pc.getPluginManager().getMetadataManager().getAllTypes();
            Set<Resource> resources = this.getResources();
            for (ResourceType type : types) {
                if (!type.getName().matches(pattern)) continue;
                for (Resource res : resources) {
                    if (!res.getResourceType().equals((Object)type)) continue;
                    System.out.println(res.getId() + ": " + res.getName() + " ( " + res.getParentResource() + " )");
                    this.dollarR = res.getId();
                }
            }
        } else {
            System.err.println("'" + tokens[1] + "' is no valid option for find");
        }
    }

    private void set(String[] tokens) {
        String comm = tokens[1].toLowerCase();
        String arg = tokens[2];
        if (!comm.startsWith("plu")) {
            if (comm.startsWith("r")) {
                try {
                    this.resourceId = arg.equals("$r") ? this.dollarR : Integer.valueOf(arg);
                }
                catch (NumberFormatException nfe) {
                    System.err.println("Sorry, but [" + arg + "] is no valid number");
                }
                ResourceContainer rc = this.inventoryManager.getResourceContainer(this.resourceId);
                if (rc == null) {
                    System.err.println("No resource with that id exists");
                    this.resourceId = 0;
                }
            } else {
                System.err.println("Bad command " + tokens[1]);
            }
        }
    }

    private void discover(String[] tokens) {
        Set<Resource> existing = this.getResources();
        String what = tokens[1];
        long t1 = System.currentTimeMillis();
        if (what.startsWith("s")) {
            this.pc.getInventoryManager().executeServerScanImmediately();
        } else if (what.startsWith("i")) {
            this.pc.getInventoryManager().executeServiceScanImmediately();
        } else if (what.startsWith("all")) {
            this.pc.getInventoryManager().executeServerScanImmediately();
            this.pc.getInventoryManager().executeServiceScanImmediately();
        } else {
            System.err.println("Unknown option. Only 's' and 'i' are applicable");
            return;
        }
        long t2 = System.currentTimeMillis();
        System.out.println("Discovery took: " + (t2 - t1) + "ms");
        Set<Resource> newOnes = this.getResources();
        newOnes.removeAll(existing);
        System.out.println(newOnes);
    }

    private void measure(String[] tokens) {
        if (this.resourceId == 0) {
            System.err.println("No resource set");
            return;
        }
        MeasurementManager mm = this.pc.getMeasurementManager();
        if (tokens[1].equals("-list")) {
            ResourceType rt = this.getTypeForResourceId();
            Set defs = rt.getMetricDefinitions();
            if (defs == null || defs.isEmpty()) {
                System.out.println("Resource has no metrics");
                return;
            }
            for (MeasurementDefinition def : defs) {
                System.out.println(def.getName() + " : " + def.getDataType() + ", " + def.getDescription());
            }
            return;
        }
        if (tokens.length < 3) {
            System.err.println("measure needs at least two parameters");
            return;
        }
        DataType dataType = this.getDataType(tokens[1]);
        if (dataType == null) {
            System.err.println("Unknown DataType " + tokens[1]);
            System.err.println("Valid ones are measurement, trait, calltime, complex");
        }
        String[] metricNames = new String[tokens.length - 2];
        System.arraycopy(tokens, 2, metricNames, 0, tokens.length - 2);
        ArrayList<MeasurementDataRequest> requests = new ArrayList<MeasurementDataRequest>();
        for (String metric : metricNames) {
            requests.add(new MeasurementDataRequest(metric, dataType));
        }
        Set<MeasurementData> dataset = mm.getRealTimeMeasurementValue(this.resourceId, requests);
        if (dataset == null) {
            System.err.println("No data returned");
            return;
        }
        for (MeasurementData data : dataset) {
            System.out.println(data);
        }
    }

    private DataType getDataType(String token) {
        String c = token.toLowerCase();
        if (c.startsWith("m")) {
            return DataType.MEASUREMENT;
        }
        if (c.startsWith("t")) {
            return DataType.TRAIT;
        }
        if (c.startsWith("ca")) {
            return DataType.CALLTIME;
        }
        if (c.startsWith("co")) {
            return DataType.COMPLEX;
        }
        return null;
    }

    private Configuration createConfigurationFromString(String input) {
        String[] pairs;
        if (input == null) {
            return null;
        }
        Configuration config = new Configuration();
        for (String pair : pairs = input.split("\\|\\|")) {
            String[] kv = pair.split("=");
            PropertySimple ps = new PropertySimple(kv[0], (Object)kv[1]);
            config.put((Property)ps);
        }
        return config;
    }

    private void showPluginConfig() {
        if (this.resourceId == 0) {
            System.err.println("You must first set the resource to work with.");
            return;
        }
        Configuration config = this.pc.getInventoryManager().getResourceContainer(this.resourceId).getResource().getPluginConfiguration();
        this.showConfig(config);
    }

    private void showResourceConfig() throws PluginContainerException {
        if (this.resourceId == 0) {
            System.err.println("You must first set the resource to work with.");
            return;
        }
        Configuration config = this.pc.getConfigurationManager().loadResourceConfiguration(this.resourceId);
        this.showConfig(config);
    }

    private void showConfig(Configuration config) {
        System.out.println(config.getProperties());
    }

    private static enum Command {
        ASCAN("as", "", 0, "Triggers an availability scan"),
        AVAIL("a", " ( id )", 0, "Shows an availability report. If id is given, only shows availability for resource with id id"),
        CHILDREN("chi", "id", 1, "Shows the direct children of the resource with the passed id"),
        DISCOVER("disc", " s | i | all", 1, "Triggers a discovery scan for (s)erver, serv(i)ce or all resources"),
        FIND("find", "r | t  | rt <name>", 2, "Searches a (r)esource, resource (t)ype or resources of (rt)ype. Use * as wildcard.\n Will set $r for the last resource shown."),
        HELP("h", "", 0, "Shows this help"),
        INVOKE("i", "operation [params]", 1, "Triggers running an operation. If operation is '-list' it shows available operations"),
        MEASURE("m", "datatype property+", 1, "Triggers getting metric values. All need to be of the same data type. If datatype is '-list' it shows the defined metrics"),
        NATIVE("n", "e | d | s", 1, "Enables/disables native system or shows native status"),
        QUIT("quit", "", 0, "Terminates the application"),
        RESOURCES("res", "", 0, "Shows the discovered resources"),
        SET("set", "'resource' N", 2, "Sets the resource id to work with. N can be a number or '$r' as result of last find resource call"),
        WAIT("w", "milliseconds", 1, "Waits the given amount of time"),
        P_CONFIG("pc", "", 0, "Shows the plugin configuration of the current resource."),
        R_CONFIG("rc", "", 0, "Shows the resource configuration of the current resource.");

        private String abbrev;
        private String args;
        private String help;
        private int minArgs;

        public String getArgs() {
            return this.args;
        }

        public String getHelp() {
            return this.help;
        }

        public int getMinArgs() {
            return this.minArgs;
        }

        private Command(String abbrev, String args, int minArgs, String help) {
            this.abbrev = abbrev;
            this.args = args;
            this.minArgs = minArgs;
            this.help = help;
        }

        public String getAbbrev() {
            return this.abbrev;
        }

        public static Command get(String s) {
            String upper = s.toUpperCase();
            for (Command c : EnumSet.allOf(Command.class)) {
                if (!c.name().equals(upper) && !c.getAbbrev().equals(s.toLowerCase())) continue;
                return c;
            }
            return null;
        }
    }
}

