/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.configuration;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.RawConfiguration;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.configuration.ConfigManagementSupport;
import org.rhq.core.pc.configuration.ConfigurationUpdateException;
import org.rhq.core.pluginapi.configuration.ResourceConfigurationFacet;

public class RawConfigManagement
extends ConfigManagementSupport {
    private final Log log = LogFactory.getLog(RawConfigManagement.class);

    @Override
    public Configuration executeLoad(int resourceId) throws PluginContainerException {
        ResourceConfigurationFacet facet = this.loadResouceConfiguratonFacet(resourceId);
        Set rawConfigs = facet.loadRawConfigurations();
        if (rawConfigs == null) {
            return null;
        }
        Configuration config = new Configuration();
        for (RawConfiguration rawConfig : rawConfigs) {
            config.addRawConfiguration(rawConfig);
        }
        if (config.getNotes() == null) {
            ResourceType resourceType = this.componentService.getResourceType(resourceId);
            config.setNotes("Resource config for " + resourceType.getName() + " Resource w/ id " + resourceId);
        }
        return config;
    }

    @Override
    public void executeUpdate(int resourceId, Configuration configuration) throws PluginContainerException {
        ResourceConfigurationFacet facet = this.loadResourceConfigFacetWithWriteLock(resourceId);
        StringBuilder errors = new StringBuilder();
        for (RawConfiguration rawConfig : configuration.getRawConfigurations()) {
            try {
                facet.validateRawConfiguration(rawConfig);
                facet.persistRawConfiguration(rawConfig);
            }
            catch (Throwable t) {
                errors.append(t.getMessage()).append("\n\n");
            }
        }
        if (errors.length() > 0) {
            throw new ConfigurationUpdateException(errors.toString());
        }
    }
}

