/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.operation;

import java.util.EnumSet;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.configuration.ConfigurationUtility;
import org.rhq.core.clientapi.server.operation.OperationServerService;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.pc.operation.OperationThreadPoolGateway;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.util.exception.ExceptionPackage;
import org.rhq.core.util.exception.Severity;

public class OperationInvocation
implements Runnable {
    private final Log log = LogFactory.getLog(OperationInvocation.class);
    private final int resourceId;
    private final long invocationTime;
    private final TimerTask timerTask;
    private final Configuration parameterConfig;
    private final String jobId;
    private final String operationName;
    private final OperationFacet operationComponent;
    private final OperationServerService operationServerService;
    private final OperationThreadPoolGateway operationThreadPoolGateway;
    private final OperationDefinition operationDefinition;
    private final EnumSet<Status> status;
    private Thread operationThread;

    public OperationInvocation(int resourceId, long invocationTime, TimerTask timerTask, Configuration parameterConfig, String jobId, String operationName, OperationFacet operationComponent, OperationServerService operationServerService, OperationThreadPoolGateway operationThreadPoolGateway, OperationDefinition operationDefinition) {
        this.resourceId = resourceId;
        this.invocationTime = invocationTime;
        this.timerTask = timerTask;
        this.parameterConfig = parameterConfig;
        this.jobId = jobId;
        this.operationName = operationName;
        this.operationComponent = operationComponent;
        this.operationServerService = operationServerService;
        this.operationThreadPoolGateway = operationThreadPoolGateway;
        this.operationDefinition = operationDefinition;
        this.status = EnumSet.of(Status.QUEUED);
        this.operationThread = null;
    }

    public int getResourceId() {
        return this.resourceId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("OperationInvocation: ");
        str.append("resource-id=[" + this.resourceId);
        str.append("], job-id=[" + this.jobId);
        str.append("], op-name=[" + this.operationName);
        str.append("], status=[" + this.getStatus());
        str.append("]");
        return str.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnumSet<Status> getStatus() {
        EnumSet<Status> enumSet = this.status;
        synchronized (enumSet) {
            return EnumSet.copyOf(this.status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnumSet<Status> markAsCanceled() {
        EnumSet<Status> enumSet = this.status;
        synchronized (enumSet) {
            EnumSet<Status> interruptedStatus = EnumSet.copyOf(this.status);
            if (!this.status.contains((Object)Status.FINISHED)) {
                this.status.add(Status.CANCELED);
                if (this.operationThread != null) {
                    this.operationThread.interrupt();
                }
            }
            return interruptedStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAsTimedOut() {
        EnumSet<Status> enumSet = this.status;
        synchronized (enumSet) {
            if (!this.status.contains((Object)Status.FINISHED)) {
                this.status.add(Status.TIMED_OUT);
                this.markAsCanceled();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean markAsRunning(Thread thread) {
        EnumSet<Status> enumSet = this.status;
        synchronized (enumSet) {
            this.operationThread = thread;
            this.status.remove((Object)Status.QUEUED);
            this.status.add(Status.RUNNING);
            return !this.status.contains((Object)Status.CANCELED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markAsFinished() {
        EnumSet<Status> enumSet = this.status;
        synchronized (enumSet) {
            this.operationThread = null;
            this.status.remove((Object)Status.QUEUED);
            this.status.remove((Object)Status.RUNNING);
            this.status.add(Status.FINISHED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long finishedTime;
        Configuration result = null;
        String errorMessage = null;
        Throwable failure = null;
        try {
            boolean canContinue = this.markAsRunning(Thread.currentThread());
            if (canContinue) {
                Configuration parameters = this.parameterConfig != null ? this.parameterConfig : new Configuration();
                OperationResult opResult = this.operationComponent.invokeOperation(this.operationName, parameters);
                Configuration configuration = result = opResult != null ? opResult.getComplexResults() : null;
                if (result != null) {
                    if (this.operationDefinition != null) {
                        if (this.operationDefinition.getResultsConfigurationDefinition() != null) {
                            ConfigurationUtility.normalizeConfiguration((Configuration)result, (ConfigurationDefinition)this.operationDefinition.getResultsConfigurationDefinition());
                        } else if (!result.getProperties().isEmpty()) {
                            this.log.error((Object)("Plugin error: Operation [" + this.operationDefinition.getName() + "] is defined as returning no results, but it returned non-null results: " + result.toString(true)));
                            result = null;
                        }
                    }
                    errorMessage = opResult.getErrorMessage();
                }
            } else {
                failure = new InterruptedException("Operation was aborted before it started.");
            }
        }
        catch (Throwable t) {
            failure = t;
        }
        finally {
            this.markAsFinished();
            this.timerTask.cancel();
            finishedTime = System.currentTimeMillis();
            this.operationThreadPoolGateway.operationCompleted(this);
        }
        if (this.operationServerService != null) {
            if (failure == null) {
                if (errorMessage == null) {
                    try {
                        this.operationServerService.operationSucceeded(this.jobId, result, this.invocationTime, finishedTime);
                    }
                    catch (Throwable t) {
                        this.log.error((Object)("Failed to send operation succeeded message to server. resource=[" + this.resourceId + "], operation=[" + this.operationName + "], jobId=[" + this.jobId + "]"), t);
                    }
                } else {
                    ExceptionPackage errorResults = new ExceptionPackage(Severity.Severe, (Throwable)new Exception(errorMessage));
                    try {
                        this.operationServerService.operationFailed(this.jobId, result, errorResults, this.invocationTime, finishedTime);
                    }
                    catch (Throwable t) {
                        this.log.error((Object)("Failed to send operation failed message to server. resource=[" + this.resourceId + "], operation=[" + this.operationName + "], jobId=[" + this.jobId + "]"), t);
                    }
                }
            } else if (this.status.contains((Object)Status.TIMED_OUT)) {
                try {
                    this.operationServerService.operationTimedOut(this.jobId, this.invocationTime, finishedTime);
                }
                catch (Throwable t) {
                    this.log.error((Object)("Failed to send operation timed out message to server. resource=[" + this.resourceId + "], operation=[" + this.operationName + "], jobId=[" + this.jobId + "]"), t);
                }
            } else {
                ExceptionPackage errorResults = this.status.contains((Object)Status.CANCELED) ? new ExceptionPackage(Severity.Info, (Throwable)new Exception("Canceled", failure)) : new ExceptionPackage(Severity.Severe, failure);
                try {
                    this.operationServerService.operationFailed(this.jobId, null, errorResults, this.invocationTime, finishedTime);
                }
                catch (Throwable t) {
                    this.log.error((Object)("Failed to send operation failed message to server. resource=[" + this.resourceId + "], operation=[" + this.operationName + "], jobId=[" + this.jobId + "], operation-error=[" + errorResults.toString() + "]"), t);
                }
            }
        }
    }

    public static enum Status {
        QUEUED,
        RUNNING,
        FINISHED,
        CANCELED,
        TIMED_OUT;

    }
}

