/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss42;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.J2eeApplicationMetaData;
import org.jboss.deployment.J2eeModuleMetaData;
import org.jboss.metadata.WebMetaData;
import org.jboss.metadata.WebSecurityMetaData;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.metadata.j2ee.JSEArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.JSESecurityMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSEArchiveMetaDataAdapter {
    public JSEArchiveMetaData buildUnifiedWebMetaData(Deployment dep, DeploymentInfo di) {
        J2eeApplicationMetaData appmd;
        String contextRoot = null;
        WebMetaData wmd = (WebMetaData)di.metaData;
        dep.addAttachment(WebMetaData.class, (Object)wmd);
        if (di.parent != null && (appmd = (J2eeApplicationMetaData)di.parent.metaData) != null) {
            Iterator it = appmd.getModules();
            while (it.hasNext()) {
                J2eeModuleMetaData module = (J2eeModuleMetaData)it.next();
                if (!module.getFileName().equals(dep.getSimpleName())) continue;
                contextRoot = module.getWebContext();
            }
        }
        if (contextRoot == null) {
            contextRoot = wmd.getContextRoot();
        }
        JSEArchiveMetaData webMetaData = new JSEArchiveMetaData();
        webMetaData.setContextRoot(contextRoot);
        webMetaData.setServletMappings((Map)wmd.getServletMappings());
        webMetaData.setServletClassNames(this.getServletClassMap(wmd));
        webMetaData.setConfigName(wmd.getConfigName());
        webMetaData.setConfigFile(wmd.getConfigFile());
        HashMap contextParams = wmd.getContextParams();
        if (contextParams.containsKey("jbossws-config-name")) {
            webMetaData.setConfigName((String)contextParams.get("jbossws-config-name"));
        }
        if (contextParams.containsKey("jbossws-config-file")) {
            webMetaData.setConfigFile((String)contextParams.get("jbossws-config-file"));
        }
        webMetaData.setSecurityDomain(wmd.getSecurityDomain());
        webMetaData.setPublishLocationAdapter(this.getPublishLocationAdpater(wmd));
        webMetaData.setSecurityMetaData(this.getSecurityMetaData(wmd.getSecurityContraints()));
        return webMetaData;
    }

    private JSEArchiveMetaData.PublishLocationAdapter getPublishLocationAdpater(final WebMetaData wmd) {
        return new JSEArchiveMetaData.PublishLocationAdapter(){

            public String getWsdlPublishLocationByName(String name) {
                return wmd.getWsdlPublishLocationByName(name);
            }
        };
    }

    private List<JSESecurityMetaData> getSecurityMetaData(Iterator securityConstraints) {
        ArrayList<JSESecurityMetaData> unifiedsecurityMetaData = new ArrayList<JSESecurityMetaData>();
        while (securityConstraints.hasNext()) {
            WebSecurityMetaData securityMetaData = (WebSecurityMetaData)securityConstraints.next();
            JSESecurityMetaData current = new JSESecurityMetaData();
            unifiedsecurityMetaData.add(current);
            current.setTransportGuarantee(securityMetaData.getTransportGuarantee());
            HashMap resources = securityMetaData.getWebResources();
            for (Object webResourceObj : resources.values()) {
                WebSecurityMetaData.WebResourceCollection webResource = (WebSecurityMetaData.WebResourceCollection)webResourceObj;
                JSESecurityMetaData.JSEResourceCollection currentResource = current.addWebResource(webResource.getName());
                for (String currentPattern : webResource.getUrlPatterns()) {
                    currentResource.addPattern(currentPattern);
                }
            }
        }
        return unifiedsecurityMetaData;
    }

    private Map<String, String> getServletClassMap(WebMetaData wmd) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        for (Map.Entry entry : wmd.getServletClassMap().entrySet()) {
            String servletName = (String)entry.getKey();
            String servletClass = (String)entry.getValue();
            if (servletClass == null) continue;
            mappings.put(servletName, servletClass);
        }
        return mappings;
    }
}

