/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command;

import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.communications.command.Command;
import org.rhq.enterprise.communications.command.CommandResponse;

public abstract class AbstractCommandResponse
implements CommandResponse {
    private boolean m_successful;
    private Object m_results;
    private Throwable m_exception;
    private Command m_command;
    private static final long serialVersionUID = 1L;

    public AbstractCommandResponse(Command command) {
        this(command, true, null, null);
    }

    public AbstractCommandResponse(Command command, boolean success, Object results, Throwable exception) {
        this.setCommand(command);
        this.setSuccessful(success);
        this.setResults(results);
        this.setException(exception);
    }

    public AbstractCommandResponse(CommandResponse responseToTransform) {
        this(responseToTransform.getCommand(), responseToTransform.isSuccessful(), responseToTransform.getResults(), responseToTransform.getException());
    }

    @Override
    public boolean isSuccessful() {
        return this.m_successful;
    }

    protected void setSuccessful(boolean success) {
        this.m_successful = success;
    }

    @Override
    public Object getResults() {
        return this.m_results;
    }

    protected void setResults(Object results) {
        this.m_results = results;
    }

    @Override
    public Throwable getException() {
        return this.m_exception;
    }

    protected void setException(Throwable exception) {
        this.m_exception = exception;
    }

    @Override
    public Command getCommand() {
        return this.m_command;
    }

    protected void setCommand(Command command) {
        if (command != null && command.isCommandInResponse()) {
            this.m_command = command;
        }
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer("Command Response: isSuccessful=[");
        strBuf.append(this.isSuccessful());
        strBuf.append("]; command=[");
        strBuf.append(this.getCommand());
        strBuf.append("]; results=[");
        strBuf.append(this.getResults());
        strBuf.append("]; exception=[");
        strBuf.append(ThrowableUtil.getAllMessages((Throwable)this.getException(), (boolean)true));
        strBuf.append("]");
        return strBuf.toString();
    }
}

