/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm.jdbc2;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.jms.JMSException;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.pm.jdbc2.PersistenceManager;

public class OracleThinPersistenceManager
extends PersistenceManager {
    protected String INSERT_EMPTY_BLOB = "INSERT INTO JMS_MESSAGES (MESSAGEID, DESTINATION, MESSAGEBLOB, TXID, TXOP) VALUES(?,?,EMPTY_BLOB(),?,?)";
    protected String LOCK_EMPTY_BLOB = "SELECT MESSAGEID, MESSAGEBLOB FROM JMS_MESSAGES WHERE MESSAGEID = ? AND DESTINATION = ? FOR UPDATE";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(Connection c, String queue, SpyMessage message, Tx txId, String mark) throws SQLException, IOException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = c.prepareStatement(this.INSERT_EMPTY_BLOB);
            stmt.setLong(1, message.header.messageId);
            stmt.setString(2, queue);
            if (txId != null) {
                stmt.setLong(3, txId.longValue());
            } else {
                stmt.setNull(3, -5);
            }
            stmt.setString(4, mark);
            int count = stmt.executeUpdate();
            this.safeClose(stmt, null);
            if (count != 1) {
                throw new IOException("Could not insert empty blob in the database: insert affected " + count + " rows. message=" + message);
            }
            stmt = c.prepareStatement(this.LOCK_EMPTY_BLOB);
            stmt.setLong(1, message.header.messageId);
            stmt.setString(2, queue);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new IOException("Could not lock empty blob in the database. message=" + message);
            }
            this.safeClose(stmt, rs);
            stmt = c.prepareStatement(this.UPDATE_MESSAGE);
            this.setBlob(stmt, 1, message);
            stmt.setLong(2, message.header.messageId);
            stmt.setString(3, queue);
            count = stmt.executeUpdate();
            this.safeClose(stmt, null);
            if (count != 1) {
                throw new IOException("Could not update real blob in the database: update affected " + count + " rows. message=" + message);
            }
            Object var10_9 = null;
            this.safeClose(stmt, rs);
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.safeClose(stmt, rs);
            throw throwable;
        }
    }

    public void startService() throws Exception {
        this.INSERT_EMPTY_BLOB = this.sqlProperties.getProperty("INSERT_EMPTY_BLOB", this.INSERT_EMPTY_BLOB);
        this.LOCK_EMPTY_BLOB = this.sqlProperties.getProperty("LOCK_EMPTY_BLOB", this.LOCK_EMPTY_BLOB);
        super.startService();
    }

    protected void safeClose(PreparedStatement stmt, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException ignored) {
            this.log.trace((Object)"Ignored", (Throwable)ignored);
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException ignored) {
            this.log.trace((Object)"Ignored", (Throwable)ignored);
        }
    }
}

