/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.augeas.util.Glob;
import org.rhq.augeas.util.GlobFilter;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceUpgradeReport;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ManualAddFacet;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeFacet;
import org.rhq.core.pluginapi.util.FileUtils;
import org.rhq.core.system.ProcessInfo;
import org.rhq.plugins.apache.ApacheServerComponent;
import org.rhq.plugins.apache.parser.ApacheConfigReader;
import org.rhq.plugins.apache.parser.ApacheDirective;
import org.rhq.plugins.apache.parser.ApacheDirectiveTree;
import org.rhq.plugins.apache.parser.ApacheParserImpl;
import org.rhq.plugins.apache.util.ApacheBinaryInfo;
import org.rhq.plugins.apache.util.AugeasNodeValueUtil;
import org.rhq.plugins.apache.util.HttpdAddressUtility;
import org.rhq.plugins.apache.util.OsProcessUtility;
import org.rhq.plugins.platform.PlatformComponent;

public class ApacheServerDiscoveryComponent
implements ResourceDiscoveryComponent<PlatformComponent>,
ManualAddFacet<PlatformComponent>,
ResourceUpgradeFacet<PlatformComponent> {
    private static final String PRODUCT_DESCRIPTION = "Apache Web Server";
    private static final Log log = LogFactory.getLog(ApacheServerDiscoveryComponent.class);

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<PlatformComponent> discoveryContext) throws Exception {
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        List processes = discoveryContext.getAutoDiscoveredProcesses();
        for (ProcessScanResult process : processes) {
            try {
                DiscoveredResourceDetails apache = this.discoverSingleProcess(discoveryContext, process);
                discoveredResources.add(apache);
            }
            catch (DiscoveryFailureException e) {
                log.warn((Object)("Discovery of Apache process [" + process.getProcessInfo() + "] failed: " + e.getMessage()));
            }
            catch (Exception e) {
                log.error((Object)("Discovery of Apache process [" + process.getProcessInfo() + "] failed with an exception."), (Throwable)e);
            }
        }
        return discoveredResources;
    }

    private DiscoveredResourceDetails discoverSingleProcess(ResourceDiscoveryContext<PlatformComponent> discoveryContext, ProcessScanResult process) throws DiscoveryFailureException, Exception {
        ApacheBinaryInfo binaryInfo;
        String executableName = ApacheServerDiscoveryComponent.getExecutableName(process);
        File executablePath = OsProcessUtility.getProcExe(process.getProcessInfo().getPid(), executableName);
        if (executablePath == null) {
            throw new DiscoveryFailureException("Executable path could not be determined.");
        }
        if (!executablePath.isAbsolute()) {
            throw new DiscoveryFailureException("Executable path (" + executablePath + ") is not absolute." + "Please restart Apache specifying an absolute path for the executable.");
        }
        log.debug((Object)("Apache executable path: " + executablePath));
        try {
            binaryInfo = ApacheBinaryInfo.getInfo(executablePath.getPath(), discoveryContext.getSystemInformation());
        }
        catch (Exception e) {
            throw new DiscoveryFailureException("'" + executablePath + "' is not a valid Apache executable (" + e + ").");
        }
        if (!this.isSupportedVersion(binaryInfo.getVersion())) {
            throw new DiscoveryFailureException("Apache " + binaryInfo.getVersion() + " is not suppported.");
        }
        String serverRoot = this.getServerRoot(binaryInfo, process.getProcessInfo());
        if (serverRoot == null) {
            throw new DiscoveryFailureException("Unable to determine server root.");
        }
        File serverConfigFile = this.getServerConfigFile(binaryInfo, process.getProcessInfo(), serverRoot);
        if (serverConfigFile == null) {
            throw new DiscoveryFailureException("Unable to determine server config file.");
        }
        Configuration pluginConfig = discoveryContext.getDefaultPluginConfiguration();
        PropertySimple executablePathProp = new PropertySimple("executablePath", (Object)executablePath);
        pluginConfig.put((Property)executablePathProp);
        PropertySimple serverRootProp = new PropertySimple("serverRoot", (Object)serverRoot);
        pluginConfig.put((Property)serverRootProp);
        PropertySimple configFile = new PropertySimple("configFile", (Object)serverConfigFile);
        pluginConfig.put((Property)configFile);
        PropertySimple inclusionGlobs = new PropertySimple("configurationFilesInclusionPatterns", (Object)serverConfigFile);
        pluginConfig.put((Property)inclusionGlobs);
        ApacheDirectiveTree serverConfig = ApacheServerDiscoveryComponent.loadParser(serverConfigFile.getAbsolutePath(), serverRoot);
        String serverUrl = null;
        String vhostsGlobInclude = null;
        List<ApacheDirective> serverRoots = serverConfig.search("/ServerRoot");
        if (!serverRoots.isEmpty()) {
            serverRoot = AugeasNodeValueUtil.unescape(serverRoots.get(0).getValuesAsString());
            serverRootProp.setValue((Object)serverRoot);
            serverConfig = ApacheServerDiscoveryComponent.loadParser(serverConfigFile.getAbsolutePath(), serverRoot);
        }
        serverUrl = ApacheServerDiscoveryComponent.getUrl(serverConfig, binaryInfo.getVersion());
        vhostsGlobInclude = ApacheServerDiscoveryComponent.scanForGlobInclude(serverConfig);
        if (serverUrl != null) {
            PropertySimple urlProp = new PropertySimple("url", (Object)serverUrl);
            pluginConfig.put((Property)urlProp);
        }
        if (vhostsGlobInclude != null) {
            pluginConfig.put((Property)new PropertySimple("vhostFilesMask", (Object)vhostsGlobInclude));
        } else if (serverConfigFile.exists()) {
            pluginConfig.put((Property)new PropertySimple("vhostFilesMask", (Object)(serverConfigFile.getParent() + File.separator + "*")));
        }
        List<InetSocketAddress> snmpAddresses = ApacheServerDiscoveryComponent.findSNMPAddresses(serverConfig, new File(serverRoot));
        if (snmpAddresses != null && snmpAddresses.size() > 0) {
            InetSocketAddress addr = snmpAddresses.get(0);
            int port = addr.getPort();
            InetAddress host = addr.getAddress() == null ? InetAddress.getLocalHost() : addr.getAddress();
            pluginConfig.put((Property)new PropertySimple("snmpAgentHost", (Object)host.getHostAddress()));
            pluginConfig.put((Property)new PropertySimple("snmpAgentPort", (Object)port));
        }
        return this.createResourceDetails(discoveryContext, pluginConfig, process.getProcessInfo(), binaryInfo);
    }

    public ResourceUpgradeReport upgrade(ResourceUpgradeContext<PlatformComponent> context) {
        String inventoriedResourceKey = context.getResourceKey();
        if (inventoriedResourceKey.contains("||")) {
            return null;
        }
        String resourceKey = ApacheServerDiscoveryComponent.formatResourceKey(context.getPluginConfiguration());
        ResourceUpgradeReport rep = new ResourceUpgradeReport();
        rep.setNewResourceKey(resourceKey);
        return rep;
    }

    public DiscoveredResourceDetails discoverResource(Configuration pluginConfig, ResourceDiscoveryContext<PlatformComponent> discoveryContext) throws InvalidPluginConfigurationException {
        ApacheBinaryInfo binaryInfo;
        ApacheServerDiscoveryComponent.validateServerRootAndServerConfigFile(pluginConfig);
        String executablePath = pluginConfig.getSimpleValue("executablePath", ApacheServerComponent.DEFAULT_EXECUTABLE_PATH);
        String absoluteExecutablePath = ApacheServerComponent.resolvePathRelativeToServerRoot(pluginConfig, executablePath).getPath();
        try {
            binaryInfo = ApacheBinaryInfo.getInfo(absoluteExecutablePath, discoveryContext.getSystemInformation());
        }
        catch (Exception e) {
            throw new InvalidPluginConfigurationException("'" + absoluteExecutablePath + "' is not a valid Apache executable (" + e + "). Please make sure the '" + "executablePath" + "' connection property is set correctly.");
        }
        if (!this.isSupportedVersion(binaryInfo.getVersion())) {
            throw new InvalidPluginConfigurationException("Version of Apache executable (" + binaryInfo.getVersion() + ") is not a supported version; supported versions are 1.3.x and 2.x.");
        }
        ProcessInfo processInfo = null;
        try {
            DiscoveredResourceDetails resourceDetails = this.createResourceDetails(discoveryContext, pluginConfig, processInfo, binaryInfo);
            return resourceDetails;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create resource details during manual add.");
        }
    }

    private boolean isSupportedVersion(String version) {
        return version != null && (version.startsWith("1.3") || version.startsWith("2."));
    }

    private DiscoveredResourceDetails createResourceDetails(ResourceDiscoveryContext<PlatformComponent> discoveryContext, Configuration pluginConfig, ProcessInfo processInfo, ApacheBinaryInfo binaryInfo) throws Exception {
        String name;
        String httpdConf = pluginConfig.getSimple("configFile").getStringValue();
        String version = binaryInfo.getVersion();
        String serverUrl = pluginConfig.getSimpleValue("url", null);
        if (serverUrl == null) {
            name = httpdConf;
        } else {
            URI uri = new URI(serverUrl);
            name = uri.getHost() + ":" + uri.getPort();
        }
        String key = ApacheServerDiscoveryComponent.formatResourceKey(pluginConfig);
        DiscoveredResourceDetails resourceDetails = new DiscoveredResourceDetails(discoveryContext.getResourceType(), key, name, version, PRODUCT_DESCRIPTION, pluginConfig, processInfo);
        log.debug((Object)("Apache Server resource details created: " + resourceDetails));
        return resourceDetails;
    }

    private static String getUrl(ApacheDirectiveTree serverConfig, String version) throws Exception {
        HttpdAddressUtility.Address addr = HttpdAddressUtility.get(version).getMainServerSampleAddress(serverConfig, null, 0);
        return addr == null ? null : addr.toString();
    }

    @Nullable
    private String getServerRoot(@NotNull ApacheBinaryInfo binaryInfo, @NotNull ProcessInfo processInfo) {
        String[] cmdLine = processInfo.getCommandLine();
        String root = this.getCommandLineOption(cmdLine, "-d");
        if (root == null) {
            root = binaryInfo.getRoot();
        }
        if (root == null) {
            return null;
        }
        File rootFile = new File(root);
        if (!rootFile.isAbsolute()) {
            String currentWorkingDir;
            try {
                currentWorkingDir = processInfo.getCurrentWorkingDirectory();
            }
            catch (Exception e) {
                log.error((Object)("Unable to determine current working directory of Apache process [" + processInfo + "], which is needed to determine the server root of the Apache instance."), (Throwable)e);
                return null;
            }
            if (currentWorkingDir == null) {
                log.error((Object)("Unable to determine current working directory of Apache process [" + processInfo + "], which is needed to determine the server root of the Apache instance."));
                return null;
            }
            rootFile = new File(currentWorkingDir, root);
            root = rootFile.getPath();
        }
        root = FileUtils.getCanonicalPath((String)root);
        return root;
    }

    @Nullable
    private File getServerConfigFile(ApacheBinaryInfo binaryInfo, ProcessInfo processInfo, String serverRoot) {
        String[] cmdLine = processInfo.getCommandLine();
        String serverConfigFile = this.getCommandLineOption(cmdLine, "-f");
        if (serverConfigFile == null) {
            serverConfigFile = binaryInfo.getCtl();
        }
        if (serverConfigFile == null) {
            return null;
        }
        File file = new File(serverConfigFile);
        if (!file.isAbsolute()) {
            file = new File(serverRoot, serverConfigFile);
            serverConfigFile = file.getPath();
        }
        serverConfigFile = FileUtils.getCanonicalPath((String)serverConfigFile);
        return new File(serverConfigFile);
    }

    private String getCommandLineOption(String[] cmdLine, String option) {
        String root = null;
        for (int i = 1; i < cmdLine.length; ++i) {
            String arg = cmdLine[i];
            if (!arg.startsWith(option)) continue;
            root = arg.substring(2, arg.length());
            if (root.length() != 0) break;
            root = cmdLine[i + 1];
            break;
        }
        return root;
    }

    private static String getExecutableName(ProcessScanResult processScanResult) {
        String query = processScanResult.getProcessScan().getQuery().toLowerCase();
        String executableName = query.contains("apache.exe") ? "apache.exe" : (query.contains("httpd.exe") ? "httpd.exe" : (query.contains("apache2") ? "apache2" : (query.contains("httpd") ? "httpd" : null)));
        return executableName;
    }

    private static void validateServerRootAndServerConfigFile(Configuration pluginConfig) {
        File httpdConfFile;
        File serverRootFile;
        String serverRoot = pluginConfig.getSimple("serverRoot").getStringValue();
        try {
            serverRootFile = new File(serverRoot).getCanonicalFile();
        }
        catch (IOException e) {
            serverRootFile = null;
        }
        if (serverRootFile == null || !serverRootFile.isDirectory()) {
            throw new InvalidPluginConfigurationException("'" + serverRoot + "' does not exist or is not a directory. Please make sure the '" + "serverRoot" + "' connection property is set correctly.");
        }
        String httpdConf = pluginConfig.getSimple("configFile").getStringValue();
        try {
            httpdConfFile = new File(httpdConf).getCanonicalFile();
        }
        catch (IOException e) {
            httpdConfFile = null;
        }
        if (httpdConfFile == null || !httpdConfFile.isFile()) {
            throw new InvalidPluginConfigurationException("'" + httpdConf + "' does not exist or is not a regular file. Please make sure the '" + "configFile" + "' connection property is set correctly.");
        }
    }

    private static ApacheDirectiveTree loadParser(String path, String serverRoot) throws Exception {
        ApacheDirectiveTree tree = new ApacheDirectiveTree();
        ApacheParserImpl parser = new ApacheParserImpl(tree, serverRoot);
        ApacheConfigReader.buildTree(path, parser);
        return tree;
    }

    public static String scanForGlobInclude(ApacheDirectiveTree tree) {
        try {
            List<ApacheDirective> includes = tree.search("/Include");
            block2: for (ApacheDirective n : includes) {
                String include = n.getValuesAsString();
                if (!Glob.isWildcard((String)include)) continue;
                for (char specialChar : GlobFilter.WILDCARD_CHARS) {
                    if (specialChar == '*') {
                        if (include.indexOf(specialChar) != include.lastIndexOf(specialChar)) continue block2;
                        return include;
                    }
                    if (include.indexOf(specialChar) >= 0) continue block2;
                }
            }
        }
        catch (Exception e) {
            log.debug((Object)"Failed to detect glob includes in httpd.conf.", (Throwable)e);
        }
        return null;
    }

    private static String formatResourceKey(Configuration pluginConfiguration) {
        String serverRoot = pluginConfiguration.getSimple("serverRoot").getStringValue();
        String httpdConf = pluginConfiguration.getSimple("configFile").getStringValue();
        serverRoot = FileUtils.getCanonicalPath((String)serverRoot);
        httpdConf = FileUtils.getCanonicalPath((String)httpdConf);
        return serverRoot + "||" + httpdConf;
    }

    private static List<InetSocketAddress> findSNMPAddresses(ApacheDirectiveTree tree, File serverRoot) {
        File snmpdConf;
        ArrayList<InetSocketAddress> ret = new ArrayList<InetSocketAddress>();
        List<ApacheDirective> confs = tree.search("/SNMPConf");
        if (confs.size() == 0) {
            log.info((Object)"SNMPConf directive not found. Skipping SNMP configuration.");
            return ret;
        }
        String confDirName = confs.get(0).getValuesAsString();
        if (confDirName == null || confDirName.isEmpty()) {
            log.warn((Object)"The SNMPConf directive seems to not have a value. Skipping SNMP configuration.");
            return ret;
        }
        File confDir = new File(confDirName);
        if (!confDir.isAbsolute()) {
            confDir = new File(serverRoot, confDirName);
        }
        if (!(snmpdConf = new File(confDir, "snmpd.conf")).exists()) {
            log.warn((Object)("Could not find a snmpd.conf file under the configured directory '" + confDirName + "'. Skipping SNMP configuration."));
            return ret;
        }
        try {
            String agentAddressLine = ApacheServerDiscoveryComponent.findSNMPAgentAddressConfigLine(snmpdConf);
            if (agentAddressLine == null) {
                log.warn((Object)"Could not find the 'agentaddress' property in the snmpd.conf. Skipping SNMP configuration.");
                return ret;
            }
            int specStartIdx = agentAddressLine.indexOf("agentaddress") + "agentaddress".length() + 1;
            while (Character.isWhitespace(agentAddressLine.charAt(specStartIdx))) {
                ++specStartIdx;
            }
            String spec = agentAddressLine.substring(specStartIdx);
            String[] addrs = spec.split(",");
            try {
                for (String addr : addrs) {
                    if (addr.startsWith("udp") || addr.startsWith("tcp")) {
                        addr = addr.substring(4);
                    }
                    int atIdx = addr.indexOf(64);
                    String port = addr;
                    String host = null;
                    if (atIdx > 0) {
                        host = addr.substring(atIdx + 1);
                        port = addr.substring(0, atIdx);
                    }
                    InetSocketAddress address = null;
                    address = host != null ? new InetSocketAddress(host, Integer.parseInt(port)) : new InetSocketAddress(Integer.parseInt(port));
                    ret.add(address);
                }
            }
            catch (Exception e) {
                log.warn((Object)("Failed to parse the SNMP 'agentaddress' configuration property: " + agentAddressLine), (Throwable)e);
            }
        }
        catch (IOException e) {
            log.warn((Object)("Failed to read in the configured snmpd.conf file: " + snmpdConf.getAbsolutePath()), (Throwable)e);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String findSNMPAgentAddressConfigLine(File snmpdConf) throws IOException {
        BufferedReader rdr = new BufferedReader(new FileReader(snmpdConf));
        try {
            String line;
            Pattern search = Pattern.compile("^\\s*agentaddress.*");
            while ((line = rdr.readLine()) != null) {
                if (!search.matcher(line).matches()) continue;
                String string = line;
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            rdr.close();
        }
    }

    private static class DiscoveryFailureException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public DiscoveryFailureException(String message) {
            super(message);
        }
    }
}

