/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache;

import java.io.File;
import java.util.List;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.operation.OperationContext;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.pluginapi.util.ProcessExecutionUtility;
import org.rhq.core.system.OperatingSystemType;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.SystemInfo;
import org.rhq.plugins.apache.ApacheServerComponent;
import org.rhq.plugins.apache.ModJKComponent;

public class ApacheServerOperationsDelegate
implements OperationFacet {
    private static final String EXIT_CODE_RESULT_PROP = "exitCode";
    private static final String OUTPUT_RESULT_PROP = "output";
    private ApacheServerComponent serverComponent;
    private SystemInfo systemInfo;
    private Configuration serverPluginConfiguration;

    public ApacheServerOperationsDelegate(ApacheServerComponent serverComponent, Configuration serverPluginConfiguration, SystemInfo systemInfo) {
        this.serverComponent = serverComponent;
        this.systemInfo = systemInfo;
        this.serverPluginConfiguration = serverPluginConfiguration;
    }

    public void startOperationFacet(OperationContext context) {
    }

    public OperationResult invokeOperation(String name, Configuration params) throws Exception {
        if ("install_mod_jk".equals(name)) {
            return ModJKComponent.installModJk(this.serverComponent, params);
        }
        Operation operation = ApacheServerOperationsDelegate.getOperation(name);
        File controlScriptPath = this.serverComponent.getControlScriptPath();
        ApacheServerOperationsDelegate.validateScriptFile(controlScriptPath);
        ProcessExecution processExecution = ProcessExecutionUtility.createProcessExecution((File)controlScriptPath);
        processExecution.setWaitForCompletion(30000L);
        processExecution.setCaptureOutput(true);
        this.addDefaultArguments(processExecution);
        if (operation != Operation.CONFIG_TEST) {
            processExecution.getArguments().add("-k");
        }
        switch (operation) {
            case START: {
                processExecution.getArguments().add("start");
                break;
            }
            case STOP: {
                processExecution.getArguments().add("stop");
                break;
            }
            case RESTART: {
                this.abortIfOsIsWindows(name);
                processExecution.getArguments().add("restart");
                break;
            }
            case START_SSL: {
                this.abortIfOsIsWindows(name);
                processExecution.getArguments().add("startssl");
                break;
            }
            case GRACEFUL_RESTART: {
                processExecution.getArguments().add(this.osIsWindows() ? "restart" : "graceful");
                break;
            }
            case CONFIG_TEST: {
                processExecution.getArguments().add("-t");
            }
        }
        ProcessExecutionResults processExecutionResults = this.systemInfo.executeProcess(processExecution);
        Integer exitCode = processExecutionResults.getExitCode();
        if (processExecutionResults.getError() != null || exitCode != null && exitCode != 0) {
            String msg = "Operation " + (Object)((Object)operation) + " failed. Exit code: [" + exitCode + "]\n, Output : [" + processExecutionResults.getCapturedOutput() + "]\n" + "Error: [" + processExecutionResults.getError() + "]";
            throw new Exception(msg);
        }
        return this.createOperationResult(processExecutionResults);
    }

    private void addDefaultArguments(ProcessExecution processExecution) throws Exception {
        List args = processExecution.getArguments();
        args.add("-d");
        args.add(this.serverPluginConfiguration.getSimpleValue("serverRoot", null));
        args.add("-f");
        args.add(this.serverPluginConfiguration.getSimpleValue("configFile", null));
    }

    private OperationResult createOperationResult(ProcessExecutionResults processExecutionResults) {
        OperationResult operationResult = new OperationResult();
        Integer exitCode = processExecutionResults.getExitCode();
        String output = processExecutionResults.getCapturedOutput();
        Configuration complexResults = operationResult.getComplexResults();
        complexResults.put((Property)new PropertySimple(EXIT_CODE_RESULT_PROP, (Object)exitCode));
        complexResults.put((Property)new PropertySimple(OUTPUT_RESULT_PROP, (Object)output));
        return operationResult;
    }

    private boolean osIsWindows() {
        return this.systemInfo.getOperatingSystemType() == OperatingSystemType.WINDOWS;
    }

    private static void validateScriptFile(File scriptFile) {
        if (!scriptFile.exists()) {
            throw new IllegalStateException("Script (" + scriptFile + ") specified via '" + "controlScriptPath" + "' connection property does not exist.");
        }
        if (scriptFile.isDirectory()) {
            throw new IllegalStateException("Script (" + scriptFile + ") specified via '" + "controlScriptPath" + "' connection property is a directory, not a file.");
        }
    }

    private static Operation getOperation(String name) {
        Operation operation;
        try {
            operation = Operation.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid operation name: " + name);
        }
        return operation;
    }

    private void abortIfOsIsWindows(String name) {
        if (this.osIsWindows()) {
            throw new IllegalArgumentException("The " + name + " operation is not supported on Windows.");
        }
    }

    private static enum Operation {
        START,
        STOP,
        RESTART,
        START_SSL,
        GRACEFUL_RESTART,
        CONFIG_TEST;

    }
}

