/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pluginapi.inventory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.ConfigurationTemplate;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.PluginContainerDeployment;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.system.SystemInfo;

public class ResourceDiscoveryContext<T extends ResourceComponent> {
    private final ResourceType resourceType;
    private final T parentComponent;
    private final PluginContainerDeployment pluginContainerDeployment;
    private final ResourceContext parentResourceContext;
    private final SystemInfo systemInformation;
    private final List<ProcessScanResult> processScanResults;
    private final List<Configuration> pluginConfigurations;
    private final String pluginContainerName;

    public ResourceDiscoveryContext(ResourceType resourceType, T parentComponent, ResourceContext parentResourceContext, SystemInfo systemInfo, List<ProcessScanResult> processScanResults, String pluginContainerName, PluginContainerDeployment pluginContainerDeployment) {
        this(resourceType, parentComponent, parentResourceContext, systemInfo, processScanResults, null, pluginContainerName, pluginContainerDeployment);
    }

    public ResourceDiscoveryContext(ResourceType resourceType, T parentComponent, ResourceContext parentResourceContext, SystemInfo systemInfo, List<ProcessScanResult> processScanResults, List<Configuration> pluginConfigurations, String pluginContainerName, PluginContainerDeployment pluginContainerDeployment) {
        this.resourceType = resourceType;
        this.parentComponent = parentComponent;
        this.parentResourceContext = parentResourceContext;
        this.systemInformation = systemInfo;
        this.processScanResults = processScanResults != null ? processScanResults : Collections.EMPTY_LIST;
        this.pluginConfigurations = pluginConfigurations != null ? pluginConfigurations : Collections.EMPTY_LIST;
        this.pluginContainerName = pluginContainerName;
        this.pluginContainerDeployment = pluginContainerDeployment;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public T getParentResourceComponent() {
        return this.parentComponent;
    }

    public ResourceContext getParentResourceContext() {
        return this.parentResourceContext;
    }

    public SystemInfo getSystemInformation() {
        return this.systemInformation;
    }

    @NotNull
    public List<ProcessScanResult> getAutoDiscoveredProcesses() {
        return new ArrayList<ProcessScanResult>(this.processScanResults);
    }

    @Deprecated
    @NotNull
    public List<Configuration> getPluginConfigurations() {
        return new ArrayList<Configuration>(this.pluginConfigurations);
    }

    public Configuration getDefaultPluginConfiguration() {
        ConfigurationTemplate template;
        ConfigurationDefinition definition = this.resourceType.getPluginConfigurationDefinition();
        if (definition != null && (template = definition.getDefaultTemplate()) != null) {
            return template.getConfiguration().deepCopy();
        }
        return new Configuration();
    }

    public String getPluginContainerName() {
        return this.pluginContainerName;
    }

    public PluginContainerDeployment getPluginContainerDeployment() {
        return this.pluginContainerDeployment;
    }
}

