/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.bundle;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import javax.ejb.Remote;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.bundle.Bundle;
import org.rhq.core.domain.bundle.BundleDeployment;
import org.rhq.core.domain.bundle.BundleDestination;
import org.rhq.core.domain.bundle.BundleFile;
import org.rhq.core.domain.bundle.BundleResourceDeployment;
import org.rhq.core.domain.bundle.BundleType;
import org.rhq.core.domain.bundle.BundleVersion;
import org.rhq.core.domain.bundle.composite.BundleWithLatestVersionComposite;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.content.Architecture;
import org.rhq.core.domain.criteria.BundleCriteria;
import org.rhq.core.domain.criteria.BundleDeploymentCriteria;
import org.rhq.core.domain.criteria.BundleDestinationCriteria;
import org.rhq.core.domain.criteria.BundleFileCriteria;
import org.rhq.core.domain.criteria.BundleResourceDeploymentCriteria;
import org.rhq.core.domain.criteria.BundleVersionCriteria;
import org.rhq.core.domain.util.PageList;

@SOAPBinding(style=SOAPBinding.Style.DOCUMENT)
@WebService(targetNamespace="http://www.rhq-project.org/4.0.0.Beta1/Webservices.xsd")
@Remote
public interface BundleManagerRemote {
    @WebMethod
    public BundleFile addBundleFile(@WebParam(name="subject") Subject var1, @WebParam(name="bundleVersionid") int var2, @WebParam(name="name") String var3, @WebParam(name="version") String var4, @WebParam(name="architecture") Architecture var5, @WebParam(name="fileStream") InputStream var6) throws Exception;

    public BundleFile addBundleFileViaByteArray(@WebParam(name="subject") Subject var1, @WebParam(name="bundleVersionid") int var2, @WebParam(name="name") String var3, @WebParam(name="version") String var4, @WebParam(name="architecture") Architecture var5, @WebParam(name="fileBytes") byte[] var6) throws Exception;

    public BundleFile addBundleFileViaURL(@WebParam(name="subject") Subject var1, @WebParam(name="bundleVersionid") int var2, @WebParam(name="name") String var3, @WebParam(name="version") String var4, @WebParam(name="architecture") Architecture var5, @WebParam(name="bundleFileUrl") String var6) throws Exception;

    public BundleFile addBundleFileViaPackageVersion(@WebParam(name="subject") Subject var1, @WebParam(name="bundleVersionid") int var2, @WebParam(name="name") String var3, @WebParam(name="packageVersionId") int var4) throws Exception;

    public BundleDeployment createBundleDeployment(@WebParam(name="subject") Subject var1, @WebParam(name="bundleVersionId") int var2, @WebParam(name="bundleDestinationId") int var3, @WebParam(name="description") String var4, @WebParam(name="configuration") Configuration var5) throws Exception;

    public BundleDestination createBundleDestination(@WebParam(name="subject") Subject var1, @WebParam(name="bundleId") int var2, @WebParam(name="name") String var3, @WebParam(name="description") String var4, @WebParam(name="deployDir") String var5, @WebParam(name="groupId") Integer var6) throws Exception;

    public BundleVersion createBundleVersionViaRecipe(@WebParam(name="subject") Subject var1, @WebParam(name="recipe") String var2) throws Exception;

    public BundleVersion createBundleVersionViaFile(@WebParam(name="subject") Subject var1, @WebParam(name="distributionFile") File var2) throws Exception;

    public BundleVersion createBundleVersionViaURL(@WebParam(name="subject") Subject var1, @WebParam(name="distributionFileUrl") String var2) throws Exception;

    @WebMethod
    public void deleteBundles(@WebParam(name="subject") Subject var1, @WebParam(name="bundleIds") int[] var2) throws Exception;

    @WebMethod
    public void deleteBundle(@WebParam(name="subject") Subject var1, @WebParam(name="bundleId") int var2) throws Exception;

    @WebMethod
    public void deleteBundleVersion(@WebParam(name="subject") Subject var1, @WebParam(name="bundleVersionId") int var2, @WebParam(name="deleteBundleIfEmpty") boolean var3) throws Exception;

    @WebMethod
    public PageList<Bundle> findBundlesByCriteria(@WebParam(name="subject") Subject var1, @WebParam(name="criteria") BundleCriteria var2);

    @WebMethod
    public PageList<BundleDeployment> findBundleDeploymentsByCriteria(@WebParam(name="subject") Subject var1, @WebParam(name="criteria") BundleDeploymentCriteria var2);

    @WebMethod
    public PageList<BundleDestination> findBundleDestinationsByCriteria(@WebParam(name="subject") Subject var1, @WebParam(name="criteria") BundleDestinationCriteria var2);

    @WebMethod
    public PageList<BundleResourceDeployment> findBundleResourceDeploymentsByCriteria(@WebParam(name="subject") Subject var1, @WebParam(name="BundleResourceDeploymentCriteria") BundleResourceDeploymentCriteria var2);

    @WebMethod
    public PageList<BundleFile> findBundleFilesByCriteria(@WebParam(name="subject") Subject var1, @WebParam(name="criteria") BundleFileCriteria var2);

    @WebMethod
    public PageList<BundleVersion> findBundleVersionsByCriteria(@WebParam(name="subject") Subject var1, @WebParam(name="criteria") BundleVersionCriteria var2);

    @WebMethod
    public PageList<BundleWithLatestVersionComposite> findBundlesWithLatestVersionCompositesByCriteria(@WebParam(name="subject") Subject var1, @WebParam(name="criteria") BundleCriteria var2);

    @WebMethod
    public List<BundleType> getAllBundleTypes(@WebParam(name="subject") Subject var1);

    @WebMethod
    public BundleType getBundleType(@WebParam(name="subject") Subject var1, @WebParam(name="bundleTypeName") String var2);

    public Set<String> getBundleVersionFilenames(@WebParam(name="subject") Subject var1, @WebParam(name="bundleVersionId") int var2, @WebParam(name="withoutBundleFileOnly") boolean var3) throws Exception;

    @WebMethod
    public void purgeBundleDestination(@WebParam(name="subject") Subject var1, @WebParam(name="bundleDestinationId") int var2) throws Exception;

    @WebMethod
    public BundleDeployment scheduleBundleDeployment(@WebParam(name="subject") Subject var1, @WebParam(name="bundleDeploymentId") int var2, @WebParam(name="isCleanDeployment") boolean var3) throws Exception;

    @WebMethod
    public BundleDeployment scheduleRevertBundleDeployment(@WebParam(name="subject") Subject var1, @WebParam(name="bundleDestinationId") int var2, @WebParam(name="deploymentDescription") String var3, @WebParam(name="isCleanDeployment") boolean var4) throws Exception;
}

