/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.perspective.activator.context;

import java.util.EnumSet;
import java.util.Set;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.criteria.ResourceGroupCriteria;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.ResourceTypeFacet;
import org.rhq.core.domain.resource.composite.ResourceFacets;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.perspective.activator.context.AbstractResourceOrGroupActivationContext;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class GroupActivationContext
extends AbstractResourceOrGroupActivationContext {
    private ResourceGroup group;
    transient EnumSet<ResourceTypeFacet> facets;
    transient EnumSet<Permission> resourcePermissions;
    private ResourceTypeManagerLocal resourceTypeManager = LookupUtil.getResourceTypeManager();
    private AuthorizationManagerLocal authorizationManager = LookupUtil.getAuthorizationManager();

    public GroupActivationContext(Subject subject, ResourceGroup group) {
        super(subject);
        this.group = group;
    }

    @Override
    public ResourceType getResourceType() {
        return this.group.getResourceType();
    }

    @Override
    public EnumSet<ResourceTypeFacet> getFacets() {
        if (this.facets == null) {
            ResourceFacets resourceFacets = this.resourceTypeManager.getResourceFacets(this.getResourceType().getId());
            this.facets = EnumSet.copyOf(resourceFacets.getFacets());
        }
        return this.facets;
    }

    @Override
    public EnumSet<Permission> getResourcePermissions() {
        if (this.resourcePermissions == null) {
            Set<Permission> perms = this.authorizationManager.getImplicitGroupPermissions(this.getSubject(), this.group.getId());
            this.resourcePermissions = EnumSet.copyOf(perms);
        }
        return this.resourcePermissions;
    }

    @Override
    public Set<Resource> getResources() {
        if (null == this.group.getExplicitResources()) {
            ResourceGroupCriteria criteria = new ResourceGroupCriteria();
            criteria.addFilterId(Integer.valueOf(this.group.getId()));
            criteria.fetchExplicitResources(true);
            PageList<ResourceGroup> resourceGroups = LookupUtil.getResourceGroupManager().findResourceGroupsByCriteria(this.getSubject(), criteria);
            if (!resourceGroups.isEmpty()) {
                this.group.setExplicitResources(((ResourceGroup)resourceGroups.get(0)).getExplicitResources());
            }
        }
        return this.group.getExplicitResources();
    }

    public ResourceGroup getGroup() {
        return this.group;
    }
}

