/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.search.assist;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.rhq.core.domain.alert.AlertPriority;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.search.SearchSubsystem;
import org.rhq.core.domain.search.assist.AlertSearchAssistParam;
import org.rhq.enterprise.server.search.assist.TabAwareSearchAssistant;

public class ResourceSearchAssistant
extends TabAwareSearchAssistant {
    private static final List<String> parameterizedContexts = Collections.unmodifiableList(Arrays.asList("alerts", "connection", "configuration", "trait"));
    private static final List<String> simpleContexts = Collections.unmodifiableList(Arrays.asList("availability", "category", "type", "plugin", "name"));

    public ResourceSearchAssistant(Subject subject, String tab) {
        super(subject, tab);
    }

    @Override
    public SearchSubsystem getSearchSubsystem() {
        return SearchSubsystem.RESOURCE;
    }

    @Override
    public String getPrimarySimpleContext() {
        return "name";
    }

    @Override
    public List<String> getSimpleContexts() {
        return simpleContexts;
    }

    @Override
    public List<String> getParameterizedContexts() {
        return parameterizedContexts;
    }

    @Override
    public boolean isEnumContext(String context) {
        return context.equals("alerts");
    }

    @Override
    public List<String> getParameters(String context, String filter) {
        filter = this.stripQuotes(filter);
        if (context.equals("alerts")) {
            return this.filter(AlertSearchAssistParam.class, filter);
        }
        if (context.equals("connection")) {
            return this.execute("SELECT DISTINCT definition.name   FROM ResourceType type, Resource res, PropertyDefinitionSimple simpleDefinition   JOIN type.pluginConfigurationDefinition.propertyDefinitions definition  WHERE res.resourceType = type    AND type.deleted = false   AND simpleDefinition = definition    AND simpleDefinition.type <> 'PASSWORD' " + this.conditionallyAddJPQLString("definition.name", filter) + this.conditionallyAddJPQLString("type.category", this.tab) + this.conditionallyAddAuthzFragment(this.getAuthzFragment()) + " ORDER BY definition.name ");
        }
        if (context.equals("configuration")) {
            return this.execute("SELECT DISTINCT definition.name   FROM ResourceType type, Resource res, PropertyDefinitionSimple simpleDefinition   JOIN type.resourceConfigurationDefinition.propertyDefinitions definition  WHERE res.resourceType = type    AND type.deleted = false   AND simpleDefinition = definition    AND simpleDefinition.type <> 'PASSWORD' " + this.conditionallyAddJPQLString("definition.name", filter) + this.conditionallyAddJPQLString("type.category", this.tab) + this.conditionallyAddAuthzFragment(this.getConfigAuthzFragment()) + " ORDER BY definition.name ");
        }
        if (context.equals("trait")) {
            return this.execute("SELECT DISTINCT def.name   FROM MeasurementSchedule ms, Resource res   JOIN ms.definition def  WHERE ms.resource = res    AND def.dataType = " + DataType.TRAIT.ordinal() + this.conditionallyAddJPQLString("ms.definition.name", filter) + this.conditionallyAddJPQLString("res.resourceType.category", this.tab) + this.conditionallyAddAuthzFragment(this.getAuthzFragment()) + " ORDER BY def.name ");
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getValues(String context, String param, String filter) {
        filter = this.stripQuotes(filter);
        if (context.equals("availability")) {
            return this.filter(AvailabilityType.class, filter);
        }
        if (context.equals("category")) {
            return this.filter(ResourceCategory.class, filter);
        }
        if (context.equals("type")) {
            return this.execute("SELECT DISTINCT type.name   FROM Resource res, ResourceType type  WHERE res.resourceType = type " + this.conditionallyAddJPQLString("type.name", filter) + this.conditionallyAddJPQLString("type.category", this.tab) + this.conditionallyAddAuthzFragment(this.getAuthzFragment()) + " ORDER BY type.name ");
        }
        if (context.equals("plugin")) {
            return this.execute("SELECT DISTINCT type.plugin   FROM Resource res, ResourceType type  WHERE res.resourceType = type " + this.conditionallyAddJPQLString("type.plugin", filter) + this.conditionallyAddJPQLString("type.category", this.tab) + this.conditionallyAddAuthzFragment(this.getAuthzFragment()) + " ORDER BY type.plugin ");
        }
        if (context.equals("name")) {
            return this.execute("SELECT DISTINCT res.name   FROM Resource res, ResourceType type  WHERE res.resourceType = type " + this.conditionallyAddJPQLString("res.name", filter) + this.conditionallyAddJPQLString("type.category", this.tab) + this.conditionallyAddAuthzFragment(this.getAuthzFragment()) + " ORDER BY res.name ");
        }
        if (context.equals("alerts")) {
            return this.filter(AlertPriority.class, filter, true);
        }
        if (context.equals("connection")) {
            return this.execute("SELECT DISTINCT simple.stringValue   FROM Resource res, PropertySimple simple, PropertyDefinitionSimple simpleDefinition   JOIN res.pluginConfiguration.properties property   JOIN res.resourceType.pluginConfigurationDefinition.propertyDefinitions propertyDefinition  WHERE simpleDefinition = propertyDefinition    AND simpleDefinition.type <> 'PASSWORD'    AND property = simple    AND property.name = propertyDefinition.name " + this.conditionallyAddJPQLString("property.name", param) + this.conditionallyAddJPQLString("property.stringValue", filter) + this.conditionallyAddJPQLString("res.resourceType.category", this.tab) + this.conditionallyAddAuthzFragment(this.getAuthzFragment()) + " ORDER BY simple.stringValue ");
        }
        if (context.equals("configuration")) {
            return this.execute("SELECT DISTINCT simple.stringValue   FROM Resource res, PropertySimple simple, PropertyDefinitionSimple simpleDefinition   JOIN res.resourceConfiguration.properties property   JOIN res.resourceType.resourceConfigurationDefinition.propertyDefinitions propertyDefinition  WHERE simpleDefinition = propertyDefinition    AND simpleDefinition.type <> 'PASSWORD'    AND property = simple    AND property.name = propertyDefinition.name " + this.conditionallyAddJPQLString("property.name", param) + this.conditionallyAddJPQLString("property.stringValue", filter) + this.conditionallyAddJPQLString("res.resourceType.category", this.tab) + this.conditionallyAddAuthzFragment(this.getConfigAuthzFragment()) + " ORDER BY simple.stringValue ");
        }
        if (context.equals("trait")) {
            return this.execute("SELECT DISTINCT trait.value   FROM MeasurementDataTrait trait, Resource res   JOIN trait.schedule ms  WHERE ms.definition.dataType = 1    AND ms.resource = res " + this.conditionallyAddJPQLString("ms.definition.name", param) + this.conditionallyAddJPQLString("trait.value", filter) + this.conditionallyAddJPQLString("res.resourceType.category", this.tab) + this.conditionallyAddAuthzFragment(this.getAuthzFragment()) + " ORDER BY trait.value ");
        }
        return Collections.emptyList();
    }

    private String getConfigAuthzFragment() {
        return "res.id IN (SELECT ires.id    FROM Resource ires    JOIN ires.implicitGroups igroup    JOIN igroup.roles irole    JOIN irole.subjects isubject    JOIN irole.permissions iperm   WHERE isubject.id = " + this.getSubjectId() + "    AND iperm = " + Permission.CONFIGURE_READ.ordinal() + ")";
    }

    private String getAuthzFragment() {
        return "res.id IN (SELECT ires.id    FROM Resource ires    JOIN ires.implicitGroups igroup    JOIN igroup.roles irole    JOIN irole.subjects isubject   WHERE isubject.id = " + this.getSubjectId() + ")";
    }
}

