/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.script;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ManualAddFacet;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.plugins.script.ScriptServerComponent;

public class ScriptDiscoveryComponent
implements ResourceDiscoveryComponent,
ManualAddFacet {
    private final Log log = LogFactory.getLog(ScriptDiscoveryComponent.class);

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext context) {
        this.log.info((Object)"Processing discovered management script resources");
        HashSet<DiscoveredResourceDetails> details = new HashSet<DiscoveredResourceDetails>();
        List autoDiscoveryResults = context.getAutoDiscoveredProcesses();
        for (ProcessScanResult autoDiscoveryResult : autoDiscoveryResults) {
            DiscoveredResourceDetails autoDiscovered = this.processAutoDiscoveredResource(context, autoDiscoveryResult);
            if (autoDiscovered == null) continue;
            details.add(autoDiscovered);
        }
        return details;
    }

    public DiscoveredResourceDetails discoverResource(Configuration pluginConfig, ResourceDiscoveryContext discoveryContext) throws InvalidPluginConfigurationException {
        String executable = pluginConfig.getSimple("executable").getStringValue();
        String version = this.determineVersion(discoveryContext, pluginConfig);
        String description = this.determineDescription(discoveryContext, pluginConfig);
        DiscoveredResourceDetails details = new DiscoveredResourceDetails(discoveryContext.getResourceType(), executable, new File(executable).getName(), version, description, pluginConfig, null);
        return details;
    }

    protected DiscoveredResourceDetails processAutoDiscoveredResource(ResourceDiscoveryContext context, ProcessScanResult autoDiscoveryResult) {
        return null;
    }

    protected String determineDescription(ResourceDiscoveryContext context, Configuration pluginConfig) {
        String description = null;
        try {
            PropertySimple descriptionProp = pluginConfig.getSimple("fixedDescription");
            if (descriptionProp != null && descriptionProp.getStringValue() != null) {
                description = descriptionProp.getStringValue();
            } else {
                String args = pluginConfig.getSimpleValue("descriptionArguments", null);
                ProcessExecutionResults results = ScriptServerComponent.executeExecutable(context.getSystemInformation(), pluginConfig, args, 5000L, true);
                if (results != null) {
                    if (results.getError() != null) {
                        this.log.warn((Object)("Failed to execute cli executable to get description. Cause: " + ThrowableUtil.getAllMessages((Throwable)results.getError())));
                    } else if (results.getCapturedOutput() != null) {
                        String regex = pluginConfig.getSimpleValue("descriptionRegex", null);
                        String output = results.getCapturedOutput();
                        if (regex == null) {
                            description = output;
                        } else {
                            Pattern pattern = Pattern.compile(regex);
                            Matcher match = pattern.matcher(output);
                            if (match.find()) {
                                description = match.groupCount() > 0 ? match.group(1) : output;
                            } else {
                                this.log.warn((Object)("Description regex [" + regex + "] did not match: " + this.truncateString(output)));
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Cannot determine description of CLI server resource. Cause: " + e));
        }
        return description;
    }

    protected String determineVersion(ResourceDiscoveryContext context, Configuration pluginConfig) {
        String version = null;
        try {
            PropertySimple versionProp = pluginConfig.getSimple("fixedVersion");
            if (versionProp != null && versionProp.getStringValue() != null) {
                version = versionProp.getStringValue();
            } else {
                String args = pluginConfig.getSimpleValue("versionArguments", null);
                ProcessExecutionResults results = ScriptServerComponent.executeExecutable(context.getSystemInformation(), pluginConfig, args, 5000L, true);
                if (results != null) {
                    if (results.getError() != null) {
                        this.log.warn((Object)("Failed to execute cli executable to get version. Cause: " + ThrowableUtil.getAllMessages((Throwable)results.getError())));
                    } else if (results.getCapturedOutput() != null) {
                        String regex = pluginConfig.getSimpleValue("versionRegex", null);
                        String output = results.getCapturedOutput();
                        if (regex == null) {
                            version = output;
                        } else {
                            Pattern pattern = Pattern.compile(regex);
                            Matcher match = pattern.matcher(output);
                            if (match.find()) {
                                version = match.groupCount() > 0 ? match.group(1) : output;
                            } else {
                                this.log.warn((Object)("Version regex [" + regex + "] did not match: " + this.truncateString(output)));
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Cannot determine version of CLI server resource. Cause: " + e));
        }
        return version;
    }

    private String truncateString(String output) {
        String outputToLog = output;
        if (outputToLog != null && outputToLog.length() > 100) {
            outputToLog = outputToLog.substring(0, 100) + "...";
        }
        return outputToLog;
    }
}

