/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbosscache;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.mc4j.ems.connection.EmsConnection;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jbossas.util.DeploymentUtility;
import org.rhq.plugins.jbosscache.JBossCacheComponent;

public class JGroupsChannelDiscovery
implements ResourceDiscoveryComponent {
    private final Log log = LogFactory.getLog(JGroupsChannelDiscovery.class);

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext context) throws InvalidPluginConfigurationException, Exception {
        String resKey;
        JBossCacheComponent parent = (JBossCacheComponent)context.getParentResourceComponent();
        EmsConnection emsConnection = parent.getEmsConnection();
        File file = DeploymentUtility.getDescriptorFile((EmsConnection)emsConnection, (String)(resKey = context.getParentResourceContext().getResourceKey()));
        if (file == null) {
            this.log.warn((Object)("File is null for " + resKey));
            return null;
        }
        boolean found = false;
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(file);
            Element root = doc.getRootElement();
            for (Object mbeanObj : root.getChildren("mbean")) {
                if (!(mbeanObj instanceof Element)) continue;
                Element mbean = (Element)mbeanObj;
                String nameAttrib = mbean.getAttributeValue("name");
                try {
                    ObjectName on = new ObjectName(nameAttrib);
                    nameAttrib = on.getCanonicalName();
                }
                catch (MalformedObjectNameException e) {
                    this.log.warn((Object)("Can't canonicalize " + nameAttrib));
                }
                if (!nameAttrib.equals(resKey)) continue;
                List children = mbean.getChildren("attribute");
                for (Object childObj : children) {
                    Element child;
                    String name;
                    if (!(childObj instanceof Element) || !(name = (child = (Element)childObj).getAttributeValue("name")).equals("ClusterConfig")) continue;
                    found = true;
                }
            }
        }
        catch (IOException e) {
            this.log.error((Object)("IO error occurred while reading file: " + file), (Throwable)e);
        }
        catch (JDOMException e) {
            this.log.error((Object)("Parsing error occurred while reading file: " + file), (Throwable)e);
        }
        if (found) {
            DiscoveredResourceDetails detail = new DiscoveredResourceDetails(context.getResourceType(), resKey + "jgroupsChannel", "JGroups channel", null, "JGroups config for parent JBossCache", context.getDefaultPluginConfiguration(), null);
            HashSet<DiscoveredResourceDetails> res = new HashSet<DiscoveredResourceDetails>(1);
            res.add(detail);
            return res;
        }
        return null;
    }
}

