/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.agent.metadata;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import org.rhq.core.clientapi.agent.configuration.ConfigurationUtility;
import org.rhq.core.clientapi.agent.metadata.InvalidPluginDescriptorException;
import org.rhq.core.clientapi.agent.metadata.MetricsMetadataParser;
import org.rhq.core.clientapi.descriptor.configuration.ActivationPolicy;
import org.rhq.core.clientapi.descriptor.configuration.ConfigurationDescriptor;
import org.rhq.core.clientapi.descriptor.configuration.ConfigurationProperty;
import org.rhq.core.clientapi.descriptor.configuration.ConfigurationTemplateDescriptor;
import org.rhq.core.clientapi.descriptor.configuration.ConstraintType;
import org.rhq.core.clientapi.descriptor.configuration.DynamicProperty;
import org.rhq.core.clientapi.descriptor.configuration.FloatConstraintType;
import org.rhq.core.clientapi.descriptor.configuration.IntegerConstraintType;
import org.rhq.core.clientapi.descriptor.configuration.ListProperty;
import org.rhq.core.clientapi.descriptor.configuration.MapProperty;
import org.rhq.core.clientapi.descriptor.configuration.Option;
import org.rhq.core.clientapi.descriptor.configuration.PropertyGroup;
import org.rhq.core.clientapi.descriptor.configuration.PropertyOptions;
import org.rhq.core.clientapi.descriptor.configuration.PropertyType;
import org.rhq.core.clientapi.descriptor.configuration.RegexConstraintType;
import org.rhq.core.clientapi.descriptor.configuration.SimpleProperty;
import org.rhq.core.domain.configuration.AbstractPropertyMap;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyDefinitionDynamic;
import org.rhq.core.domain.configuration.PropertyDynamicType;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.ConfigurationFormat;
import org.rhq.core.domain.configuration.definition.ConfigurationTemplate;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionEnumeration;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertyGroupDefinition;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;
import org.rhq.core.domain.configuration.definition.constraint.Constraint;
import org.rhq.core.domain.configuration.definition.constraint.FloatRangeConstraint;
import org.rhq.core.domain.configuration.definition.constraint.IntegerRangeConstraint;
import org.rhq.core.domain.configuration.definition.constraint.RegexConstraint;
import org.rhq.core.domain.util.StringUtils;

public class ConfigurationMetadataParser {
    public static ConfigurationDefinition parse(String configurationName, ConfigurationDescriptor descriptor) throws InvalidPluginDescriptorException {
        if (descriptor == null) {
            return null;
        }
        ConfigurationDefinition configurationDefinition = new ConfigurationDefinition(configurationName, descriptor.getNotes());
        configurationDefinition.setConfigurationFormat(ConfigurationMetadataParser.getConfigurationFormat(descriptor));
        if (configurationDefinition.getConfigurationFormat() == ConfigurationFormat.RAW) {
            return configurationDefinition;
        }
        for (ConfigurationTemplateDescriptor templateDescriptor : descriptor.getTemplate()) {
            configurationDefinition.putTemplate(ConfigurationMetadataParser.parseTemplate(templateDescriptor));
        }
        ConfigurationTemplate defaultTemplate = ConfigurationMetadataParser.initDefaultTemplate(configurationDefinition);
        configurationDefinition.putTemplate(defaultTemplate);
        Configuration defaultConfiguration = defaultTemplate.getConfiguration();
        ConfigurationMetadataParser.parseProperties(descriptor, defaultConfiguration, configurationDefinition);
        ConfigurationUtility.normalizeConfiguration(defaultConfiguration, configurationDefinition);
        return configurationDefinition;
    }

    private static ConfigurationFormat getConfigurationFormat(ConfigurationDescriptor descriptor) {
        if (descriptor.getConfigurationFormat() == null) {
            return ConfigurationFormat.STRUCTURED;
        }
        switch (descriptor.getConfigurationFormat()) {
            case STRUCTURED: {
                return ConfigurationFormat.STRUCTURED;
            }
            case RAW: {
                return ConfigurationFormat.RAW;
            }
        }
        return ConfigurationFormat.STRUCTURED_AND_RAW;
    }

    private static ConfigurationTemplate initDefaultTemplate(ConfigurationDefinition configurationDefinition) {
        ConfigurationTemplate defaultTemplate = configurationDefinition.getDefaultTemplate();
        if (defaultTemplate == null) {
            defaultTemplate = new ConfigurationTemplate("default", "the default template");
            Configuration defaultConfiguration = new Configuration();
            defaultTemplate.setConfiguration(defaultConfiguration);
        }
        defaultTemplate.setDefault(true);
        return defaultTemplate;
    }

    private static void parseProperties(ConfigurationDescriptor descriptor, Configuration defaultConfiguration, ConfigurationDefinition configurationDefinition) throws InvalidPluginDescriptorException {
        List<PropertyGroup> groups = descriptor.getGroup();
        List<JAXBElement<? extends ConfigurationProperty>> properties = descriptor.getConfigurationProperty();
        if (groups.size() == 0 && properties.size() == 0) {
            throw new InvalidPluginDescriptorException("Configuration properties are missing. Resource configurations must have at least one group or one config-property as a child.");
        }
        int groupOrderIndex = 0;
        for (PropertyGroup group : descriptor.getGroup()) {
            PropertyGroupDefinition groupDef = new PropertyGroupDefinition(group.getName());
            groupDef.setDisplayName(group.getDisplayName() != null ? group.getDisplayName() : StringUtils.deCamelCase((String)group.getName()));
            groupDef.setDescription(group.getDescription());
            groupDef.setDefaultHidden(group.isHiddenByDefault());
            groupDef.setOrder(groupOrderIndex++);
            List<JAXBElement<? extends ConfigurationProperty>> groupProperties = group.getConfigurationProperty();
            int propertyOrderIndex = 0;
            for (JAXBElement<? extends ConfigurationProperty> jaxbProperty : groupProperties) {
                ConfigurationProperty uncastedProperty = (ConfigurationProperty)jaxbProperty.getValue();
                PropertyDefinition propertyDefinition = ConfigurationMetadataParser.parseProperty(uncastedProperty, propertyOrderIndex, (AbstractPropertyMap)defaultConfiguration);
                if (configurationDefinition == null) continue;
                propertyDefinition.setPropertyGroupDefinition(groupDef);
                configurationDefinition.put(propertyDefinition);
                ++propertyOrderIndex;
            }
        }
        int propertyOrderIndex = 0;
        for (JAXBElement<? extends ConfigurationProperty> jaxbProperty : properties) {
            ConfigurationProperty uncastedProperty = (ConfigurationProperty)jaxbProperty.getValue();
            PropertyDefinition propertyDefinition = ConfigurationMetadataParser.parseProperty(uncastedProperty, propertyOrderIndex, (AbstractPropertyMap)defaultConfiguration);
            if (configurationDefinition == null) continue;
            configurationDefinition.put(propertyDefinition);
            ++propertyOrderIndex;
        }
    }

    private static ConfigurationTemplate parseTemplate(ConfigurationTemplateDescriptor templateDescripter) throws InvalidPluginDescriptorException {
        ConfigurationTemplate template = new ConfigurationTemplate(templateDescripter.getName(), templateDescripter.getDescription());
        Configuration templateConfiguration = new Configuration();
        template.setConfiguration(templateConfiguration);
        ConfigurationMetadataParser.parseProperties(templateDescripter, templateConfiguration, null);
        return template;
    }

    private static PropertyDefinition parseProperty(ConfigurationProperty uncastedProperty, int orderIndex) throws InvalidPluginDescriptorException {
        return ConfigurationMetadataParser.parseProperty(uncastedProperty, orderIndex, null);
    }

    private static PropertyDefinition parseProperty(ConfigurationProperty uncastedProperty, int orderIndex, AbstractPropertyMap defaultConfigurationParentMap) throws InvalidPluginDescriptorException {
        PropertyDefinitionSimple property = null;
        if (uncastedProperty instanceof SimpleProperty) {
            property = ConfigurationMetadataParser.parseSimpleProperty((SimpleProperty)uncastedProperty, defaultConfigurationParentMap);
        } else if (uncastedProperty instanceof ListProperty) {
            property = ConfigurationMetadataParser.parseListProperty((ListProperty)uncastedProperty);
        } else if (uncastedProperty instanceof MapProperty) {
            property = ConfigurationMetadataParser.parseMapProperty((MapProperty)uncastedProperty, defaultConfigurationParentMap);
        } else if (uncastedProperty instanceof DynamicProperty) {
            property = ConfigurationMetadataParser.parseDynamicProperty((DynamicProperty)uncastedProperty);
        }
        if (property != null) {
            property.setOrder(orderIndex);
        }
        return property;
    }

    private static PropertyDefinitionSimple parseSimpleProperty(SimpleProperty simpleProperty, AbstractPropertyMap defaultConfigurationParentMap) throws InvalidPluginDescriptorException {
        String description = ConfigurationMetadataParser.parseMultiValue(simpleProperty.getDescription(), simpleProperty.getLongDescription());
        String displayName = simpleProperty.getDisplayName() != null ? simpleProperty.getDisplayName() : StringUtils.deCamelCase((String)simpleProperty.getName());
        PropertyDefinitionSimple property = new PropertyDefinitionSimple(simpleProperty.getName(), description, simpleProperty.isRequired(), ConfigurationMetadataParser.translatePropertyType(simpleProperty.getType()));
        property.setReadOnly(simpleProperty.isReadOnly());
        property.setSummary(simpleProperty.isSummary());
        property.setActivationPolicy(ConfigurationMetadataParser.translateActivationPolicy(simpleProperty.getActivationPolicy()));
        property.setConstraints(ConfigurationMetadataParser.translateContraints(simpleProperty.getConstraint()));
        property.setDisplayName(displayName);
        property.setDefaultValue(simpleProperty.getDefaultValue());
        property.setUnits(MetricsMetadataParser.getMeasurementUnits(simpleProperty.getUnits(), null));
        String initialValue = simpleProperty.getInitialValue();
        if (defaultConfigurationParentMap != null && initialValue != null) {
            defaultConfigurationParentMap.put((Property)new PropertySimple(simpleProperty.getName(), (Object)initialValue));
        }
        if (simpleProperty.getPropertyOptions() != null) {
            ConfigurationMetadataParser.parsePropertyOptions(property, simpleProperty.getPropertyOptions());
        }
        return property;
    }

    private static PropertyDefinitionDynamic parseDynamicProperty(DynamicProperty dynamicProperty) throws InvalidPluginDescriptorException {
        String description = ConfigurationMetadataParser.parseMultiValue(dynamicProperty.getDescription(), dynamicProperty.getLongDescription());
        String displayName = dynamicProperty.getDisplayName() != null ? dynamicProperty.getDisplayName() : StringUtils.deCamelCase((String)dynamicProperty.getName());
        PropertyDefinitionDynamic property = new PropertyDefinitionDynamic(dynamicProperty.getName(), description, dynamicProperty.isRequired(), PropertyDynamicType.DATABASE, dynamicProperty.getDatabaseBacking().getKey().value());
        property.setReadOnly(dynamicProperty.isReadOnly());
        property.setSummary(dynamicProperty.isSummary());
        property.setDisplayName(displayName);
        property.setActivationPolicy(ConfigurationMetadataParser.translateActivationPolicy(dynamicProperty.getActivationPolicy()));
        return property;
    }

    private static List<PropertyDefinitionEnumeration> parsePropertyOptions(PropertyDefinitionSimple parentProperty, PropertyOptions options) {
        ArrayList<PropertyDefinitionEnumeration> results = new ArrayList<PropertyDefinitionEnumeration>();
        for (Option option : options.getOption()) {
            String name = option.getName();
            if (name == null) {
                name = option.getValue();
            }
            PropertyDefinitionEnumeration enumeration = new PropertyDefinitionEnumeration(name, option.getValue());
            parentProperty.addEnumeratedValues(new PropertyDefinitionEnumeration[]{enumeration});
        }
        parentProperty.setAllowCustomEnumeratedValue(options.isAllowCustomValue());
        return results;
    }

    private static PropertyDefinitionList parseListProperty(ListProperty listProperty) throws InvalidPluginDescriptorException {
        String description = ConfigurationMetadataParser.parseMultiValue(listProperty.getDescription(), listProperty.getLongDescription());
        JAXBElement<? extends ConfigurationProperty> memberProperty = listProperty.getConfigurationProperty();
        PropertyDefinition memberDefinition = memberProperty != null ? ConfigurationMetadataParser.parseProperty((ConfigurationProperty)memberProperty.getValue(), 0) : null;
        PropertyDefinitionList list = new PropertyDefinitionList(listProperty.getName(), description, listProperty.isRequired(), memberDefinition);
        String displayName = listProperty.getDisplayName() != null ? listProperty.getDisplayName() : StringUtils.deCamelCase((String)listProperty.getName());
        list.setDisplayName(displayName);
        list.setReadOnly(listProperty.isReadOnly());
        list.setSummary(listProperty.isSummary());
        list.setMin(listProperty.getMin().intValue());
        if (listProperty.getMax().equals("unbounded")) {
            list.setMax(Integer.MAX_VALUE);
        } else {
            list.setMax(Integer.parseInt(listProperty.getMax()));
        }
        return list;
    }

    private static PropertyDefinitionMap parseMapProperty(MapProperty mapProperty, AbstractPropertyMap defaultConfigurationParentMap) throws InvalidPluginDescriptorException {
        PropertyMap propMap;
        String description = ConfigurationMetadataParser.parseMultiValue(mapProperty.getDescription(), mapProperty.getLongDescription());
        PropertyDefinitionMap propDefMap = new PropertyDefinitionMap(mapProperty.getName(), description, mapProperty.isRequired(), new PropertyDefinition[0]);
        String displayName = mapProperty.getDisplayName() != null ? mapProperty.getDisplayName() : StringUtils.deCamelCase((String)mapProperty.getName());
        propDefMap.setDisplayName(displayName);
        propDefMap.setReadOnly(mapProperty.isReadOnly());
        propDefMap.setSummary(mapProperty.isSummary());
        if (defaultConfigurationParentMap != null) {
            propMap = new PropertyMap(propDefMap.getName());
            defaultConfigurationParentMap.put((Property)propMap);
        } else {
            propMap = null;
        }
        List<JAXBElement<? extends ConfigurationProperty>> nestedProperties = mapProperty.getConfigurationProperty();
        int propertyOrderIndex = 0;
        for (JAXBElement<? extends ConfigurationProperty> jaxbProperty : nestedProperties) {
            ConfigurationProperty uncastedProperty = (ConfigurationProperty)jaxbProperty.getValue();
            PropertyDefinition propertyDefinition = ConfigurationMetadataParser.parseProperty(uncastedProperty, propertyOrderIndex, (AbstractPropertyMap)propMap);
            propDefMap.put(propertyDefinition);
        }
        return propDefMap;
    }

    private static PropertySimpleType translatePropertyType(PropertyType fromType) throws InvalidPluginDescriptorException {
        PropertySimpleType toType;
        switch (fromType) {
            case BOOLEAN: {
                toType = PropertySimpleType.BOOLEAN;
                break;
            }
            case DIRECTORY: {
                toType = PropertySimpleType.DIRECTORY;
                break;
            }
            case FILE: {
                toType = PropertySimpleType.FILE;
                break;
            }
            case FLOAT: {
                toType = PropertySimpleType.FLOAT;
                break;
            }
            case DOUBLE: {
                toType = PropertySimpleType.DOUBLE;
                break;
            }
            case INTEGER: {
                toType = PropertySimpleType.INTEGER;
                break;
            }
            case LONG: {
                toType = PropertySimpleType.LONG;
                break;
            }
            case LONG_STRING: {
                toType = PropertySimpleType.LONG_STRING;
                break;
            }
            case PASSWORD: {
                toType = PropertySimpleType.PASSWORD;
                break;
            }
            case STRING: {
                toType = PropertySimpleType.STRING;
                break;
            }
            default: {
                throw new InvalidPluginDescriptorException("Property type specified does not have a corresponding domain property type. Property type: " + (Object)((Object)fromType));
            }
        }
        return toType;
    }

    private static org.rhq.core.domain.configuration.definition.ActivationPolicy translateActivationPolicy(ActivationPolicy fromPolicy) throws InvalidPluginDescriptorException {
        org.rhq.core.domain.configuration.definition.ActivationPolicy toPolicy;
        switch (fromPolicy) {
            case IMMEDIATE: {
                toPolicy = org.rhq.core.domain.configuration.definition.ActivationPolicy.IMMEDIATE;
                break;
            }
            case RESTART: {
                toPolicy = org.rhq.core.domain.configuration.definition.ActivationPolicy.RESTART;
                break;
            }
            case SHUTDOWN: {
                toPolicy = org.rhq.core.domain.configuration.definition.ActivationPolicy.SHUTDOWN;
                break;
            }
            default: {
                throw new InvalidPluginDescriptorException("Activation policy specified does not have a corresponding domain activation policy type. Activation Policy type: " + (Object)((Object)fromPolicy));
            }
        }
        return toPolicy;
    }

    private static Set<Constraint> translateContraints(List<ConstraintType> fromConstraints) throws InvalidPluginDescriptorException {
        HashSet<Constraint> toConstraints = new HashSet<Constraint>();
        if (fromConstraints == null) {
            return toConstraints;
        }
        for (ConstraintType fromC : fromConstraints) {
            List<Object> constraints = fromC.getIntegerConstraintOrFloatConstraintOrRegexConstraint();
            for (Object constraint : constraints) {
                if (constraint instanceof FloatConstraintType) {
                    FloatConstraintType floatDetails = (FloatConstraintType)constraint;
                    Double floatMin = floatDetails.getMinimum() != null ? new Double(floatDetails.getMinimum().toString()) : null;
                    Double floatMax = floatDetails.getMaximum() != null ? new Double(floatDetails.getMaximum().toString()) : null;
                    FloatRangeConstraint fc = new FloatRangeConstraint(floatMin, floatMax);
                    toConstraints.add((Constraint)fc);
                    continue;
                }
                if (constraint instanceof IntegerConstraintType) {
                    IntegerConstraintType intDetails = (IntegerConstraintType)constraint;
                    Long longMin = intDetails.getMinimum() != null ? new Long(intDetails.getMinimum().toString()) : null;
                    Long longMax = intDetails.getMaximum() != null ? new Long(intDetails.getMaximum().toString()) : null;
                    IntegerRangeConstraint ic = new IntegerRangeConstraint(longMin, longMax);
                    toConstraints.add((Constraint)ic);
                    continue;
                }
                if (constraint instanceof RegexConstraintType) {
                    RegexConstraintType regexDetails = (RegexConstraintType)constraint;
                    RegexConstraint rc = new RegexConstraint();
                    rc.setDetails(regexDetails.getExpression());
                    toConstraints.add((Constraint)rc);
                    continue;
                }
                throw new InvalidPluginDescriptorException("Unknown constraint type: " + fromC);
            }
        }
        return toConstraints;
    }

    private static String parseMultiValue(String ... values) {
        String value = null;
        for (String s : values) {
            if (s == null) continue;
            value = s;
            break;
        }
        return value != null ? value.trim() : null;
    }
}

