/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.ant;

import java.util.Date;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.util.StringUtils;
import org.rhq.core.domain.bundle.BundleResourceDeployment;
import org.rhq.core.domain.bundle.BundleResourceDeploymentHistory;
import org.rhq.core.pluginapi.bundle.BundleManagerProvider;

public class DeploymentAuditorBuildListener
implements BuildListener {
    private BundleManagerProvider bundleManagerProvider;
    private BundleResourceDeployment bundleResourceDeployment;

    public DeploymentAuditorBuildListener(BundleManagerProvider bundleManagerProvider, BundleResourceDeployment bundleResourceDeployment) {
        this.bundleManagerProvider = bundleManagerProvider;
        this.bundleResourceDeployment = bundleResourceDeployment;
    }

    public void buildStarted(BuildEvent event) {
    }

    public void buildFinished(BuildEvent event) {
    }

    public void targetStarted(BuildEvent event) {
    }

    public void targetFinished(BuildEvent event) {
        this.auditEvent(event);
    }

    public void taskStarted(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
        this.auditEvent(event);
    }

    public void messageLogged(BuildEvent event) {
        block4: {
            try {
                String[] eventStrings = event.getMessage().split("___");
                int index = 0;
                if (!eventStrings[index++].equals("RHQ_AUDIT_MESSAGE")) break block4;
                BundleResourceDeploymentHistory.Status status = BundleResourceDeploymentHistory.Status.SUCCESS;
                String action = "Audit Message";
                String info = "Recipe Audit Message";
                String message = new Date().toString();
                String details = null;
                try {
                    String statusStr = eventStrings[index++];
                    status = BundleResourceDeploymentHistory.Status.valueOf((String)statusStr.toUpperCase());
                    action = eventStrings[index++];
                    info = eventStrings[index++];
                    message = eventStrings[index++];
                    details = eventStrings[index++];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    // empty catch block
                }
                this.bundleManagerProvider.auditDeployment(this.bundleResourceDeployment, action, info, BundleResourceDeploymentHistory.Category.AUDIT_MESSAGE, status, message, details);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void auditEvent(BuildEvent event) {
        BundleResourceDeploymentHistory.Status status = event.getException() == null ? BundleResourceDeploymentHistory.Status.SUCCESS : BundleResourceDeploymentHistory.Status.FAILURE;
        String action = DeploymentAuditorBuildListener.createAction(event);
        String message = DeploymentAuditorBuildListener.createMessage(action, event);
        try {
            this.bundleManagerProvider.auditDeployment(this.bundleResourceDeployment, "Build Event", action, null, status, message, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String createAction(BuildEvent event) {
        StringBuilder msg = new StringBuilder();
        if (event.getTarget() != null) {
            msg.append("[").append(event.getTarget().getName()).append("] ");
        }
        if (event.getTask() != null) {
            msg.append("<").append(event.getTask().getTaskName()).append("> ");
        }
        return msg.toString();
    }

    private static String createMessage(String action, BuildEvent event) {
        StringBuilder msg = new StringBuilder(action);
        if (event.getMessage() != null) {
            msg.append(event.getMessage());
        }
        if (event.getException() != null) {
            msg.append("\n").append(StringUtils.getStackTrace((Throwable)event.getException()));
        }
        return msg.toString();
    }
}

