/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.agent.metadata;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.clientapi.agent.metadata.InvalidPluginDescriptorException;
import org.rhq.core.clientapi.agent.metadata.PluginDependencyGraph;
import org.rhq.core.clientapi.agent.metadata.PluginMetadataParser;
import org.rhq.core.clientapi.descriptor.AgentPluginDescriptorUtil;
import org.rhq.core.clientapi.descriptor.plugin.PluginDescriptor;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;

public class PluginMetadataManager {
    public static final ResourceType TEST_PLATFORM_TYPE = new ResourceType("Anonymous", "test", ResourceCategory.PLATFORM, null);
    private Log log = LogFactory.getLog(PluginMetadataManager.class);
    private Map<ResourceCategory, LinkedHashSet<ResourceType>> typesByCategory = new HashMap<ResourceCategory, LinkedHashSet<ResourceType>>();
    private Set<ResourceType> types = new HashSet<ResourceType>();
    private Object typesLock = new Object();
    private Map<String, PluginMetadataParser> parsersByPlugin = new HashMap<String, PluginMetadataParser>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addType(ResourceType type) {
        ResourceCategory category = type.getCategory();
        Object object = this.typesLock;
        synchronized (object) {
            if (!this.typesByCategory.containsKey(category)) {
                this.typesByCategory.put(category, new LinkedHashSet());
            }
            this.typesByCategory.get(category).add(type);
            this.types.add(type);
        }
    }

    public ResourceType addTestPlatformType() {
        this.addType(TEST_PLATFORM_TYPE);
        return TEST_PLATFORM_TYPE;
    }

    public String getPluginLifecycleListenerClass(String pluginName) {
        PluginMetadataParser parser = this.parsersByPlugin.get(pluginName);
        return parser != null ? parser.getPluginLifecycleListenerClass() : null;
    }

    public String getDiscoveryClass(ResourceType resourceType) {
        PluginMetadataParser parser = this.parsersByPlugin.get(resourceType.getPlugin());
        return parser != null ? parser.getDiscoveryComponentClass(resourceType) : null;
    }

    public String getComponentClass(ResourceType resourceType) {
        PluginMetadataParser parser = this.parsersByPlugin.get(resourceType.getPlugin());
        return parser != null ? parser.getComponentClass(resourceType) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Set<ResourceType> loadPlugin(PluginDescriptor pluginDescriptor) {
        try {
            Object object;
            PluginMetadataParser parser = new PluginMetadataParser(pluginDescriptor, this.parsersByPlugin);
            PluginMetadataParser oldParser = this.parsersByPlugin.get(pluginDescriptor.getName());
            if (oldParser != null) {
                object = this.typesLock;
                synchronized (object) {
                    for (ResourceType oldType : oldParser.getAllTypes()) {
                        this.typesByCategory.get(oldType.getCategory()).remove(oldType);
                        this.types.remove(oldType);
                    }
                }
            }
            this.parsersByPlugin.put(pluginDescriptor.getName(), parser);
            object = this.typesLock;
            synchronized (object) {
                for (ResourceType resourceType : parser.getAllTypes()) {
                    if (this.types.contains(resourceType)) {
                        throw new InvalidPluginDescriptorException("Type [" + resourceType + "] is duplicate for this plugin. This is illegal.");
                    }
                    this.addType(resourceType);
                }
            }
            return parser.getRootResourceTypes();
        }
        catch (InvalidPluginDescriptorException e) {
            this.log.error((Object)("Error transforming plugin descriptor [" + pluginDescriptor.getName() + "]."), (Throwable)e);
            return null;
        }
    }

    public ResourceType getType(String typeName, ResourceCategory category) {
        for (ResourceType type : this.getTypesForCategory(category)) {
            if (!type.getName().equals(typeName)) continue;
            return type;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ResourceType getType(String resourceTypeName, String pluginName) {
        ResourceType searchType = new ResourceType(resourceTypeName, pluginName, null, null);
        Object object = this.typesLock;
        synchronized (object) {
            for (ResourceType t : this.types) {
                if (!t.equals((Object)searchType)) continue;
                return t;
            }
        }
        return null;
    }

    @Nullable
    public ResourceType getType(ResourceType resourceType) {
        if (TEST_PLATFORM_TYPE.equals((Object)resourceType)) {
            return TEST_PLATFORM_TYPE;
        }
        return this.getType(resourceType.getName(), resourceType.getPlugin());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ResourceType> getTypesForCategory(ResourceCategory category) {
        Object object = this.typesLock;
        synchronized (object) {
            LinkedHashSet<ResourceType> types = this.typesByCategory.get(category);
            return types != null ? types : new HashSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ResourceType> getAllTypes() {
        Object object = this.typesLock;
        synchronized (object) {
            return new HashSet<ResourceType>(this.types);
        }
    }

    public Set<ResourceType> getRootTypes() {
        HashSet<ResourceType> rootTypes = new HashSet<ResourceType>();
        for (ResourceType type : this.getAllTypes()) {
            if (type.getParentResourceTypes().size() != 0) continue;
            rootTypes.add(type);
        }
        return rootTypes;
    }

    public Set<String> getPluginNames() {
        return this.parsersByPlugin.keySet();
    }

    public PluginDependencyGraph buildDependencyGraph() {
        PluginDependencyGraph dependencyGraph = new PluginDependencyGraph();
        for (String pluginName : this.getPluginNames()) {
            PluginDescriptor descriptor = this.parsersByPlugin.get(pluginName).getDescriptor();
            AgentPluginDescriptorUtil.addPluginToDependencyGraph(dependencyGraph, descriptor);
        }
        return dependencyGraph;
    }
}

