/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.Properties;

public class PropertiesFileUpdate {
    private File file;

    public PropertiesFileUpdate(String location) {
        this.file = new File(location);
    }

    public void update(String key, String value) throws IOException {
        Properties existingProps;
        if (value == null) {
            value = "";
        }
        if (!(existingProps = this.loadExistingProperties()).containsKey(key)) {
            PrintStream ps = new PrintStream((OutputStream)new FileOutputStream(this.file, true), true, "8859_1");
            ps.println(key + "=" + value);
            ps.flush();
            ps.close();
        } else if (!value.equals(existingProps.getProperty(key))) {
            Properties newProp = new Properties();
            newProp.setProperty(key, value);
            this.update(newProp);
        }
    }

    public void update(Properties newProps) throws IOException {
        Properties propsToUpdate = new Properties();
        propsToUpdate.putAll((Map<?, ?>)newProps);
        Properties existingProps = this.loadExistingProperties();
        for (Map.Entry<Object, Object> entry : newProps.entrySet()) {
            if (!entry.getValue().equals(existingProps.get(entry.getKey()))) continue;
            propsToUpdate.remove(entry.getKey());
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)baos, true, "8859_1");
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(this.file), "8859_1");
        BufferedReader in = new BufferedReader(isr);
        String line = in.readLine();
        while (line != null) {
            int equalsSign = line.indexOf(61);
            if (line.startsWith("#") || line.trim().length() == 0 || equalsSign < 0) {
                out.println(line);
            } else {
                String existingKey = line.substring(0, equalsSign);
                if (!propsToUpdate.containsKey(existingKey)) {
                    out.println(line);
                } else {
                    out.println(existingKey + "=" + propsToUpdate.getProperty(existingKey));
                    propsToUpdate.remove(existingKey);
                }
            }
            line = in.readLine();
        }
        in.close();
        for (Map.Entry<Object, Object> entry : propsToUpdate.entrySet()) {
            out.println(entry.getKey() + "=" + entry.getValue());
        }
        out.close();
        FileOutputStream fos = new FileOutputStream(this.file, false);
        fos.write(baos.toByteArray());
        fos.flush();
        fos.close();
    }

    public Properties loadExistingProperties() throws IOException {
        Properties props = new Properties();
        if (this.file.exists()) {
            FileInputStream is = new FileInputStream(this.file);
            props.load(is);
            is.close();
        }
        return props;
    }
}

