/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.util.ObjectUtil;
import org.rhq.core.system.FileSystemInfo;
import org.rhq.plugins.platform.PlatformComponent;

public class FileSystemComponent
implements ResourceComponent<PlatformComponent>,
MeasurementFacet {
    private static final Log LOG = LogFactory.getLog(FileSystemComponent.class);
    private ResourceContext<PlatformComponent> resourceContext;

    public void start(ResourceContext<PlatformComponent> resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = resourceContext;
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        FileSystemInfo fileSystemInfo = this.getFileSystemInfo();
        if (fileSystemInfo != null && fileSystemInfo.getFileSystem() != null) {
            return AvailabilityType.UP;
        }
        return AvailabilityType.DOWN;
    }

    private FileSystemInfo getFileSystemInfo() {
        return this.resourceContext.getSystemInformation().getFileSystem(this.resourceContext.getResourceKey());
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        FileSystemInfo fileSystemInfo = this.getFileSystemInfo();
        fileSystemInfo.refresh();
        for (MeasurementScheduleRequest request : metrics) {
            try {
                if (request.getDataType() == DataType.TRAIT) {
                    Object value = ObjectUtil.lookupDeepAttributeProperty((Object)fileSystemInfo, (String)request.getName());
                    report.addData(new MeasurementDataTrait(request, String.valueOf(value)));
                    continue;
                }
                if (request.getDataType() != DataType.MEASUREMENT) continue;
                report.addData(new MeasurementDataNumeric(request, ObjectUtil.lookupDeepNumericAttributeProperty((Object)fileSystemInfo, (String)request.getName())));
            }
            catch (Exception e) {
                LOG.info((Object)("Unable to collection file system metric [" + request.getName() + "] on resource " + this.resourceContext.getResourceKey()), (Throwable)e);
            }
        }
    }
}

