/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.prefs.Preferences;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.rhq.core.clientapi.server.core.CoreServerService;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.discovery.AvailabilityReport;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentManagementMBean;
import org.rhq.enterprise.agent.AgentPrintWriter;
import org.rhq.enterprise.agent.AgentRestartCounter;
import org.rhq.enterprise.agent.PluginUpdate;
import org.rhq.enterprise.agent.Version;
import org.rhq.enterprise.communications.ServiceContainerMetricsMBean;
import org.rhq.enterprise.communications.command.client.ClientCommandSender;
import org.rhq.enterprise.communications.command.client.ClientCommandSenderMetrics;
import org.rhq.enterprise.communications.command.client.ClientRemotePojoFactory;

public class AgentManagement
implements AgentManagementMBean,
MBeanRegistration {
    private AgentMain m_agent;
    private MBeanServer m_mbs;
    private ObjectName m_objectName;
    public static ObjectName singletonObjectName = AgentManagementMBean.BASE_OBJECT_NAME;

    public AgentManagement(AgentMain agent) {
        this.m_agent = agent;
    }

    @Override
    public void restart() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
                try {
                    AgentManagement.this.sleep(5000L);
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    AgentManagement.this.m_agent.shutdown();
                    AgentManagement.this.m_agent.start();
                    AgentManagement.this.m_agent.getAgentRestartCounter().restartedAgent(AgentRestartCounter.AgentRestartReason.OPERATION);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalCL);
                }
            }
        }, "RHQ Agent Restart Thread").start();
    }

    @Override
    public void shutdown() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
                try {
                    AgentManagement.this.sleep(5000L);
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    AgentManagement.this.m_agent.shutdown();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalCL);
                }
            }
        }, "RHQ Agent Shutdown Thread").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadLatestFailoverList() {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.m_agent.performPrimaryServerSwitchoverCheck();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePlugins() {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.m_agent.updatePlugins();
            this.restartPluginContainer();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult retrieveAllPluginInfo() {
        List<File> plugins;
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            PluginUpdate updater = this.getPluginUpdateObject();
            plugins = updater.getCurrentPluginFiles();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
        OperationResult info = new OperationResult();
        PropertyList list = new PropertyList("plugins");
        info.getComplexResults().put((Property)list);
        if (plugins.size() > 0) {
            for (File plugin : plugins) {
                PropertyMap map = new PropertyMap("plugin");
                map.put((Property)new PropertySimple("name", (Object)plugin.getName()));
                map.put((Property)new PropertySimple("path", (Object)plugin.getAbsoluteFile()));
                map.put((Property)new PropertySimple("timestamp", (Object)new Date(plugin.lastModified())));
                map.put((Property)new PropertySimple("size", (Object)plugin.length()));
                try {
                    map.put((Property)new PropertySimple("md5", (Object)MessageDigestGenerator.getDigestString((File)plugin)));
                }
                catch (IOException e) {
                    map.put((Property)new PropertySimple("md5", (Object)e.toString()));
                }
                list.add((Property)map);
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult retrievePluginInfo(String pluginName) {
        List<File> plugins;
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            PluginUpdate updater = this.getPluginUpdateObject();
            plugins = updater.getCurrentPluginFiles();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
        if (plugins.size() > 0) {
            for (File plugin : plugins) {
                if (!plugin.getName().equals(pluginName)) continue;
                OperationResult opResults = new OperationResult();
                Configuration info = opResults.getComplexResults();
                info.put((Property)new PropertySimple("name", (Object)plugin.getName()));
                info.put((Property)new PropertySimple("path", (Object)plugin.getAbsoluteFile()));
                info.put((Property)new PropertySimple("timestamp", (Object)new Date(plugin.lastModified())));
                info.put((Property)new PropertySimple("size", (Object)plugin.length()));
                try {
                    info.put((Property)new PropertySimple("md5", (Object)MessageDigestGenerator.getDigestString((File)plugin)));
                }
                catch (IOException e) {
                    info.put((Property)new PropertySimple("md5", (Object)e.toString()));
                }
                return opResults;
            }
        }
        throw new IllegalArgumentException("There is no plugin named [" + pluginName + "]");
    }

    @Override
    public void restartPluginContainer() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AgentManagement.this.sleep(5000L);
                ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    AgentManagement.this.m_agent.shutdownPluginContainer();
                    AgentManagement.this.m_agent.startPluginContainer(500L);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalCL);
                }
            }
        }, "RHQ Agent Plugin Container Restart Thread").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult executeAvailabilityScan(Boolean changesOnly) {
        Boolean changesOnlyFromReport;
        String agentName;
        AvailabilityReport report;
        boolean changes = changesOnly != null ? changesOnly : false;
        InventoryManager inventoryManager = PluginContainer.getInstance().getInventoryManager();
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            report = inventoryManager.executeAvailabilityScanImmediately(changes);
            inventoryManager.handleReport(report);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
        OperationResult opResult = new OperationResult();
        Configuration complexResults = opResult.getComplexResults();
        PropertyList list = new PropertyList("resourceAvailabilities");
        complexResults.put((Property)list);
        if (report != null) {
            agentName = report.getAgentName();
            changesOnlyFromReport = report.isChangesOnlyReport();
            List avails = report.getResourceAvailability();
            if (avails.size() > 0) {
                for (AvailabilityReport.Datum avail : avails) {
                    boolean isUp = avail.getAvailabilityType() == AvailabilityType.UP;
                    int resourceId = avail.getResourceId();
                    ResourceContainer resourceContainer = inventoryManager.getResourceContainer(Integer.valueOf(resourceId));
                    Resource resource = resourceContainer.getResource();
                    PropertyMap map = new PropertyMap("resourceAvailability");
                    map.put((Property)new PropertySimple("resourceId", (Object)resource.getId()));
                    map.put((Property)new PropertySimple("resourceName", (Object)resource.getName()));
                    map.put((Property)new PropertySimple("isAvailable", (Object)isUp));
                    list.add((Property)map);
                }
            }
        } else {
            agentName = this.m_agent.getConfiguration().getAgentName();
            changesOnlyFromReport = changesOnly;
        }
        complexResults.put((Property)new PropertySimple("agentName", (Object)agentName));
        complexResults.put((Property)new PropertySimple("isChangesOnly", (Object)changesOnlyFromReport));
        return opResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getVersion() {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            String string = Version.getProductVersion();
            return string;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    @Override
    public long getCurrentTime() {
        return System.currentTimeMillis();
    }

    @Override
    public String retrieveCurrentDateTime(String timeZone) {
        DateFormat df = DateFormat.getDateTimeInstance(1, 0);
        if (timeZone == null || timeZone.length() == 0) {
            df.setTimeZone(TimeZone.getDefault());
        } else {
            df.setTimeZone(TimeZone.getTimeZone(timeZone));
        }
        return df.format(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDebugMode(Boolean enabled, Boolean traceMessaging) throws ExecutionException {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            if (enabled != null && enabled.booleanValue()) {
                this.executePromptCommand("debug -f log4j-debug.xml");
                if (traceMessaging != null && traceMessaging.booleanValue()) {
                    this.executePromptCommand("debug -c true");
                } else {
                    this.executePromptCommand("debug -c false");
                }
            } else {
                this.executePromptCommand("debug -f log4j.xml");
                this.executePromptCommand("debug -c false");
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String executePromptCommand(String command) throws ExecutionException {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            String output;
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            CharArrayWriter listener = new CharArrayWriter();
            AgentPrintWriter apw = this.m_agent.getOut();
            try {
                apw.addListener(listener);
                this.m_agent.executePromptCommand(command);
            }
            catch (Exception e) {
                throw new ExecutionException(listener.toString(), e);
            }
            finally {
                apw.removeListener(listener);
            }
            String string = output = listener.toString();
            return string;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAgentHomeDirectory() {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            String string = this.m_agent.getAgentHomeDirectory();
            return string;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberAgentRestarts() {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            int n = this.m_agent.getAgentRestartCounter().getNumberOfRestarts();
            return n;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getReasonForLastRestart() {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            String string = this.m_agent.getAgentRestartCounter().getLastAgentRestartReason().toString();
            return string;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAgentServerClockDifference() {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            long l = this.m_agent.getAgentServerClockDifference();
            return l;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getUptime() {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            long start_time = this.m_agent.getStartTime();
            if (start_time > 0L) {
                long l = (System.currentTimeMillis() - start_time) / 1000L;
                return l;
            }
            long l = 0L;
            return l;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumberSuccessfulCommandsReceived() {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            long l = this.getServerSideMetrics().getNumberSuccessfulCommandsReceived();
            return l;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumberFailedCommandsReceived() {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            long l = this.getServerSideMetrics().getNumberFailedCommandsReceived();
            return l;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumberTotalCommandsReceived() {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            long l = this.getServerSideMetrics().getNumberTotalCommandsReceived();
            return l;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAverageExecutionTimeReceived() {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            long l = this.getServerSideMetrics().getAverageExecutionTimeReceived();
            return l;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAverageExecutionTimeSent() {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            long l = this.getClientSideMetrics().getAverageExecutionTimeSent();
            return l;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumberSuccessfulCommandsSent() {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            long l = this.getClientSideMetrics().getNumberSuccessfulCommandsSent();
            return l;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumberFailedCommandsSent() {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            long l = this.getClientSideMetrics().getNumberFailedCommandsSent();
            return l;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumberTotalCommandsSent() {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            ClientCommandSenderMetrics metrics = this.getClientSideMetrics();
            long l = metrics.getNumberSuccessfulCommandsSent() + metrics.getNumberFailedCommandsSent();
            return l;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumberCommandsActiveSent() {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            long l = this.getClientSideMetrics().getNumberCommandsActive();
            return l;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumberCommandsInQueue() {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            long l = this.getClientSideMetrics().getNumberCommandsInQueue();
            return l;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumberCommandsSpooled() {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            long l = this.getClientSideMetrics().getNumberCommandsSpooled();
            return l;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSending() {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            ClientCommandSenderMetrics metrics = this.getClientSideMetrics();
            boolean bl = metrics.isSending();
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    @Override
    public long getJVMFreeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    @Override
    public long getJVMTotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    @Override
    public int getJVMActiveThreads() {
        return ManagementFactory.getThreadMXBean().getThreadCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getAgentConfiguration() {
        Properties properties = new Properties();
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                String[] keys;
                Preferences prefs = this.m_agent.getConfiguration().getPreferences();
                for (String key : keys = prefs.keys()) {
                    properties.setProperty(key, prefs.get(key, "<error>"));
                }
            }
            catch (Exception e) {
                properties.setProperty("ERROR", e.getMessage());
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeIntoAgentConfiguration(Properties config) {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            if (config != null && config.size() > 0) {
                Preferences prefs = this.m_agent.getConfiguration().getPreferences();
                Set<Object> names = config.keySet();
                for (Object name : names) {
                    Object value = config.get(name);
                    prefs.put(name.toString(), value.toString());
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromAgentConfiguration(List<String> preferenceNames) {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            if (preferenceNames != null && preferenceNames.size() > 0) {
                Preferences prefs = this.m_agent.getConfiguration().getPreferences();
                for (String doomedPreferenceName : preferenceNames) {
                    prefs.remove(doomedPreferenceName);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    public MBeanServer getMBeanServer() {
        return this.m_mbs;
    }

    public ObjectName getObjectName() {
        return this.m_objectName;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        singletonObjectName = name;
        this.m_mbs = server;
        this.m_objectName = name;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void postDeregister() {
        this.m_mbs = null;
        this.m_objectName = null;
    }

    @Override
    public void preDeregister() throws Exception {
    }

    private ClientCommandSenderMetrics getClientSideMetrics() {
        ClientCommandSender sender = this.m_agent.getClientCommandSender();
        ClientCommandSenderMetrics metrics = sender != null ? sender.getMetrics() : new ClientCommandSenderMetrics();
        return metrics;
    }

    private ServiceContainerMetricsMBean getServerSideMetrics() {
        try {
            MBeanServer mbs = this.m_agent.getServiceContainer().getMBeanServer();
            ServiceContainerMetricsMBean mbean = MBeanServerInvocationHandler.newProxyInstance(mbs, ServiceContainerMetricsMBean.OBJECTNAME_METRICS, ServiceContainerMetricsMBean.class, false);
            return mbean;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private PluginUpdate getPluginUpdateObject() {
        ClientCommandSender sender = this.m_agent.getClientCommandSender();
        CoreServerService server = null;
        if (sender != null) {
            ClientRemotePojoFactory factory = sender.getClientRemotePojoFactory();
            server = (CoreServerService)factory.getRemotePojo(CoreServerService.class);
        }
        PluginContainerConfiguration pc_config = this.m_agent.getConfiguration().getPluginContainerConfiguration();
        PluginUpdate plugin_update = new PluginUpdate(server, pc_config);
        return plugin_update;
    }

    private void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

