/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent;

import mazz.i18n.Logger;
import org.rhq.enterprise.agent.AgentConfiguration;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.communications.command.Command;
import org.rhq.enterprise.communications.command.client.ClientCommandSender;
import org.rhq.enterprise.communications.command.client.CommandPreprocessor;

public class SecurityTokenCommandPreprocessor
implements CommandPreprocessor {
    private static final Logger LOG = AgentI18NFactory.getLogger(SecurityTokenCommandPreprocessor.class);
    private static final String CMDCONFIG_PROP_SECURITY_TOKEN = "rhq.security-token";
    private static final String CMDCONFIG_PROP_AGENT_NAME = "rhq.agent-name";
    private AgentConfiguration m_agentConfiguration = null;
    private String m_agentName = "unknown";

    public void preprocess(Command command, ClientCommandSender sender) {
        String token = this.getAgentSecurityToken();
        if (token != null) {
            command.getConfiguration().setProperty(CMDCONFIG_PROP_SECURITY_TOKEN, token);
        }
        command.getConfiguration().setProperty(CMDCONFIG_PROP_AGENT_NAME, this.m_agentName);
    }

    public void setAgentConfiguration(AgentConfiguration config) {
        this.m_agentConfiguration = config;
        this.m_agentName = config.getAgentName();
    }

    private String getAgentSecurityToken() {
        String token = null;
        if (this.m_agentConfiguration != null) {
            token = this.m_agentConfiguration.getAgentSecurityToken();
        }
        if (token == null) {
            LOG.debug("SecurityTokenCommandPreprocessor.no-security-token-yet", new Object[0]);
        }
        return token;
    }
}

