/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.Date;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import mazz.i18n.Msg;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentManagement;
import org.rhq.enterprise.agent.AgentPrintWriter;
import org.rhq.enterprise.agent.StringUtil;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;

public class MetricsPromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    @Override
    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.metrics", new Object[0]);
    }

    @Override
    public boolean execute(AgentMain agent, String[] args) {
        AgentPrintWriter out = agent.getOut();
        AgentManagement agent_mbean = agent.getAgentManagementMBean();
        if (agent_mbean != null) {
            try {
                MBeanServer the_mbs = agent_mbean.getMBeanServer();
                this.displayMetrics(agent_mbean.getObjectName(), out, the_mbs);
            }
            catch (Exception e) {
                out.println(MSG.getMsg("PromptCommand.metrics.exception", new Object[]{e}));
            }
        } else {
            out.println(MSG.getMsg("PromptCommand.metrics.no-services", new Object[0]));
        }
        return true;
    }

    private void displayMetrics(ObjectName object_name, PrintWriter out, MBeanServer the_mbs) throws Exception {
        MBeanInfo mbeaninfo = the_mbs.getMBeanInfo(object_name);
        MBeanAttributeInfo[] attrib_infos = mbeaninfo.getAttributes();
        String[] attrib_names = new String[attrib_infos.length];
        for (int i = 0; i < attrib_infos.length; ++i) {
            attrib_names[i] = attrib_infos[i].getName();
        }
        HashMap<String, Object> name_value_pairs = new HashMap<String, Object>();
        AttributeList attribs = the_mbs.getAttributes(object_name, attrib_names);
        for (Attribute attrib : attribs) {
            String name = attrib.getName();
            Object value = attrib.getValue();
            if (name.equals("AgentConfiguration")) continue;
            if (name.equals("CurrentTime")) {
                value = new Date((Long)value);
            } else if (name.equals("Uptime")) {
                value = this.formatSeconds((Long)value);
            } else if (name.equals("JVMTotalMemory") || name.equals("JVMFreeMemory")) continue;
            name_value_pairs.put(name, value);
        }
        MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        name_value_pairs.put("Memory - Heap", "Used: " + this.formatBytes(memoryBean.getHeapMemoryUsage().getUsed()) + ", Committed: " + this.formatBytes(memoryBean.getHeapMemoryUsage().getCommitted()) + ", Max: " + this.formatBytes(memoryBean.getHeapMemoryUsage().getMax()));
        name_value_pairs.put("Memory - Non Heap", "Used: " + this.formatBytes(memoryBean.getNonHeapMemoryUsage().getUsed()) + ", Committed: " + this.formatBytes(memoryBean.getNonHeapMemoryUsage().getCommitted()) + ", Max: " + this.formatBytes(memoryBean.getNonHeapMemoryUsage().getMax()));
        out.println(MSG.getMsg("PromptCommand.metrics.header", new Object[0]));
        out.println(StringUtil.justifyKeyValueStrings(name_value_pairs));
    }

    private String formatSeconds(long seconds) {
        String ret_val = null;
        if (seconds >= 86400L) {
            ret_val = String.format("%.1f ", Float.valueOf((float)seconds / 86400.0f)) + MSG.getMsg("units.days", new Object[0]);
        } else if (seconds >= 3600L) {
            ret_val = String.format("%.1f ", Float.valueOf((float)seconds / 3600.0f)) + MSG.getMsg("units.hours", new Object[0]);
        } else if (seconds >= 60L) {
            ret_val = String.format("%.1f ", Float.valueOf((float)seconds / 60.0f)) + MSG.getMsg("units.minutes", new Object[0]);
        }
        ret_val = ret_val != null ? ret_val + " (" + seconds + ")" : seconds + " " + MSG.getMsg("units.seconds", new Object[0]);
        return ret_val;
    }

    private String formatBytes(long bytes) {
        String ret_str = "";
        ret_str = bytes >= 1000L && bytes <= 999999999999999L ? (bytes < 1000000L ? ret_str + String.format("%.2f", Float.valueOf((float)bytes / 1000.0f)) + " KB" : (bytes < 1000000000L ? ret_str + String.format("%.2f", Float.valueOf((float)bytes / 1000000.0f)) + " MB" : (bytes < 1000000000000L ? ret_str + String.format("%.2f", Float.valueOf((float)bytes / 1000000.0f)) + " GB" : ret_str + String.format("%.2f", Float.valueOf((float)bytes / 1.0E9f)) + " TB"))) : ret_str + bytes;
        return ret_str;
    }

    @Override
    public String getSyntax() {
        return MSG.getMsg("PromptCommand.metrics.syntax", new Object[0]);
    }

    @Override
    public String getHelp() {
        return MSG.getMsg("PromptCommand.metrics.help", new Object[0]);
    }

    @Override
    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.metrics.detailed-help", new Object[0]);
    }
}

