/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.rhq.core.util.file.ContentFileInfo;

public class JarContentFileInfo
extends ContentFileInfo {
    private final Attributes mainAttributes;

    public JarContentFileInfo(File file) {
        super(file);
        Manifest manifest = this.getManifest();
        this.mainAttributes = manifest != null ? manifest.getMainAttributes() : null;
    }

    @Override
    public boolean isValid() {
        return null != this.mainAttributes;
    }

    @Override
    public String getVersion(String defaultValue) {
        String result = defaultValue;
        if (null != this.mainAttributes) {
            try {
                String specVersion = this.getAttributeValue(Attributes.Name.SPECIFICATION_VERSION, null);
                String implVersion = this.getAttributeValue(Attributes.Name.IMPLEMENTATION_VERSION, null);
                if (null != specVersion && null != implVersion) {
                    result = specVersion + " (" + implVersion + ")";
                } else if (null != implVersion) {
                    result = implVersion;
                } else if (null != specVersion) {
                    result = specVersion;
                }
            }
            catch (Exception e) {
                result = defaultValue;
            }
        }
        return result;
    }

    @Override
    public String getDescription(String defaultValue) {
        String result = null;
        if (null != this.mainAttributes && (result = this.getAttributeValue(Attributes.Name.IMPLEMENTATION_TITLE, null)) == null) {
            result = this.getAttributeValue(Attributes.Name.SPECIFICATION_TITLE, null);
        }
        return result != null ? result : defaultValue;
    }

    public String getAttributeValue(Attributes.Name attributeName, String defaultValue) {
        return this.getAttributeValue(attributeName.toString(), defaultValue);
    }

    public String getAttributeValue(String attributeName, String defaultValue) {
        String result = defaultValue;
        if (null != this.mainAttributes) {
            try {
                String val = this.mainAttributes.getValue(attributeName);
                if (null != val) {
                    result = val;
                }
            }
            catch (Exception e) {
                result = defaultValue;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest getManifest() {
        Manifest manifest;
        block8: {
            manifest = null;
            try {
                File file = this.getContentFile();
                if (!file.isDirectory()) {
                    JarFile jarFile = new JarFile(file);
                    if (null != jarFile) {
                        manifest = jarFile.getManifest();
                    }
                    break block8;
                }
                File manifestFile = new File(file, "/META-INF/MANIFEST.MF");
                if (!manifestFile.exists()) break block8;
                FileInputStream is = null;
                try {
                    is = new FileInputStream(manifestFile);
                    manifest = new Manifest(is);
                }
                finally {
                    if (null != is) {
                        ((InputStream)is).close();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return manifest;
    }
}

