/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.plugins.tomcat;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.plugins.tomcat.TomcatServerComponent;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.jmx.MBeanResourceComponent;
import org.rhq.plugins.jmx.ObjectNameQueryUtility;

public class TomcatConnectorComponent
extends MBeanResourceComponent<TomcatServerComponent> {
    public static final String CONFIG_PROTOCOL = "protocol";
    public static final String CONFIG_V5_KEEP_ALIVE_TIMEOUT = "keepAliveTimeout";
    public static final String PLUGIN_CONFIG_ADDRESS = "address";
    public static final String PLUGIN_CONFIG_HANDLER = "handler";
    public static final String PLUGIN_CONFIG_PORT = "port";
    public static final String UNKNOWN = "?";
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public AvailabilityType getAvailability() {
        AvailabilityType result = super.getAvailability();
        if (AvailabilityType.UP == result) {
            ObjectNameQueryUtility queryUtility;
            String objectName = this.getGlobalRequestProcessorName();
            EmsConnection connection = this.getEmsConnection();
            List beans = connection.queryBeans((queryUtility = new ObjectNameQueryUtility(objectName)).getTranslatedQuery());
            result = beans.isEmpty() ? AvailabilityType.DOWN : AvailabilityType.UP;
        }
        return result;
    }

    public void start(ResourceContext<TomcatServerComponent> context) {
        if (UNKNOWN.equals(context.getPluginConfiguration().getSimple(PLUGIN_CONFIG_HANDLER).getStringValue())) {
            throw new InvalidPluginConfigurationException("The connector is not listening for requests on the configured port. This is most likely due to the configured port being in use at Tomcat startup. In some cases (AJP connectors) Tomcat will assign an open port. This happens most often when there are multiple Tomcat servers running on the same platform. Check your Tomcat configuration for conflicts: " + context.getResourceKey());
        }
        super.start(context);
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) {
        this.getEmsConnection();
        for (MeasurementScheduleRequest request : requests) {
            String name = request.getName();
            name = this.getAttributeName(name);
            String beanName = name.substring(0, name.lastIndexOf(58));
            String attributeName = name.substring(name.lastIndexOf(58) + 1);
            try {
                EmsBean eBean = this.loadBean(beanName);
                if (eBean == null) {
                    this.log.warn((Object)("Bean " + beanName + " not found, skipping ..."));
                    continue;
                }
                EmsAttribute attribute = eBean.getAttribute(attributeName);
                Object valueObject = attribute.refresh();
                Number value = (Number)valueObject;
                report.addData(new MeasurementDataNumeric(request, Double.valueOf(value.doubleValue())));
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to obtain measurement [" + name + "]"), (Throwable)e);
            }
        }
    }

    protected String getAttributeName(String property) {
        String theProperty = this.replaceGlobalRequestProcessorNameProps(property);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Finding metrics for: " + theProperty));
        }
        return theProperty;
    }

    private String getGlobalRequestProcessorName() {
        String name = "Catalina:type=GlobalRequestProcessor,name=%handler%%address%-%port%";
        return this.replaceGlobalRequestProcessorNameProps(name);
    }

    private String replaceGlobalRequestProcessorNameProps(String name) {
        String result = name;
        Configuration pluginConfiguration = this.getResourceContext().getPluginConfiguration();
        String port = pluginConfiguration.getSimple(PLUGIN_CONFIG_PORT).getStringValue();
        String handler = pluginConfiguration.getSimple(PLUGIN_CONFIG_HANDLER).getStringValue();
        String address = pluginConfiguration.getSimpleValue(PLUGIN_CONFIG_ADDRESS, "");
        if (!"".equals(address)) {
            StringBuilder sb = new StringBuilder("-");
            sb.append(address);
            if (!address.contains(".")) {
                try {
                    String ip = InetAddress.getByName(address).getHostAddress();
                    sb.append("%2F");
                    sb.append(ip);
                    address = sb.toString();
                }
                catch (UnknownHostException e) {
                    this.log.debug((Object)("Failed to resolve host [" + address + "]. Can not get objectName for property: " + name));
                }
            } else {
                address = sb.toString();
            }
        }
        result = result.replace("%port%", port);
        result = result.replace("%address%", address);
        result = result.replace("%handler%", handler);
        return result;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        ResourceContext context = this.getResourceContext();
        ConfigurationDefinition configDef = context.getResourceType().getResourceConfigurationDefinition();
        String protocol = report.getConfiguration().getSimpleValue(CONFIG_PROTOCOL, null);
        if (null == protocol || protocol.toUpperCase().contains("HTTP")) {
            for (PropertyDefinition propDef : configDef.getPropertiesInGroup("AJP")) {
                report.getConfiguration().remove(propDef.getName());
            }
        }
        if (null == protocol || protocol.toUpperCase().contains("AJP")) {
            for (PropertyDefinition propDef : configDef.getPropertiesInGroup("HTTP")) {
                report.getConfiguration().remove(propDef.getName());
            }
            for (PropertyDefinition propDef : configDef.getPropertiesInGroup("HTTP SSL")) {
                report.getConfiguration().remove(propDef.getName());
            }
        }
        if (((TomcatServerComponent)this.getResourceContext().getParentResourceComponent()).getResourceContext().getVersion().startsWith("5")) {
            report.getConfiguration().remove(CONFIG_V5_KEEP_ALIVE_TIMEOUT);
        }
        super.updateResourceConfiguration(report);
        if (ConfigurationUpdateStatus.SUCCESS != report.getStatus()) {
            return;
        }
        try {
            this.storeConfig();
        }
        catch (Exception e) {
            report.setErrorMessage("Failed to persist configuration change.  Changes will not survive Tomcat restart unless a successful Store Configuration operation is performed.");
        }
    }

    void storeConfig() throws Exception {
        ((TomcatServerComponent)this.getResourceContext().getParentResourceComponent()).storeConfig();
    }
}

