/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.file.def;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.bytes.ByteArray;
import org.jbpm.module.def.ModuleDefinition;
import org.jbpm.module.exe.ModuleInstance;
import org.jbpm.util.IoUtil;

public class FileDefinition
extends ModuleDefinition {
    private static final long serialVersionUID = 1L;
    String dir = null;
    Map processFiles = null;
    private static final Log log = LogFactory.getLog((Class)FileDefinition.class);

    static String getRootDir() {
        String rootDir = null;
        if (JbpmConfiguration.Configs.hasObject("jbpm.files.dir")) {
            rootDir = JbpmConfiguration.Configs.getString("jbpm.files.dir");
        }
        return rootDir;
    }

    public ModuleInstance createInstance() {
        return null;
    }

    public void addFile(String name, byte[] bytes) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        this.addFile(name, bais);
    }

    public void addFile(String name, InputStream is) {
        try {
            if (this.isStoredOnFileSystem()) {
                this.storeFileOnFileSystem(name, is);
            } else {
                this.storeFileInDb(name, is);
            }
        }
        catch (Exception e) {
            throw new JbpmException("file '" + name + "' could not be stored", e);
        }
    }

    void storeFileOnFileSystem(String name, InputStream is) throws FileNotFoundException, IOException {
        String fileName = this.getFilePath(name);
        log.trace((Object)("storing file '" + name + "' on file system to '" + fileName + "'"));
        FileOutputStream fos = new FileOutputStream(fileName);
        IoUtil.transfer(is, fos);
        fos.close();
    }

    void storeFileInDb(String name, InputStream is) throws IOException {
        if (this.processFiles == null) {
            this.processFiles = new HashMap();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        log.trace((Object)("preparing file '" + name + "' for storage in the database"));
        IoUtil.transfer(is, baos);
        this.processFiles.put(name, new ByteArray(name, baos.toByteArray()));
    }

    public InputStream getInputStream(String name) {
        InputStream inputStream = null;
        try {
            inputStream = this.isStoredOnFileSystem() ? this.getInputStreamFromFileSystem(name) : this.getInputStreamFromDb(name);
        }
        catch (Exception e) {
            throw new JbpmException("couldn't get inputstream for file '" + name + "'", e);
        }
        return inputStream;
    }

    public Map getInputStreamMap() {
        HashMap<String, InputStream> result = new HashMap<String, InputStream>();
        if (this.processFiles != null) {
            Iterator iterator = this.processFiles.keySet().iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                result.put(name, this.getInputStream(name));
            }
        }
        return result;
    }

    public Map getBytesMap() {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        if (this.processFiles != null) {
            Iterator iterator = this.processFiles.keySet().iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                result.put(name, this.getBytes(name));
            }
        }
        return result;
    }

    private InputStream getInputStreamFromFileSystem(String name) throws FileNotFoundException {
        FileInputStream inputStream = null;
        String fileName = this.getFilePath(name);
        log.trace((Object)("loading file '" + name + "' from file system '" + fileName + "'"));
        inputStream = new FileInputStream(fileName);
        return inputStream;
    }

    private InputStream getInputStreamFromDb(String name) {
        ByteArrayInputStream inputStream = null;
        log.trace((Object)("loading file '" + name + "' from database"));
        ByteArray byteArray = this.getByteArray(name);
        inputStream = new ByteArrayInputStream(byteArray.getBytes());
        return inputStream;
    }

    public byte[] getBytes(String name) {
        byte[] bytes = null;
        try {
            bytes = this.isStoredOnFileSystem() ? this.getBytesFromFileSystem(name) : this.getBytesFromDb(name);
        }
        catch (Exception e) {
            throw new JbpmException("couldn't get value for file '" + name + "'", e);
        }
        return bytes;
    }

    byte[] getBytesFromFileSystem(String name) throws IOException {
        byte[] bytes = null;
        InputStream in = this.getInputStreamFromFileSystem(name);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IoUtil.transfer(in, out);
        bytes = out.toByteArray();
        return bytes;
    }

    byte[] getBytesFromDb(String name) {
        ByteArray byteArray = this.getByteArray(name);
        byte[] bytes = byteArray.getBytes();
        return bytes;
    }

    ByteArray getByteArray(String name) {
        ByteArray byteArray = this.processFiles != null ? this.processFiles.get(name) : null;
        if (byteArray == null) {
            throw new JbpmException("file '" + name + "' not found in db");
        }
        return byteArray;
    }

    boolean isStoredOnFileSystem() {
        boolean isStoredOnFileSystem;
        String rootDir = FileDefinition.getRootDir();
        boolean bl = isStoredOnFileSystem = rootDir != null;
        if (isStoredOnFileSystem && this.dir == null) {
            this.dir = this.findNewDirName();
            new File(rootDir + "/" + this.dir).mkdirs();
        }
        return isStoredOnFileSystem;
    }

    String findNewDirName() {
        String newDirName = "files-1";
        File parentFile = new File(FileDefinition.getRootDir());
        if (parentFile.exists()) {
            String[] children = parentFile.list();
            ArrayList<Object> fileNames = new ArrayList();
            if (children != null) {
                fileNames = new ArrayList<String>(Arrays.asList(children));
            }
            int seqNr = 1;
            while (fileNames.contains(newDirName)) {
                newDirName = "files-" + ++seqNr;
            }
        }
        return newDirName;
    }

    String getFilePath(String name) {
        String filePath = FileDefinition.getRootDir() + "/" + this.dir + "/" + name;
        new File(filePath).getParentFile().mkdirs();
        return filePath;
    }
}

