/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import mazz.i18n.Logger;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.enterprise.agent.AgentConfigurationConstants;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.communications.ServiceContainerConfiguration;
import org.rhq.enterprise.communications.command.client.ClientCommandSenderConfiguration;
import org.rhq.enterprise.communications.util.SecurityUtil;

public class AgentConfiguration {
    private static final Logger LOG = AgentI18NFactory.getLogger(AgentConfiguration.class);
    private final Preferences m_preferences;

    public static String buildServerLocatorUri(String transport, String bind_address, int bind_port, String transport_params) {
        transport_params = transport_params.trim();
        String locator_uri = transport + "://" + bind_address + ":" + bind_port;
        if (transport_params.length() > 0) {
            locator_uri = transport_params.startsWith("/") ? locator_uri + transport_params : locator_uri + "/?" + transport_params;
        }
        return locator_uri;
    }

    public AgentConfiguration(Preferences prefs) {
        if (prefs == null) {
            throw new IllegalArgumentException(LOG.getMsgString("AgentConfiguration.prefs-must-not-be-null", new Object[0]));
        }
        this.m_preferences = prefs;
    }

    public Preferences getPreferences() {
        return this.m_preferences;
    }

    public ServiceContainerConfiguration getServiceContainerPreferences() {
        return new ServiceContainerConfiguration(this.m_preferences);
    }

    public int getAgentConfigurationVersion() {
        int value = this.m_preferences.getInt("rhq.agent.configuration-schema-version", 0);
        return value;
    }

    public void tagWithAgentConfigurationVersion() {
        this.m_preferences.putInt("rhq.agent.configuration-schema-version", 6);
        this.flush("rhq.agent.configuration-schema-version");
    }

    public boolean isAgentConfigurationSetup() {
        boolean value = this.m_preferences.getBoolean("rhq.agent.configuration-setup-flag", false);
        return value;
    }

    public void setAgentConfigurationSetup(boolean flag) {
        this.m_preferences.putBoolean("rhq.agent.configuration-setup-flag", flag);
        this.flush("rhq.agent.configuration-setup-flag");
    }

    public String getAgentName() {
        String name = this.m_preferences.get("rhq.agent.name", null);
        return name;
    }

    public String getServerTransport() {
        String value = this.m_preferences.get("rhq.agent.server.transport", "servlet");
        return value;
    }

    public String getServerBindAddress() {
        String address = this.m_preferences.get("rhq.agent.server.bind-address", null);
        if (address == null) {
            String alias = this.m_preferences.get("rhq.agent.server.alias", null);
            if (alias != null) {
                try {
                    address = InetAddress.getByName(alias).getCanonicalHostName();
                }
                catch (Exception e1) {
                    LOG.debug("AgentConfiguration.server-alias-unknown", new Object[]{alias, e1});
                    address = null;
                }
            }
            if (address == null) {
                try {
                    address = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException e2) {
                    address = "127.0.0.1";
                }
            }
        }
        return address;
    }

    public int getServerBindPort() {
        int value = this.m_preferences.getInt("rhq.agent.server.bind-port", 7080);
        return value;
    }

    public String getServerTransportParams() {
        String value = this.m_preferences.get("rhq.agent.server.transport-params", "/jboss-remoting-servlet-invoker/ServerInvokerServlet");
        return value;
    }

    public String getServerLocatorUri() {
        String transport = this.getServerTransport();
        String bind_address = this.getServerBindAddress();
        int bind_port = this.getServerBindPort();
        String transport_params = this.getServerTransportParams();
        return AgentConfiguration.buildServerLocatorUri(transport, bind_address, bind_port, transport_params);
    }

    public void setServerLocatorUri(String transport, String bindAddress, int bindPort, String transportParams) {
        this.m_preferences.put("rhq.agent.server.transport", transport);
        this.m_preferences.put("rhq.agent.server.bind-address", bindAddress);
        this.m_preferences.putInt("rhq.agent.server.bind-port", bindPort);
        this.m_preferences.put("rhq.agent.server.transport-params", transportParams);
        this.flush("ServerLocatorUri");
    }

    public boolean isServerAutoDetectionEnabled() {
        boolean flag = this.m_preferences.getBoolean("rhq.agent.server-auto-detection", false);
        return flag;
    }

    public boolean isRegisterWithServerAtStartupEnabled() {
        boolean flag = this.m_preferences.getBoolean("rhq.agent.register-with-server-at-startup", true);
        return flag;
    }

    public long getWaitForServerAtStartupMsecs() {
        long value = this.m_preferences.getLong("rhq.agent.wait-for-server-at-startup-msecs", 60000L);
        return value;
    }

    public boolean isAgentUpdateEnabled() {
        boolean flag = this.m_preferences.getBoolean("rhq.agent.agent-update.enabled", true);
        return flag;
    }

    public String getAgentUpdateVersionUrlIfDefined() {
        String str = this.m_preferences.get("rhq.agent.agent-update.version-url", null);
        return str;
    }

    public String getAgentUpdateVersionUrl() {
        String str = this.m_preferences.get("rhq.agent.agent-update.version-url", null);
        if (str == null) {
            String transport = SecurityUtil.isTransportSecure((String)this.getServerTransport()) ? "https" : "http";
            String address = this.getServerBindAddress();
            int port = this.getServerBindPort();
            str = transport + "://" + address + ":" + port + "/agentupdate/version";
        }
        return str;
    }

    public String getAgentUpdateDownloadUrlIfDefined() {
        String str = this.m_preferences.get("rhq.agent.agent-update.download-url", null);
        return str;
    }

    public String getAgentUpdateDownloadUrl() {
        String str = this.m_preferences.get("rhq.agent.agent-update.download-url", null);
        if (str == null) {
            String transport = SecurityUtil.isTransportSecure((String)this.getServerTransport()) ? "https" : "http";
            String address = this.getServerBindAddress();
            int port = this.getServerBindPort();
            str = transport + "://" + address + ":" + port + "/agentupdate/download";
        }
        return str;
    }

    public long getPrimaryServerSwitchoverCheckIntervalMsecs() {
        long value = this.m_preferences.getLong("rhq.agent.primary-server-switchover-check-interval-msecs", 3600000L);
        return value;
    }

    public long getVMHealthCheckIntervalMsecs() {
        long value = this.m_preferences.getLong("rhq.agent.vm-health-check.interval-msecs", 5000L);
        return value;
    }

    public float getVMHealthCheckLowHeapMemThreshold() {
        float value = this.m_preferences.getFloat("rhq.agent.vm-health-check.low-heap-mem-threshold", 0.9f);
        return value;
    }

    public float getVMHealthCheckLowNonHeapMemThreshold() {
        float value = this.m_preferences.getFloat("rhq.agent.vm-health-check.low-nonheap-mem-threshold", 0.9f);
        return value;
    }

    public boolean isUpdatePluginsAtStartupEnabled() {
        boolean flag = this.m_preferences.getBoolean("rhq.agent.update-plugins-at-startup", true);
        return flag;
    }

    public File getDataDirectory() {
        String dir_str = this.m_preferences.get("rhq.agent.data-directory", "data");
        File dir = new File(dir_str);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public String getDataDirectoryIfDefined() {
        String dir_str = this.m_preferences.get("rhq.agent.data-directory", null);
        return dir_str;
    }

    public boolean isNativeSystemDisabled() {
        boolean flag = this.m_preferences.getBoolean("rhq.agent.disable-native-system", false);
        return flag;
    }

    public int getClientSenderQueueSize() {
        int value = this.m_preferences.getInt("rhq.agent.client.queue-size", 50000);
        return value;
    }

    public int getClientSenderMaxConcurrent() {
        int value = this.m_preferences.getInt("rhq.agent.client.max-concurrent", 5);
        if (value < 1) {
            LOG.warn("AgentConfiguration.pref-must-be-greater-than-0", new Object[]{"rhq.agent.client.max-concurrent", value, 5});
            value = 5;
        }
        return value;
    }

    public long getClientSenderCommandTimeout() {
        long value = this.m_preferences.getLong("rhq.agent.client.command-timeout-msecs", 600000L);
        return value;
    }

    public long getClientSenderServerPollingInterval() {
        long value = this.m_preferences.getLong("rhq.agent.client.server-polling-interval-msecs", 60000L);
        return value;
    }

    public long getClientSenderRetryInterval() {
        long value = this.m_preferences.getLong("rhq.agent.client.retry-interval-msecs", 15000L);
        return value;
    }

    public int getClientSenderMaxRetries() {
        int value = this.m_preferences.getInt("rhq.agent.client.max-retries", 10);
        return value;
    }

    public String getClientSenderCommandSpoolFileName() {
        String dir_str = this.m_preferences.get("rhq.agent.client.command-spool-file.name", "command-spool.dat");
        return dir_str;
    }

    public long[] getClientSenderCommandSpoolFileParams() {
        String value = this.m_preferences.get("rhq.agent.client.command-spool-file.params", "10000000:75");
        long[] ret_params = this.isClientSenderCommandSpoolFileParamsValueValid(value);
        return ret_params;
    }

    public long[] isClientSenderCommandSpoolFileParamsValueValid(String pref_value) {
        long[] ret_params;
        block5: {
            ret_params = null;
            try {
                String[] numbers = pref_value.split("\\s*:\\s*");
                if (numbers.length == 2) {
                    ret_params = new long[]{Long.parseLong(numbers[0]), Long.parseLong(numbers[1])};
                    if (ret_params[0] < 10000L) {
                        throw new NumberFormatException(LOG.getMsgString("AgentConfiguration.command-spool-invalid-max-size", new Object[0]));
                    }
                    if (ret_params[1] < 0L || ret_params[1] >= 100L) {
                        throw new NumberFormatException(LOG.getMsgString("AgentConfiguration.command-spool-invalid-purge-percentage", new Object[0]));
                    }
                    break block5;
                }
                throw new NumberFormatException(LOG.getMsgString("AgentConfiguration.command-spool-invalid-format", new Object[0]));
            }
            catch (Exception e) {
                ret_params = null;
                LOG.warn("AgentConfiguration.bad-command-spool-pref", new Object[]{"rhq.agent.client.command-spool-file.params", pref_value, e});
            }
        }
        return ret_params;
    }

    public boolean isClientSenderCommandSpoolFileCompressed() {
        boolean flag = this.m_preferences.getBoolean("rhq.agent.client.command-spool-file.compressed", false);
        return flag;
    }

    public long[] getClientSenderSendThrottling() {
        String value = this.m_preferences.get("rhq.agent.client.send-throttling", null);
        long[] ret_throttling_params = this.isClientSenderSendThrottlingValueValid(value);
        return ret_throttling_params;
    }

    public long[] isClientSenderSendThrottlingValueValid(String pref_value) {
        long[] ret_throttling_params;
        block6: {
            ret_throttling_params = null;
            if (pref_value != null) {
                try {
                    String[] numbers = pref_value.split("\\s*:\\s*");
                    if (numbers.length == 2) {
                        ret_throttling_params = new long[]{Long.parseLong(numbers[0]), Long.parseLong(numbers[1])};
                        if (ret_throttling_params[0] <= 0L) {
                            throw new NumberFormatException(LOG.getMsgString("AgentConfiguration.send-throttle-invalid-max", new Object[0]));
                        }
                        if (ret_throttling_params[1] < 100L) {
                            throw new NumberFormatException(LOG.getMsgString("AgentConfiguration.send-throttle-invalid-quiet-period", new Object[]{100L}));
                        }
                        break block6;
                    }
                    throw new NumberFormatException(LOG.getMsgString("AgentConfiguration.send-throttle-invalid-format", new Object[0]));
                }
                catch (Exception e) {
                    ret_throttling_params = null;
                    LOG.warn("AgentConfiguration.bad-send-throttle-pref", new Object[]{"rhq.agent.client.send-throttling", pref_value, e});
                }
            }
        }
        return ret_throttling_params;
    }

    public long[] getClientSenderQueueThrottling() {
        String value = this.m_preferences.get("rhq.agent.client.queue-throttling", null);
        long[] ret_throttling_params = this.isClientSenderQueueThrottlingValueValid(value);
        return ret_throttling_params;
    }

    public long[] isClientSenderQueueThrottlingValueValid(String pref_value) {
        long[] ret_throttling_params;
        block6: {
            ret_throttling_params = null;
            if (pref_value != null) {
                try {
                    String[] numbers = pref_value.split("\\s*:\\s*");
                    if (numbers.length == 2) {
                        ret_throttling_params = new long[]{Long.parseLong(numbers[0]), Long.parseLong(numbers[1])};
                        if (ret_throttling_params[0] <= 0L) {
                            throw new NumberFormatException(LOG.getMsgString("AgentConfiguration.queue-throttle-invalid-max", new Object[0]));
                        }
                        if (ret_throttling_params[1] < 100L) {
                            throw new NumberFormatException(LOG.getMsgString("AgentConfiguration.queue-throttle-invalid-burst-period", new Object[]{100L}));
                        }
                        break block6;
                    }
                    throw new NumberFormatException(LOG.getMsgString("AgentConfiguration.queue-throttle-invalid-format", new Object[0]));
                }
                catch (Exception e) {
                    ret_throttling_params = null;
                    LOG.warn("AgentConfiguration.bad-queue-throttle-pref", new Object[]{"rhq.agent.client.queue-throttling", pref_value, e});
                }
            }
        }
        return ret_throttling_params;
    }

    public String getClientSenderCommandPreprocessors() {
        String value = this.m_preferences.get("rhq.agent.client.command-preprocessors", AgentConfigurationConstants.DEFAULT_CLIENT_SENDER_COMMAND_PREPROCESSORS);
        return value;
    }

    public ClientCommandSenderConfiguration getClientCommandSenderConfiguration() {
        ClientCommandSenderConfiguration config = new ClientCommandSenderConfiguration();
        config.defaultTimeoutMillis = this.getClientSenderCommandTimeout();
        config.maxConcurrent = this.getClientSenderMaxConcurrent();
        config.queueSize = this.getClientSenderQueueSize();
        config.dataDirectory = this.getDataDirectory();
        config.serverPollingIntervalMillis = this.getClientSenderServerPollingInterval();
        config.commandSpoolFileCompressData = this.isClientSenderCommandSpoolFileCompressed();
        config.retryInterval = this.getClientSenderRetryInterval();
        config.maxRetries = this.getClientSenderMaxRetries();
        config.commandSpoolFileName = this.getClientSenderCommandSpoolFileName();
        config.commandPreprocessors = this.getClientSenderCommandPreprocessors();
        long[] cmd_spool_file_params = this.getClientSenderCommandSpoolFileParams();
        config.commandSpoolFileMaxSize = cmd_spool_file_params[0];
        config.commandSpoolFilePurgePercentage = (int)cmd_spool_file_params[1];
        long[] queue_throttling = this.getClientSenderQueueThrottling();
        if (queue_throttling != null) {
            config.enableQueueThrottling = true;
            config.queueThrottleMaxCommands = queue_throttling[0];
            config.queueThrottleBurstPeriodMillis = queue_throttling[1];
        } else {
            config.enableQueueThrottling = false;
        }
        long[] send_throttling = this.getClientSenderSendThrottling();
        if (send_throttling != null) {
            config.enableSendThrottling = true;
            config.sendThrottleMaxCommands = send_throttling[0];
            config.sendThrottleQuietPeriodDurationMillis = send_throttling[1];
        } else {
            config.enableSendThrottling = false;
        }
        config.securityServerAuthMode = this.isClientSenderSecurityServerAuthMode();
        config.securityKeystoreFile = this.getClientSenderSecurityKeystoreFile();
        config.securityKeystoreType = this.getClientSenderSecurityKeystoreType();
        config.securityKeystoreAlgorithm = this.getClientSenderSecurityKeystoreAlgorithm();
        config.securityKeystorePassword = this.getClientSenderSecurityKeystorePassword();
        config.securityKeystoreKeyPassword = this.getClientSenderSecurityKeystoreKeyPassword();
        config.securityKeystoreAlias = this.getClientSenderSecurityKeystoreAlias();
        config.securityTruststoreFile = this.getClientSenderSecurityTruststoreFile();
        config.securityTruststoreType = this.getClientSenderSecurityTruststoreType();
        config.securityTruststoreAlgorithm = this.getClientSenderSecurityTruststoreAlgorithm();
        config.securityTruststorePassword = this.getClientSenderSecurityTruststorePassword();
        config.securitySecureSocketProtocol = this.getClientSenderSecuritySocketProtocol();
        return config;
    }

    public String getClientSenderSecuritySocketProtocol() {
        String value = this.m_preferences.get("rhq.agent.client.security.secure-socket-protocol", "TLS");
        return value;
    }

    public String getClientSenderSecurityKeystoreAlias() {
        String value = this.m_preferences.get("rhq.agent.client.security.keystore.alias", "rhq");
        return value;
    }

    public String getClientSenderSecurityKeystoreFile() {
        String value = this.m_preferences.get("rhq.agent.client.security.keystore.file", null);
        if (value == null) {
            value = new File(this.getDataDirectory(), "keystore.dat").getAbsolutePath();
        }
        return value;
    }

    public String getClientSenderSecurityKeystoreAlgorithm() {
        String value = this.m_preferences.get("rhq.agent.client.security.keystore.algorithm", "SunX509");
        return value;
    }

    public String getClientSenderSecurityKeystoreType() {
        String value = this.m_preferences.get("rhq.agent.client.security.keystore.type", "JKS");
        return value;
    }

    public String getClientSenderSecurityKeystorePassword() {
        String value = this.m_preferences.get("rhq.agent.client.security.keystore.password", "rhqpwd");
        return value;
    }

    public String getClientSenderSecurityKeystoreKeyPassword() {
        String value = this.m_preferences.get("rhq.agent.client.security.keystore.key-password", null);
        if (value == null) {
            value = this.getClientSenderSecurityKeystorePassword();
        }
        return value;
    }

    public String getClientSenderSecurityTruststoreFile() {
        String value = this.m_preferences.get("rhq.agent.client.security.truststore.file", null);
        if (value == null) {
            value = new File(this.getDataDirectory(), "truststore.dat").getAbsolutePath();
        }
        return value;
    }

    public String getClientSenderSecurityTruststoreAlgorithm() {
        String value = this.m_preferences.get("rhq.agent.client.security.truststore.algorithm", "SunX509");
        return value;
    }

    public String getClientSenderSecurityTruststoreType() {
        String value = this.m_preferences.get("rhq.agent.client.security.truststore.type", "JKS");
        return value;
    }

    public String getClientSenderSecurityTruststorePassword() {
        String value = this.m_preferences.get("rhq.agent.client.security.truststore.password", null);
        return value;
    }

    public boolean isClientSenderSecurityServerAuthMode() {
        boolean flag = this.m_preferences.getBoolean("rhq.agent.client.security.server-auth-mode-enabled", false);
        return flag;
    }

    public PluginContainerConfiguration getPluginContainerConfiguration() {
        String clRegex;
        String plugin_dir_str = this.m_preferences.get("rhq.agent.plugins.directory", "plugins");
        File plugin_dir = new File(plugin_dir_str);
        if (!plugin_dir.exists()) {
            plugin_dir.mkdirs();
        }
        long server_discovery_period = this.m_preferences.getLong("rhq.agent.plugins.server-discovery.period-secs", 900L);
        long server_discovery_initial_delay = this.m_preferences.getLong("rhq.agent.plugins.server-discovery.initial-delay-secs", 10L);
        long service_discovery_period = this.m_preferences.getLong("rhq.agent.plugins.service-discovery.period-secs", 86400L);
        long service_discovery_initial_delay = this.m_preferences.getLong("rhq.agent.plugins.service-discovery.initial-delay-secs", 20L);
        long avail_scan_period = this.m_preferences.getLong("rhq.agent.plugins.availability-scan.period-secs", 300L);
        long avail_scan_initial_delay = this.m_preferences.getLong("rhq.agent.plugins.availability-scan.initial-delay-secs", 5L);
        long meas_scan_initial_delay = this.m_preferences.getLong("rhq.agent.plugins.measurement-collection.initial-delay-secs", 30L);
        String name = this.getAgentName();
        int meas_threadpool_size = this.m_preferences.getInt("rhq.agent.plugins.measurement-collection.threadpool-size", 5);
        int op_threadpool_size = this.m_preferences.getInt("rhq.agent.plugins.operation-invoker.threadpool-size", 10);
        long op_timeout = this.m_preferences.getLong("rhq.agent.plugins.operation-invocation-timeout-secs", 600L);
        long con_period = this.m_preferences.getLong("rhq.agent.plugins.content-discovery.period-secs", 30L);
        long con_initial_delay = this.m_preferences.getLong("rhq.agent.plugins.content-discovery.initial-delay-secs", 60L);
        int con_threadpool_size = this.m_preferences.getInt("rhq.agent.plugins.content-discovery.threadpool-size", 10);
        long config_discovery_initial_delay = this.m_preferences.getLong("rhq.agent.plugins.configuration-discovery.initial-delay-secs", 300L);
        long config_discovery_period = this.m_preferences.getLong("rhq.agent.plugins.configuration-discovery.period-secs", 3600L);
        long event_sender_initial_delay = this.m_preferences.getLong("rhq.agent.plugins.event-sender.initial-delay-secs", 30L);
        long event_sender_period = this.m_preferences.getLong("rhq.agent.plugins.event-sender.period-secs", 30L);
        int event_report_max_per_src = this.m_preferences.getInt("rhq.agent.plugins.event-report.max-per-source", 200);
        int event_report_max_total = this.m_preferences.getInt("rhq.agent.plugins.event-report.max-total", 400);
        File data_directory = this.getDataDirectory();
        File tmp_directory = new File(data_directory, "tmp");
        if (!tmp_directory.exists()) {
            tmp_directory.mkdir();
        }
        String disabled_pref = this.m_preferences.get("rhq.agent.plugins.disabled", null);
        ArrayList<String> disabled_plugins = null;
        if (disabled_pref != null) {
            String[] array = disabled_pref.split(",");
            disabled_plugins = new ArrayList<String>(Arrays.asList(array));
        }
        if ((clRegex = this.m_preferences.get("rhq.agent.plugins.root-plugin-classloader-regex", null)) == null) {
            clRegex = PluginContainerConfiguration.getDefaultClassLoaderFilter();
        }
        PluginContainerConfiguration config = new PluginContainerConfiguration();
        config.setInsideAgent(true);
        config.setPluginDirectory(plugin_dir);
        config.setDataDirectory(data_directory);
        config.setTemporaryDirectory(tmp_directory);
        config.setDisabledPlugins(disabled_plugins);
        config.setRootPluginClassLoaderRegex(clRegex);
        config.setServerDiscoveryInitialDelay(server_discovery_initial_delay);
        config.setServerDiscoveryPeriod(server_discovery_period);
        config.setServiceDiscoveryInitialDelay(service_discovery_initial_delay);
        config.setServiceDiscoveryPeriod(service_discovery_period);
        config.setAvailabilityScanInitialDelay(avail_scan_initial_delay);
        config.setAvailabilityScanPeriod(avail_scan_period);
        config.setMeasurementCollectionThreadPoolSize(meas_threadpool_size);
        config.setMeasurementCollectionInitialDelay(meas_scan_initial_delay);
        config.setOperationInvokerThreadPoolSize(op_threadpool_size);
        config.setOperationInvocationTimeout(op_timeout);
        config.setContentDiscoveryThreadPoolSize(con_threadpool_size);
        config.setContentDiscoveryInitialDelay(con_initial_delay);
        config.setContentDiscoveryPeriod(con_period);
        config.setConfigurationDiscoveryInitialDelay(config_discovery_initial_delay);
        config.setConfigurationDiscoveryPeriod(config_discovery_period);
        config.setEventSenderInitialDelay(event_sender_initial_delay);
        config.setEventSenderPeriod(event_sender_period);
        config.setEventReportMaxPerSource(event_report_max_per_src);
        config.setEventReportMaxTotal(event_report_max_total);
        if (name != null) {
            config.setContainerName(name);
        }
        return config;
    }

    public String getAgentSecurityToken() {
        String value = this.m_preferences.get("rhq.agent.security-token", null);
        return value;
    }

    public void setAgentSecurityToken(String value) {
        if (value != null) {
            this.m_preferences.put("rhq.agent.security-token", value);
            this.flush("rhq.agent.security-token");
        } else {
            this.m_preferences.remove("rhq.agent.security-token");
        }
    }

    public boolean doNotEnableManagementServices() {
        boolean flag = this.m_preferences.getBoolean("rhq.agent.do-not-enable-management-services", false);
        return flag;
    }

    public boolean doNotStartPluginContainerAtStartup() {
        boolean flag = this.m_preferences.getBoolean("rhq.agent.do-not-start-pc-at-startup", false);
        return flag;
    }

    public boolean doNotNotifyServerOfShutdown() {
        boolean flag = this.m_preferences.getBoolean("rhq.agent.do-not-notify-server-of-shutdown", false);
        return flag;
    }

    public boolean doNotOverridePreferencesWithSystemProperties() {
        boolean flag = this.m_preferences.getBoolean("rhq.agent.do-not-override-prefs-with-sysprops", false);
        return flag;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.m_preferences.absolutePath());
        buf.append('[');
        try {
            String[] keys = this.m_preferences.keys();
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                buf.append(key);
                buf.append('=');
                buf.append(this.m_preferences.get(key, LOG.getMsgString("AgentConfiguration.unknown", new Object[0])));
                if (i + 1 >= keys.length) continue;
                buf.append(',');
            }
        }
        catch (BackingStoreException e) {
            buf.append(LOG.getMsgString("AgentConfiguration.cannot-get-preferences", new Object[]{e}));
        }
        buf.append(']');
        return buf.toString();
    }

    private void flush(String changedPreference) {
        try {
            this.m_preferences.flush();
        }
        catch (Exception e) {
            LOG.warn("AgentConfiguration.cannot-store-preferences", new Object[]{changedPreference, e});
        }
    }
}

