/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.augeas.tree.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.augeas.Augeas;
import org.rhq.augeas.config.AugeasModuleConfig;
import org.rhq.augeas.node.AugeasNode;
import org.rhq.augeas.tree.AugeasNodeBuffer;
import org.rhq.augeas.tree.AugeasTree;
import org.rhq.augeas.tree.AugeasTreeException;
import org.rhq.augeas.util.Glob;

public abstract class AbstractAugeasTree
implements AugeasTree {
    private static final String[] ERROR_NODES = new String[]{"pos", "line", "char", "lens", "message"};
    private Augeas augeas;
    private AugeasModuleConfig moduleConfig;
    private AugeasNode rootNode;
    private AugeasNodeBuffer nodeBuffer;

    protected AbstractAugeasTree(Augeas ag, AugeasModuleConfig moduleConfig) {
        this.augeas = ag;
        this.moduleConfig = moduleConfig;
        this.nodeBuffer = new AugeasNodeBuffer();
    }

    protected Augeas getAugeas() {
        return this.augeas;
    }

    protected AugeasModuleConfig getModuleConfig() {
        return this.moduleConfig;
    }

    protected AugeasNodeBuffer getNodeBuffer() {
        return this.nodeBuffer;
    }

    @Override
    public AugeasNode createNode(AugeasNode parentNode, String name, String value, int seq) throws AugeasTreeException {
        AugeasNode nd = this.createNode(parentNode.getFullPath() + File.separatorChar + name + "[" + String.valueOf(seq) + "]");
        nd.setValue(value);
        return nd;
    }

    @Override
    public String get(String expr) {
        return this.augeas.get(expr);
    }

    @Override
    public File getFile(AugeasNode node) {
        String path = node.getPath().substring("/files".length());
        String[] pathSegments = path.split("\\/");
        File root = File.listRoots()[0];
        for (String glob : this.getIncludeGlobs()) {
            int sepCnt = this.getSeparatorCount(glob);
            if (sepCnt >= pathSegments.length) continue;
            StringBuilder bld = new StringBuilder();
            for (int i = 0; i < sepCnt + 1; ++i) {
                bld.append(pathSegments[i]);
                if (i >= sepCnt) continue;
                bld.append('/');
            }
            File f = new File(bld.toString());
            if (!Glob.matches(root, glob, f)) continue;
            return f;
        }
        return null;
    }

    @Override
    public AugeasNode getNode(String path) throws AugeasTreeException {
        AugeasNode node = this.getLoadedNode(path);
        return node == null ? this.createNode(path) : node;
    }

    @Override
    public AugeasNode getRootNode() {
        return this.rootNode;
    }

    @Override
    public List<AugeasNode> match(String expression) throws AugeasTreeException {
        List res = this.augeas.match(expression);
        ArrayList<AugeasNode> nodes = new ArrayList<AugeasNode>();
        for (String name : res) {
            nodes.add(this.getNode(name));
        }
        return nodes;
    }

    @Override
    public List<AugeasNode> matchRelative(AugeasNode node, String expression) throws AugeasTreeException {
        if (this.rootNode.getChildNodes().isEmpty()) {
            throw new AugeasTreeException("Root node has no children.");
        }
        if (((Object)node).equals(this.rootNode)) {
            List<AugeasNode> nodes = this.rootNode.getChildNodes();
            ArrayList<AugeasNode> returnNodes = new ArrayList<AugeasNode>();
            for (AugeasNode nd : nodes) {
                String tempName = nd.getFullPath() + expression;
                List<AugeasNode> temp = this.match(tempName);
                returnNodes.addAll(temp);
            }
            return returnNodes;
        }
        return this.match(node.getFullPath() + '/' + expression);
    }

    @Override
    public void save() {
        this.augeas.save();
    }

    @Override
    public void setRootNode(AugeasNode node) {
        this.rootNode = node;
    }

    @Override
    public void setValue(AugeasNode node, String value) {
        this.augeas.set(node.getFullPath(), value);
    }

    @Override
    public String summarizeAugeasError() {
        String nodePrefix = "/augeas/files";
        List<String> str = this.moduleConfig.getConfigFiles();
        StringBuilder builder = new StringBuilder();
        for (String path : str) {
            String name = nodePrefix + path + File.separatorChar + "error";
            if (!this.augeas.exists(name)) continue;
            builder.append("Error " + this.augeas.get(name) + '\n');
            for (String errNd : ERROR_NODES) {
                String pathToMessage = name + File.separatorChar + errNd;
                if (!this.augeas.exists(pathToMessage)) continue;
                builder.append(errNd).append(" ").append(this.augeas.get(pathToMessage)).append('\n');
            }
        }
        return builder.toString();
    }

    protected AugeasNode getLoadedNode(String path) {
        return this.nodeBuffer.getNode(path);
    }

    protected List<String> getIncludeGlobs() {
        return this.moduleConfig.getIncludedGlobs();
    }

    private int getSeparatorCount(String path) {
        int cnt = 0;
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) != '/') continue;
            ++cnt;
        }
        return cnt;
    }
}

