/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.augeas.util;

import java.io.File;
import java.io.FileFilter;
import java.util.regex.Pattern;

public class GlobFilter
implements FileFilter {
    private String globPattern;
    private Pattern regexPattern;
    public static final char[] WILDCARD_CHARS = File.separatorChar == '\\' ? new char[]{'*', '?'} : new char[]{'*', '?', '[', ']'};

    public GlobFilter(String globPattern) {
        if (globPattern == null) {
            throw new IllegalArgumentException("The glob pattern cannot be null.");
        }
        this.globPattern = globPattern;
        this.regexPattern = GlobFilter.convert(globPattern);
    }

    public String getGlobPattern() {
        return this.globPattern;
    }

    @Override
    public boolean accept(File pathname) {
        return this.regexPattern.matcher(pathname.getAbsolutePath()).matches();
    }

    private static Pattern convert(String globPattern) {
        StringBuilder regexPattern = new StringBuilder("^");
        boolean pathStart = File.separatorChar != '\\';
        boolean inRangeSpec = false;
        block9: for (int i = 0; i < globPattern.length(); ++i) {
            switch (globPattern.charAt(i)) {
                case '\\': {
                    if (File.separatorChar == '\\') {
                        regexPattern.append("\\\\");
                    } else {
                        if (i == globPattern.length() - 1) {
                            throw new IllegalArgumentException("Illegal glob pattern: " + globPattern);
                        }
                        regexPattern.append("\\").append(globPattern.charAt(i + 1));
                        ++i;
                    }
                    pathStart = false;
                    continue block9;
                }
                case '*': {
                    if (pathStart) {
                        regexPattern.append("($|[^\\.].*)");
                    } else if (inRangeSpec) {
                        regexPattern.append("\\*");
                    } else {
                        regexPattern.append(".*");
                    }
                    pathStart = false;
                    continue block9;
                }
                case '?': {
                    if (inRangeSpec) {
                        regexPattern.append("\\?");
                    } else {
                        regexPattern.append(".");
                    }
                    pathStart = false;
                    continue block9;
                }
                case '.': {
                    regexPattern.append("\\.");
                    pathStart = false;
                    continue block9;
                }
                case '/': {
                    regexPattern.append("\\/");
                    if (File.separatorChar == '\\') continue block9;
                    pathStart = true;
                    continue block9;
                }
                case '[': {
                    regexPattern.append("[");
                    inRangeSpec = true;
                    continue block9;
                }
                case ']': {
                    regexPattern.append(']');
                    inRangeSpec = false;
                    continue block9;
                }
                default: {
                    regexPattern.append(globPattern.charAt(i));
                    pathStart = false;
                }
            }
        }
        regexPattern.append("$");
        return Pattern.compile(regexPattern.toString());
    }
}

