/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.protocols.pbcast.Digest;
import org.jgroups.protocols.ring.RingNodeFlowControl;
import org.jgroups.protocols.ring.RingToken;
import org.jgroups.protocols.ring.TokenLostException;
import org.jgroups.protocols.ring.UdpRingNode;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.RpcProtocol;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class TOTAL_TOKEN
extends RpcProtocol {
    private static final Object[] NULL_OBJ = new Object[0];
    private static final Class[] NULL_TYPES = new Class[0];
    private static final int OPERATIONAL_STATE = 0;
    private static final int RECOVERY_STATE = 1;
    UdpRingNode node;
    RingNodeFlowControl flowControl;
    Address localAddress;
    private final TokenTransmitter tokenRetransmitter = new TokenTransmitter();
    final List newMessagesQueue = Collections.synchronizedList(new ArrayList());
    SortedSet liveMembersInRecovery;
    SortedSet suspects;
    final Object mutex = new Object();
    TreeMap receivedMessagesQueue;
    long myAru = 0L;
    final Object threadCoordinationMutex = new Object();
    final boolean tokenInStack = false;
    final boolean threadDeliveringMessage = false;
    boolean tokenSeen = false;
    volatile boolean isRecoveryLeader = false;
    volatile int state;
    volatile int sleepTime = 10;
    long highestSeenSeq = 0L;
    long lastRoundTokensAru = 0L;
    int lastRoundTransmitCount;
    int lastRoundRebroadcastCount = 0;
    int blockSendingBacklogThreshold = Integer.MAX_VALUE;
    int unblockSendingBacklogThreshold = Integer.MIN_VALUE;
    boolean tokenCirculating = false;
    boolean senderBlocked = false;
    final Object block_sending = new Object();
    public static final String prot_name = "TOTAL_TOKEN";

    public String getName() {
        return prot_name;
    }

    private String getState() {
        if (this.state == 0) {
            return "OPERATIONAL";
        }
        return "RECOVERY";
    }

    public void start() throws Exception {
        super.start();
        this.receivedMessagesQueue = new TreeMap();
        this.tokenRetransmitter.start();
    }

    public void stop() {
        super.stop();
        this.tokenRetransmitter.shutDown();
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("block_sending");
        if (str != null) {
            this.blockSendingBacklogThreshold = Integer.parseInt(str);
            props.remove("block_sending");
        }
        if ((str = props.getProperty("unblock_sending")) != null) {
            this.unblockSendingBacklogThreshold = Integer.parseInt(str);
            props.remove("unblock_sending");
        }
        if (props.size() > 0) {
            this.log.error((Object)("UDP.setProperties(): the following properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    public IpAddress getTokenReceiverAddress() {
        return this.node != null ? this.node.getTokenReceiverAddress() : null;
    }

    public Vector providedUpServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(new Integer(39));
        retval.addElement(new Integer(42));
        retval.addElement(new Integer(41));
        return retval;
    }

    public boolean handleUpEvent(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.localAddress = (Address)evt.getArg();
                this.node = new UdpRingNode(this, this.localAddress);
                this.flowControl = new RingNodeFlowControl();
                break;
            }
            case 9: {
                Address suspect = (Address)evt.getArg();
                this.onSuspectMessage(suspect);
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                Header h = msg.getHeader(this.getName());
                if (h instanceof TotalTokenHeader) {
                    this.messageArrived(msg);
                    return false;
                }
                if (!(h instanceof RingTokenHeader)) break;
                if (this.node != null) {
                    Object tmp = msg.getObject();
                    this.node.tokenArrived(tmp);
                }
                return false;
            }
        }
        return true;
    }

    public boolean handleDownEvent(Event evt) {
        switch (evt.getType()) {
            case 39: 
            case 42: {
                Digest d = new Digest(this.members.size());
                Address sender = null;
                for (int j = 0; j < this.members.size(); ++j) {
                    sender = (Address)this.members.elementAt(j);
                    d.add(sender, this.highestSeenSeq, this.highestSeenSeq);
                }
                this.passUp(new Event(40, d));
                return false;
            }
            case 41: {
                Digest receivedDigest = (Digest)evt.getArg();
                this.myAru = receivedDigest.highSeqnoAt(this.localAddress);
                return false;
            }
            case 6: {
                this.onViewChange();
                return true;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                if (msg == null) {
                    return false;
                }
                if (msg.getDest() != null && !msg.getDest().isMulticastAddress()) break;
                this.newMessagesQueue.add(msg);
                return false;
            }
        }
        return true;
    }

    private void onViewChange() {
        this.isRecoveryLeader = false;
        if (this.suspects != null) {
            this.suspects.clear();
            this.suspects = null;
        }
        if (this.liveMembersInRecovery != null) {
            this.liveMembersInRecovery.clear();
            this.liveMembersInRecovery = null;
        }
    }

    private void onSuspectMessage(Address suspect) {
        this.state = 1;
        if (this.suspects == null || this.suspects.size() == 0) {
            this.suspects = Collections.synchronizedSortedSet(new TreeSet());
            this.liveMembersInRecovery = Collections.synchronizedSortedSet(new TreeSet(this.members));
        }
        this.suspects.add(suspect);
        this.liveMembersInRecovery.removeAll(this.suspects);
        this.isRecoveryLeader = this.isRecoveryLeader(this.liveMembersInRecovery);
    }

    private boolean isRecoveryLeader(SortedSet liveMembers) {
        boolean recoveryLeader = false;
        if (liveMembers.size() > 0) {
            recoveryLeader = this.localAddress.equals(liveMembers.first());
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("live memebers are " + liveMembers));
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("I am recovery leader?" + recoveryLeader));
        }
        return recoveryLeader;
    }

    public long getAllReceivedUpTo() {
        return this.myAru;
    }

    public void installTransitionalView(Vector members) {
        if (this.node != null) {
            this.node.reconfigure(members);
        }
    }

    private void recover() {
        if (this.isRecoveryLeader && this.state == 1) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"I am starting recovery now");
            }
            Vector m = new Vector(this.liveMembersInRecovery);
            RspList list = this.callRemoteMethods(m, "getAllReceivedUpTo", NULL_OBJ, NULL_TYPES, 2, 0L);
            Vector myAllReceivedUpTos = list.getResults();
            this.callRemoteMethods(m, "getAllReceivedUpTo", NULL_OBJ, NULL_TYPES, 2, 0L);
            Vector myAllReceivedUpTosConfirm = list.getResults();
            while (!myAllReceivedUpTos.equals(myAllReceivedUpTosConfirm)) {
                myAllReceivedUpTos = myAllReceivedUpTosConfirm;
                this.callRemoteMethods(m, "getAllReceivedUpTo", NULL_OBJ, NULL_TYPES, 2, 0L);
                myAllReceivedUpTosConfirm = list.getResults();
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("myAllReceivedUpto values are" + myAllReceivedUpTos));
                }
                if (!this.log.isInfoEnabled()) continue;
                this.log.info((Object)("myAllReceivedUpto confirm values are " + myAllReceivedUpTosConfirm));
            }
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("myAllReceivedUpto stabilized values are" + myAllReceivedUpTos));
            }
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"installing transitional view to repair the ring...");
            }
            this.callRemoteMethods(m, "installTransitionalView", new Object[]{m}, new String[]{Vector.class.getName()}, 2, 0L);
            Vector xmits = this.prepareRecoveryRetransmissionList(myAllReceivedUpTos);
            RingToken injectToken = null;
            if (xmits.size() > 1) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)"VS not satisfied, injecting recovery token...");
                }
                long aru = (Long)xmits.firstElement();
                long highest = (Long)xmits.lastElement();
                injectToken = new RingToken(1);
                injectToken.setHighestSequence(highest);
                injectToken.setAllReceivedUpto(aru);
                Collection rtr = injectToken.getRetransmissionRequests();
                rtr.addAll(xmits);
            } else {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)"VS satisfied, injecting operational token...");
                }
                injectToken = new RingToken();
                long sequence = (Long)xmits.firstElement();
                injectToken.setHighestSequence(sequence);
                injectToken.setAllReceivedUpto(sequence);
            }
            if (this.node != null) {
                this.node.passToken(injectToken);
            }
            this.tokenRetransmitter.resetTimeout();
        }
    }

    private Vector prepareRecoveryRetransmissionList(Vector sequences) {
        Collections.sort(sequences);
        Long first = (Long)sequences.firstElement();
        Long last = (Long)sequences.lastElement();
        Vector<Long> retransmissions = new Vector<Long>();
        if (first.equals(last)) {
            retransmissions.add(new Long(first));
        } else {
            for (long j = first + 1L; j <= last; ++j) {
                retransmissions.add(new Long(j));
            }
        }
        return retransmissions;
    }

    protected void updateView(View newMembers) {
        super.updateView(newMembers);
        Vector newViewMembers = newMembers.getMembers();
        this.flowControl.viewChanged(newViewMembers.size());
        if (this.node != null) {
            this.node.reconfigure(newViewMembers);
        }
        boolean isCoordinator = this.localAddress.equals(newViewMembers.firstElement());
        int memberSize = newViewMembers.size();
        if (memberSize == 1 && isCoordinator && !this.tokenCirculating) {
            this.tokenCirculating = true;
            RingToken token = new RingToken();
            if (this.node != null) {
                this.node.passToken(token);
            }
            this.tokenRetransmitter.resetTimeout();
        }
        this.sleepTime = 20 / memberSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void messageArrived(Message m) {
        TotalTokenHeader h = (TotalTokenHeader)m.getHeader(this.getName());
        long seq = h.getSeq();
        Object object = this.mutex;
        synchronized (object) {
            if (this.myAru + 1L <= seq) {
                if (seq > this.highestSeenSeq) {
                    this.highestSeenSeq = seq;
                }
                this.receivedMessagesQueue.put(new Long(seq), m);
                if (this.myAru + 1L == seq) {
                    this.myAru = seq;
                    this.passUp(new Event(1, m));
                }
                if (this.isReceiveQueueHolePlugged()) {
                    this.myAru = this.deliverMissingMessages();
                }
            }
        }
    }

    private boolean isReceiveQueueHolePlugged() {
        return this.myAru < this.highestSeenSeq && this.receivedMessagesQueue.containsKey(new Long(this.myAru + 1L));
    }

    private long deliverMissingMessages() {
        Map.Entry entry = null;
        boolean inOrder = true;
        long lastDelivered = this.myAru;
        Set deliverySet = this.receivedMessagesQueue.tailMap(new Long(this.myAru + 1L)).entrySet();
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("hole getting plugged, prior muAru " + this.myAru));
        }
        Iterator iterator = deliverySet.iterator();
        while (inOrder && iterator.hasNext()) {
            entry = iterator.next();
            long nextInQueue = entry.getKey();
            if (lastDelivered + 1L == nextInQueue) {
                Message m = (Message)entry.getValue();
                this.passUp(new Event(1, m));
                ++lastDelivered;
                continue;
            }
            inOrder = false;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("hole getting plugged, post muAru " + lastDelivered));
        }
        return lastDelivered;
    }

    private void updateTokenRtR(RingToken token) {
        long holeLowerBound = 0L;
        long holeUpperBound = 0L;
        Long missingSequence = null;
        Collection retransmissionList = null;
        if (this.myAru < token.getHighestSequence()) {
            retransmissionList = token.getRetransmissionRequests();
            Set<Long> received = this.receivedMessagesQueue.tailMap(new Long(this.myAru + 1L)).keySet();
            Iterator<Long> nonMissing = received.iterator();
            holeLowerBound = this.myAru;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("retransmission request prior" + retransmissionList));
            }
            while (nonMissing.hasNext()) {
                Long seq = nonMissing.next();
                holeUpperBound = seq;
                while (holeLowerBound < holeUpperBound) {
                    missingSequence = new Long(++holeLowerBound);
                    retransmissionList.add(missingSequence);
                }
                holeLowerBound = holeUpperBound;
            }
            holeUpperBound = token.getHighestSequence();
            while (holeLowerBound < holeUpperBound) {
                missingSequence = new Long(++holeLowerBound);
                retransmissionList.add(missingSequence);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("retransmission request after" + retransmissionList));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int broadcastMessages(int allowedCount, RingToken token) {
        ArrayList sendList = null;
        List list = this.newMessagesQueue;
        synchronized (list) {
            int queueSize = this.newMessagesQueue.size();
            if (queueSize <= 0) {
                return 0;
            }
            if (queueSize > allowedCount) {
                sendList = new ArrayList(this.newMessagesQueue.subList(0, allowedCount));
                this.newMessagesQueue.removeAll(sendList);
            } else {
                sendList = new ArrayList();
                sendList.addAll(this.newMessagesQueue);
                this.newMessagesQueue.clear();
            }
        }
        long tokenSeq = token.getHighestSequence();
        Iterator iterator = sendList.iterator();
        while (iterator.hasNext()) {
            Message m = (Message)iterator.next();
            m.setSrc(this.localAddress);
            m.setDest(null);
            m.putHeader(this.getName(), new TotalTokenHeader(++tokenSeq));
            this.receivedMessagesQueue.put(new Long(tokenSeq), m);
            this.passDown(new Event(1, m));
        }
        if (token.getHighestSequence() == token.getAllReceivedUpto()) {
            token.setAllReceivedUpto(tokenSeq);
        }
        token.setHighestSequence(tokenSeq);
        return sendList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tokenReceived(RingToken token) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)token.toString());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.getState());
        }
        this.flowControl.setBacklog(this.newMessagesQueue.size());
        this.flowControl.updateWindow(token);
        this.blockSenderIfRequired();
        this.unBlockSenderIfAcceptable();
        long tokensAru = 0L;
        int broadcastCount = 0;
        int rebroadcastCount = 0;
        Object object = this.mutex;
        synchronized (object) {
            if (!this.tokenSeen) {
                long lastRoundAru = token.getHighestSequence() - (long)token.getLastRoundBroadcastCount();
                if (this.myAru < token.getAllReceivedUpto()) {
                    this.myAru = lastRoundAru;
                }
                this.tokenSeen = true;
            }
            if (token.getType() == 1) {
                this.highestSeenSeq = token.getHighestSequence();
                if (this.highestSeenSeq == this.myAru) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)"member node recovered");
                    }
                    token.addRecoveredMember(this.localAddress);
                }
            }
            this.updateTokenRtR(token);
            int allowedToBroadcast = this.flowControl.getAllowedToBroadcast(token);
            rebroadcastCount = this.rebroadcastMessages(token);
            allowedToBroadcast -= rebroadcastCount;
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("myAllReceivedUpto" + this.myAru));
            }
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("allowedToBroadcast" + allowedToBroadcast));
            }
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("newMessagesQueue.size()" + this.newMessagesQueue.size()));
            }
            if (this.myAru < (tokensAru = token.getAllReceivedUpto()) || this.localAddress.equals(token.getAruId()) || token.getAruId() == null) {
                token.setAllReceivedUpto(this.myAru);
                if (token.getAllReceivedUpto() == token.getHighestSequence()) {
                    token.setAruId(null);
                } else {
                    token.setAruId(this.localAddress);
                }
            }
            if (allowedToBroadcast > 0 && token.getType() == 0) {
                broadcastCount = this.broadcastMessages(allowedToBroadcast, token);
            }
            if (tokensAru > this.lastRoundTokensAru) {
                this.removeStableMessages(this.receivedMessagesQueue, this.lastRoundTokensAru);
            }
        }
        Util.sleep(this.sleepTime);
        token.incrementTokenSequence();
        token.addLastRoundBroadcastCount(broadcastCount - this.lastRoundTransmitCount);
        token.addBacklog(this.flowControl.getBacklogDifference());
        this.flowControl.setPreviousBacklog();
        this.lastRoundTransmitCount = broadcastCount;
        this.lastRoundRebroadcastCount = rebroadcastCount;
        this.lastRoundTokensAru = tokensAru;
    }

    private int rebroadcastMessages(RingToken token) {
        Collection rbl;
        int rebroadCastCount = 0;
        Collection rexmitRequests = token.getRetransmissionRequests();
        if (rexmitRequests.size() > 0 && (rebroadCastCount = (rbl = this.getRebroadcastList(rexmitRequests)).size()) > 0) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("rebroadcasting " + rbl));
            }
            Long s = null;
            Iterator iterator = rbl.iterator();
            while (iterator.hasNext()) {
                s = (Long)iterator.next();
                Message m = (Message)this.receivedMessagesQueue.get(s);
                this.passDown(new Event(1, m));
            }
        }
        return rebroadCastCount;
    }

    private void invalidateOnTokenloss() {
        this.lastRoundTransmitCount = 0;
        this.flowControl.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockSenderIfRequired() {
        if (!this.senderBlocked && this.flowControl.getBacklog() > this.blockSendingBacklogThreshold) {
            Object object = this.block_sending;
            synchronized (object) {
                this.senderBlocked = true;
                while (this.senderBlocked) {
                    try {
                        this.block_sending.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unBlockSenderIfAcceptable() {
        if (this.senderBlocked && this.flowControl.getBacklog() < this.unblockSendingBacklogThreshold) {
            Object object = this.block_sending;
            synchronized (object) {
                this.senderBlocked = false;
                this.block_sending.notifyAll();
            }
        }
    }

    private void removeStableMessages(TreeMap m, long upToSeq) {
        if (m.size() > 0) {
            long first = (Long)m.firstKey();
            if (first > upToSeq) {
                upToSeq = first;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("cutting queue first key " + m.firstKey() + " cut at " + upToSeq + " last key " + m.lastKey()));
            }
            SortedMap stable = m.headMap(new Long(upToSeq));
            stable.clear();
        }
    }

    private Collection getRebroadcastList(Collection rtr) {
        ArrayList rebroadcastList = new ArrayList(rtr);
        rebroadcastList.retainAll(this.receivedMessagesQueue.keySet());
        rtr.removeAll(rebroadcastList);
        Collections.sort(rebroadcastList);
        return rebroadcastList;
    }

    private class TokenTransmitter
    extends Thread {
        long rtt;
        long timer;
        double srtt;
        final double a = 0.09;
        final int timeoutFactor = 10;
        volatile boolean running;

        private TokenTransmitter() {
            super(Util.getGlobalThreadGroup(), "TokenTransmitter");
            this.rtt = 0L;
            this.srtt = 1000.0;
            this.a = 0.09;
            this.timeoutFactor = 10;
            this.running = false;
            this.resetTimeout();
            this.running = true;
        }

        private void shutDown() {
            this.running = false;
        }

        private void recalculateTimeout() {
            long now = System.currentTimeMillis();
            if (this.timer > 0L) {
                this.rtt = now - this.timer;
                this.srtt = 0.91 * this.srtt + 0.09 * (double)this.rtt;
            }
        }

        private double getTimeout() {
            return this.srtt * 10.0;
        }

        private void resetTimeout() {
            this.timer = System.currentTimeMillis();
        }

        private boolean isRecoveryCompleted(RingToken token) {
            return TOTAL_TOKEN.this.liveMembersInRecovery.equals(token.getRecoveredMembers());
        }

        public void run() {
            while (this.running) {
                RingToken token = null;
                int timeout = 0;
                if (TOTAL_TOKEN.this.node == null) {
                    Util.sleep(500L);
                    continue;
                }
                try {
                    timeout = (int)this.getTimeout();
                    if (TOTAL_TOKEN.this.log.isInfoEnabled()) {
                        TOTAL_TOKEN.this.log.info((Object)("timeout(ms)=" + timeout));
                    }
                    if ((token = (RingToken)TOTAL_TOKEN.this.node.receiveToken(timeout)).getType() == 0 && TOTAL_TOKEN.this.state == 1) {
                        TOTAL_TOKEN.this.state = 0;
                    }
                    TOTAL_TOKEN.this.tokenReceived(token);
                    this.recalculateTimeout();
                    if (token.getType() == 1 && this.isRecoveryCompleted(token)) {
                        if (TOTAL_TOKEN.this.log.isInfoEnabled()) {
                            TOTAL_TOKEN.this.log.info((Object)"all members recovered, injecting operational token");
                        }
                        token.setType(0);
                    }
                    TOTAL_TOKEN.this.node.passToken(token);
                    this.resetTimeout();
                }
                catch (TokenLostException tle) {
                    TOTAL_TOKEN.this.invalidateOnTokenloss();
                    TOTAL_TOKEN.this.state = 1;
                    TOTAL_TOKEN.this.recover();
                }
            }
        }
    }

    public static class RingTokenHeader
    extends Header {
        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public long size() {
            return 110L;
        }
    }

    public static class TotalTokenHeader
    extends Header {
        private long seq;

        public TotalTokenHeader() {
        }

        public TotalTokenHeader(long seq) {
            this.seq = seq;
        }

        public TotalTokenHeader(Long seq) {
            this.seq = seq;
        }

        public long getSeq() {
            return this.seq;
        }

        public long size() {
            return 121L;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.seq);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.seq = in.readLong();
        }

        public String toString() {
            return "[TotalTokenHeader=" + this.seq + ']';
        }
    }
}

