/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.lang.reflect.Method;
import javax.ejb.EJBMetaData;
import javax.ejb.HomeHandle;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.metadata.MetaDataResolver;
import org.jboss.aop.util.MethodHashing;
import org.jboss.aop.util.PayloadKey;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.ProxyUtils;
import org.jboss.ejb3.session.BaseSessionRemoteProxy;
import org.jboss.ejb3.stateful.StatefulHandleImpl;
import org.jboss.ejb3.stateful.StatefulRemoteInvocation;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;

public class StatefulHomeRemoteProxy
extends BaseSessionRemoteProxy {
    private static final long serialVersionUID = 5509794838403316545L;
    private static final Logger log = Logger.getLogger(StatefulHomeRemoteProxy.class);
    protected InvokerLocator uri;
    private HomeHandle homeHandle;
    private EJBMetaData ejbMetaData;

    public StatefulHomeRemoteProxy(Container container, Interceptor[] interceptors, InvokerLocator uri) {
        super(container, interceptors);
        this.uri = uri;
    }

    public StatefulHomeRemoteProxy(Container container, Interceptor[] interceptors, InvokerLocator uri, Object id) {
        super(container, interceptors);
        this.uri = uri;
        this.id = id;
    }

    protected StatefulHomeRemoteProxy() {
    }

    public void setHandle(StatefulHandleImpl handle) {
        this.handle = handle;
        handle.id = this.id;
    }

    public void setHomeHandle(HomeHandle homeHandle) {
        this.homeHandle = homeHandle;
    }

    public void setEjbMetaData(EJBMetaData ejbMetaData) {
        this.ejbMetaData = ejbMetaData;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        long hash = MethodHashing.calculateHash((Method)method);
        Object ret = ProxyUtils.handleCallLocally(hash, proxy, this, method, args);
        if (ret != null) {
            return ret;
        }
        ret = this.handleEjb21CallLocally(method, args);
        if (ret != null) {
            return ret;
        }
        StatefulRemoteInvocation sri = new StatefulRemoteInvocation(this.interceptors, hash, method, method, null, null);
        sri.setArguments(args);
        sri.setInstanceResolver((MetaDataResolver)this.metadata);
        sri.getMetaData().addMetaData((Object)"DISPATCHER", (Object)"OID", (Object)this.containerId, PayloadKey.AS_IS);
        sri.getMetaData().addMetaData((Object)"REMOTING", (Object)"INVOKER_LOCATOR", (Object)this.uri, PayloadKey.AS_IS);
        sri.getMetaData().addMetaData((Object)"REMOTING", (Object)"SUBSYSTEM", (Object)"AOP", PayloadKey.AS_IS);
        sri.getMetaData().addMetaData((Object)"IS_LOCAL", (Object)"GUID", (Object)this.containerGuid, PayloadKey.AS_IS);
        return sri.invokeNext();
    }

    public Object getAsynchronousProxy(Object proxy) {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    public String toString() {
        return this.containerId.toString() + ":Home";
    }

    private Object handleEjb21CallLocally(Method method, Object[] args) {
        if (method.equals(ProxyUtils.GET_HOME_HANDLE)) {
            return this.homeHandle;
        }
        if (method.equals(ProxyUtils.GET_EJB_METADATA)) {
            return this.ejbMetaData;
        }
        return null;
    }
}

