/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.Serializable;
import java.util.Properties;
import javax.jms.JMSException;
import org.jboss.logging.Logger;
import org.jboss.mq.Connection;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.il.ClientILService;
import org.jboss.mq.il.ServerIL;
import org.jboss.mq.il.ServerILFactory;

public class GenericConnectionFactory
implements Serializable {
    private static final long serialVersionUID = 2288420610006129296L;
    static Logger log = Logger.getLogger((Class)GenericConnectionFactory.class);
    private ServerIL server;
    private Properties connectionProperties;

    public GenericConnectionFactory(ServerIL server, Properties props) {
        this.server = server;
        this.connectionProperties = props;
    }

    public Properties getProperties() {
        return this.connectionProperties;
    }

    public void initialise(Connection connection) throws JMSException {
        String clientID = this.connectionProperties.getProperty("ClientID");
        if (clientID != null) {
            connection.clientID = clientID;
        }
    }

    public ClientILService createClientILService(Connection connection) throws Exception {
        String pingPeriod = this.connectionProperties.getProperty("PingPeriod", "" + connection.pingPeriod);
        connection.pingPeriod = Long.parseLong(pingPeriod);
        String clientILServiceCN = this.connectionProperties.getProperty("ClientILService");
        ClientILService service = (ClientILService)Class.forName(clientILServiceCN).newInstance();
        service.init(connection, this.connectionProperties);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Handing out ClientIL: " + clientILServiceCN));
        }
        return service;
    }

    public ServerIL createServerIL() throws JMSException {
        try {
            if (this.server == null) {
                String className = this.connectionProperties.getProperty("ServerILFactory");
                ServerILFactory factory = (ServerILFactory)Class.forName(className).newInstance();
                factory.init(this.connectionProperties);
                this.server = factory.getServerIL();
            }
            return this.server.cloneServerIL();
        }
        catch (Exception e) {
            throw new SpyJMSException("Could not connect to the server", e);
        }
    }

    public String toString() {
        return "GenericConnectionFactory[server=" + this.server + " connectionProperties=" + this.connectionProperties + "]";
    }
}

