/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import org.jboss.mq.MessagePool;
import org.jboss.mq.SpyMessage;
import org.jboss.util.Primitives;

public class SpyMapMessage
extends SpyMessage
implements MapMessage,
Externalizable {
    private static final long serialVersionUID = -4917633165373197269L;
    HashMap content = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBoolean(String name, boolean value) throws JMSException {
        this.checkName(name);
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("Message is ReadOnly !");
        }
        HashMap hashMap = this.content;
        synchronized (hashMap) {
            this.content.put(name, Primitives.valueOf((boolean)value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setByte(String name, byte value) throws JMSException {
        this.checkName(name);
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("Message is ReadOnly !");
        }
        HashMap hashMap = this.content;
        synchronized (hashMap) {
            this.content.put(name, new Byte(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShort(String name, short value) throws JMSException {
        this.checkName(name);
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("Message is ReadOnly !");
        }
        HashMap hashMap = this.content;
        synchronized (hashMap) {
            this.content.put(name, new Short(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChar(String name, char value) throws JMSException {
        this.checkName(name);
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("Message is ReadOnly !");
        }
        HashMap hashMap = this.content;
        synchronized (hashMap) {
            this.content.put(name, new Character(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInt(String name, int value) throws JMSException {
        this.checkName(name);
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("Message is ReadOnly !");
        }
        HashMap hashMap = this.content;
        synchronized (hashMap) {
            this.content.put(name, new Integer(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLong(String name, long value) throws JMSException {
        this.checkName(name);
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("Message is ReadOnly !");
        }
        HashMap hashMap = this.content;
        synchronized (hashMap) {
            this.content.put(name, new Long(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFloat(String name, float value) throws JMSException {
        this.checkName(name);
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("Message is ReadOnly !");
        }
        HashMap hashMap = this.content;
        synchronized (hashMap) {
            this.content.put(name, new Float(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDouble(String name, double value) throws JMSException {
        this.checkName(name);
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("Message is ReadOnly !");
        }
        HashMap hashMap = this.content;
        synchronized (hashMap) {
            this.content.put(name, new Double(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(String name, String value) throws JMSException {
        this.checkName(name);
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("Message is ReadOnly !");
        }
        HashMap hashMap = this.content;
        synchronized (hashMap) {
            this.content.put(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytes(String name, byte[] value) throws JMSException {
        this.checkName(name);
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("Message is ReadOnly !");
        }
        HashMap hashMap = this.content;
        synchronized (hashMap) {
            this.content.put(name, value.clone());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        this.checkName(name);
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("Message is ReadOnly !");
        }
        if (offset + length > value.length) {
            throw new JMSException("Array is too small");
        }
        byte[] temp = new byte[length];
        for (int i = 0; i < length; ++i) {
            temp[i] = value[i + offset];
        }
        HashMap hashMap = this.content;
        synchronized (hashMap) {
            this.content.put(name, temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(String name, Object value) throws JMSException {
        this.checkName(name);
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("Message is ReadOnly !");
        }
        HashMap hashMap = this.content;
        synchronized (hashMap) {
            if (value instanceof Boolean) {
                this.content.put(name, value);
            } else if (value instanceof Byte) {
                this.content.put(name, value);
            } else if (value instanceof Short) {
                this.content.put(name, value);
            } else if (value instanceof Character) {
                this.content.put(name, value);
            } else if (value instanceof Integer) {
                this.content.put(name, value);
            } else if (value instanceof Long) {
                this.content.put(name, value);
            } else if (value instanceof Float) {
                this.content.put(name, value);
            } else if (value instanceof Double) {
                this.content.put(name, value);
            } else if (value instanceof String) {
                this.content.put(name, value);
            } else if (value instanceof byte[]) {
                this.content.put(name, ((byte[])value).clone());
            } else {
                throw new MessageFormatException("Invalid object type.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String name) throws JMSException {
        Object value;
        HashMap hashMap = this.content;
        synchronized (hashMap) {
            value = this.content.get(name);
        }
        if (value == null) {
            return Boolean.valueOf(null);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByte(String name) throws JMSException {
        Object value;
        HashMap hashMap = this.content;
        synchronized (hashMap) {
            value = this.content.get(name);
        }
        if (value == null) {
            return Byte.parseByte(null);
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String) {
            return Byte.parseByte((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(String name) throws JMSException {
        Object value;
        HashMap hashMap = this.content;
        synchronized (hashMap) {
            value = this.content.get(name);
        }
        if (value == null) {
            return Short.parseShort(null);
        }
        if (value instanceof Byte) {
            return ((Byte)value).shortValue();
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof String) {
            return Short.parseShort((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char getChar(String name) throws JMSException {
        Object value;
        HashMap hashMap = this.content;
        synchronized (hashMap) {
            value = this.content.get(name);
        }
        if (value == null) {
            throw new NullPointerException("Invalid conversion");
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        throw new MessageFormatException("Invalid conversion");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(String name) throws JMSException {
        Object value;
        HashMap hashMap = this.content;
        synchronized (hashMap) {
            value = this.content.get(name);
        }
        if (value == null) {
            return Integer.parseInt(null);
        }
        if (value instanceof Byte) {
            return ((Byte)value).intValue();
        }
        if (value instanceof Short) {
            return ((Short)value).intValue();
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(String name) throws JMSException {
        Object value;
        HashMap hashMap = this.content;
        synchronized (hashMap) {
            value = this.content.get(name);
        }
        if (value == null) {
            return Long.parseLong(null);
        }
        if (value instanceof Byte) {
            return ((Byte)value).longValue();
        }
        if (value instanceof Short) {
            return ((Short)value).longValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(String name) throws JMSException {
        Object value;
        HashMap hashMap = this.content;
        synchronized (hashMap) {
            value = this.content.get(name);
        }
        if (value == null) {
            return Float.parseFloat(null);
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof String) {
            return Float.parseFloat((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(String name) throws JMSException {
        Object value;
        HashMap hashMap = this.content;
        synchronized (hashMap) {
            value = this.content.get(name);
        }
        if (value == null) {
            return Double.parseDouble(null);
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String name) throws JMSException {
        Object value;
        HashMap hashMap = this.content;
        synchronized (hashMap) {
            value = this.content.get(name);
        }
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return ((Boolean)value).toString();
        }
        if (value instanceof Byte) {
            return ((Byte)value).toString();
        }
        if (value instanceof Short) {
            return ((Short)value).toString();
        }
        if (value instanceof Character) {
            return ((Character)value).toString();
        }
        if (value instanceof Integer) {
            return ((Integer)value).toString();
        }
        if (value instanceof Long) {
            return ((Long)value).toString();
        }
        if (value instanceof Float) {
            return ((Float)value).toString();
        }
        if (value instanceof Double) {
            return ((Double)value).toString();
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw new MessageFormatException("Invalid conversion");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(String name) throws JMSException {
        Object value;
        HashMap hashMap = this.content;
        synchronized (hashMap) {
            value = this.content.get(name);
        }
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        throw new MessageFormatException("Invalid conversion");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(String name) throws JMSException {
        HashMap hashMap = this.content;
        synchronized (hashMap) {
            return this.content.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getMapNames() throws JMSException {
        HashMap hashMap = this.content;
        synchronized (hashMap) {
            return Collections.enumeration(new HashMap(this.content).keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean itemExists(String name) throws JMSException {
        HashMap hashMap = this.content;
        synchronized (hashMap) {
            return this.content.containsKey(name);
        }
    }

    public void clearBody() throws JMSException {
        this.content = new HashMap();
        super.clearBody();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpyMessage myClone() throws JMSException {
        SpyMapMessage result = MessagePool.getMapMessage();
        result.copyProps(this);
        HashMap hashMap = this.content;
        synchronized (hashMap) {
            result.content = (HashMap)this.content.clone();
        }
        return result;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.content);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        Object object = in.readObject();
        if (object instanceof Hashtable) {
            Hashtable ht = (Hashtable)object;
            this.content = new HashMap(ht.size());
            this.content.putAll(ht);
        } else {
            this.content = (HashMap)object;
        }
    }

    private void checkName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null.");
        }
        if (name.equals("")) {
            throw new IllegalArgumentException("Name must not be an empty String.");
        }
    }
}

