/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.common.jbossas.JBossASDiscoveryUtils;
import org.jetbrains.annotations.Nullable;
import org.mc4j.ems.connection.support.metadata.InternalVMTypeDescriptor;
import org.mc4j.ems.connection.support.metadata.JBossConnectionTypeDescriptor;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ManualAddFacet;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.pluginapi.util.FileUtils;
import org.rhq.core.system.ProcessInfo;
import org.rhq.plugins.jbossas.JBossASServerComponent;
import org.rhq.plugins.jbossas.helper.JBossInstallationInfo;
import org.rhq.plugins.jbossas.helper.JBossInstanceInfo;
import org.rhq.plugins.jbossas.helper.JBossProductType;
import org.rhq.plugins.jbossas.util.JBossMBeanUtility;
import org.rhq.plugins.jbossas.util.JnpConfig;

public class JBossASDiscoveryComponent
implements ResourceDiscoveryComponent,
ManualAddFacet {
    private final Log log = LogFactory.getLog(JBossASDiscoveryComponent.class);
    private static final String JBOSS_SERVICE_XML = "conf" + File.separator + "jboss-service.xml";
    private static final String JBOSS_NAMING_SERVICE_XML = "deploy" + File.separator + "naming-service.xml";
    private static final String JAVA_HOME_ENV_VAR = "JAVA_HOME";
    private static final String ANY_ADDRESS = "0.0.0.0";
    private static final String LOCALHOST = "127.0.0.1";
    private static final String CHANGE_ME = "***CHANGE_ME***";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext context) {
        this.log.debug((Object)"Discovering JBoss AS 3.2.x and 4.x servers...");
        HashSet<DiscoveredResourceDetails> resources = new HashSet<DiscoveredResourceDetails>();
        DiscoveredResourceDetails jbossPcIsEmbeddedIn = this.discoverJBossPcIsEmbeddedIn(context);
        if (jbossPcIsEmbeddedIn != null) {
            resources.add(jbossPcIsEmbeddedIn);
        }
        this.processAutoDiscoveredProcesses(context, resources, jbossPcIsEmbeddedIn);
        return resources;
    }

    public DiscoveredResourceDetails discoverResource(Configuration pluginConfiguration, ResourceDiscoveryContext discoveryContext) throws InvalidPluginConfigurationException {
        JBossInstallationInfo installInfo;
        pluginConfiguration.put((Property)new PropertySimple("type", (Object)JBossConnectionTypeDescriptor.class.getName()));
        this.setPluginConfigurationDefaults(pluginConfiguration);
        ProcessInfo processInfo = null;
        String jbossHomeDir = pluginConfiguration.getSimpleValue("jbossHomeDir", null);
        try {
            installInfo = new JBossInstallationInfo(new File(jbossHomeDir));
        }
        catch (IOException e) {
            throw new InvalidPluginConfigurationException((Throwable)e);
        }
        String version = installInfo.getVersion();
        if (version.startsWith("5") || version.startsWith("6")) {
            throw new InvalidPluginConfigurationException("The specified server is JBoss AS 5.0 or later - only AS 3.2 or 4.x are valid for this Resource type.");
        }
        DiscoveredResourceDetails resourceDetails = this.createResourceDetails(discoveryContext, pluginConfiguration, processInfo, installInfo);
        return resourceDetails;
    }

    private void processAutoDiscoveredProcesses(ResourceDiscoveryContext context, Set<DiscoveredResourceDetails> resources, DiscoveredResourceDetails jbossPcIsEmbeddedIn) {
        List autoDiscoveryResults = context.getAutoDiscoveredProcesses();
        for (ProcessScanResult autoDiscoveryResult : autoDiscoveryResults) {
            String javaHome;
            File configDir;
            File installHome;
            JBossInstallationInfo installInfo;
            JBossInstanceInfo cmdLine;
            ProcessInfo processInfo;
            block10: {
                processInfo = autoDiscoveryResult.getProcessInfo();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Discovered JBoss AS process: " + processInfo));
                }
                try {
                    cmdLine = new JBossInstanceInfo(processInfo);
                }
                catch (Exception e) {
                    this.log.error((Object)("Failed to process JBoss AS command line: " + Arrays.asList(processInfo.getCommandLine())), (Throwable)e);
                    continue;
                }
                installInfo = cmdLine.getInstallInfo();
                String version = installInfo.getVersion();
                if (version.startsWith("5") || version.startsWith("6")) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)"Found JBoss AS 5.0 or later, which is not supported by this plugin - skipping...");
                    continue;
                }
                installHome = new File(cmdLine.getSystemProperties().getProperty("jboss.home.dir"));
                configDir = new File(cmdLine.getSystemProperties().getProperty("jboss.server.home.dir"));
                if (jbossPcIsEmbeddedIn != null && jbossPcIsEmbeddedIn.getPluginConfiguration().getSimple("configurationPath").getStringValue().equals(configDir.getAbsolutePath())) continue;
                try {
                    if (!configDir.getCanonicalFile().isDirectory()) {
                        this.log.warn((Object)("Skipping discovery for JBoss AS process " + processInfo + ", because configuration dir '" + configDir + "' does not exist or is not a directory."));
                    }
                    break block10;
                }
                catch (IOException e) {
                    this.log.error((Object)("Skipping discovery for JBoss AS process " + processInfo + ", because configuration dir '" + configDir + "' could not be canonicalized."), (Throwable)e);
                }
                continue;
            }
            Configuration pluginConfiguration = context.getDefaultPluginConfiguration();
            String jnpURL = JBossASDiscoveryComponent.getJnpURL(cmdLine, installHome, configDir);
            pluginConfiguration.put((Property)new PropertySimple("type", (Object)JBossConnectionTypeDescriptor.class.getName()));
            pluginConfiguration.put((Property)new PropertySimple("namingURL", (Object)jnpURL));
            pluginConfiguration.put((Property)new PropertySimple("jbossHomeDir", (Object)installHome.getAbsolutePath()));
            pluginConfiguration.put((Property)new PropertySimple("configurationPath", (Object)configDir));
            pluginConfiguration.put((Property)new PropertySimple("configurationSet", (Object)cmdLine.getSystemProperties().getProperty("jboss.server.name")));
            pluginConfiguration.put((Property)new PropertySimple("bindingAddress", (Object)cmdLine.getSystemProperties().getProperty("jboss.bind.address")));
            JBossASDiscoveryUtils.UserInfo userInfo = JBossASDiscoveryUtils.getJmxInvokerUserInfo((File)configDir);
            if (userInfo != null) {
                pluginConfiguration.put((Property)new PropertySimple("principal", (Object)userInfo.getUsername()));
                pluginConfiguration.put((Property)new PropertySimple("credentials", (Object)userInfo.getPassword()));
            }
            if ((javaHome = processInfo.getEnvironmentVariable(JAVA_HOME_ENV_VAR)) == null && this.log.isDebugEnabled()) {
                this.log.debug((Object)"JAVA_HOME environment variable not set in JBoss AS process - defaulting javaHomePath connection property to the plugin container JRE dir.");
            }
            pluginConfiguration.put((Property)new PropertySimple("javaHomePath", (Object)javaHome));
            this.initLogEventSourcesConfigProp(configDir, pluginConfiguration);
            this.setPluginConfigurationDefaults(pluginConfiguration);
            DiscoveredResourceDetails resourceDetails = this.createResourceDetails(context, pluginConfiguration, processInfo, installInfo);
            resources.add(resourceDetails);
        }
    }

    private void initLogEventSourcesConfigProp(File configDir, Configuration pluginConfiguration) {
        File logDir = new File(configDir, "log");
        File serverLogFile = new File(logDir, "server.log");
        if (serverLogFile.exists() && !serverLogFile.isDirectory()) {
            PropertyMap serverLogEventSource = new PropertyMap("logEventSource");
            serverLogEventSource.put((Property)new PropertySimple("logFilePath", (Object)serverLogFile));
            serverLogEventSource.put((Property)new PropertySimple("enabled", (Object)Boolean.FALSE));
            PropertyList logEventSources = pluginConfiguration.getList("logEventSources");
            logEventSources.add((Property)serverLogEventSource);
        }
    }

    private static JnpConfig getJnpConfig(File installHome, File configDir, Properties props) {
        File namingServiceFile;
        File serviceXML = new File(configDir, JBOSS_SERVICE_XML);
        JnpConfig config = JnpConfig.getConfig(serviceXML, props);
        if ((config == null || config.getJnpPort() == null) && (namingServiceFile = new File(configDir, JBOSS_NAMING_SERVICE_XML)).exists()) {
            config = JnpConfig.getConfig(namingServiceFile, props);
        }
        return config;
    }

    private void setPluginConfigurationDefaults(Configuration pluginConfiguration) {
        this.setPropertySimpleIfNotAlreadySet(pluginConfiguration, "startScript", JBossASServerComponent.DEFAULT_START_SCRIPT);
        this.setPropertySimpleIfNotAlreadySet(pluginConfiguration, "shutdownScript", JBossASServerComponent.DEFAULT_SHUTDOWN_SCRIPT);
        this.setPropertySimpleIfNotAlreadySet(pluginConfiguration, "javaHomePath", JBossASServerComponent.DEFAULT_JAVA_HOME);
        this.setPropertySimpleIfNotAlreadySet(pluginConfiguration, "bindingAddress", LOCALHOST);
    }

    private void setPropertySimpleIfNotAlreadySet(Configuration pluginConfiguration, String propName, String propValue) {
        PropertySimple prop = pluginConfiguration.getSimple(propName);
        if (prop == null || prop.getStringValue() == null) {
            pluginConfiguration.put((Property)new PropertySimple(propName, (Object)propValue));
        }
    }

    private DiscoveredResourceDetails createResourceDetails(ResourceDiscoveryContext discoveryContext, Configuration pluginConfiguration, @Nullable ProcessInfo processInfo, JBossInstallationInfo installInfo) {
        String port;
        String configPath = pluginConfiguration.getSimple("configurationPath").getStringValue();
        File absoluteConfigPath = JBossASServerComponent.resolvePathRelativeToHomeDir(pluginConfiguration, configPath);
        String key = FileUtils.getCanonicalPath((String)absoluteConfigPath.getPath());
        String bindingAddress = pluginConfiguration.getSimple("bindingAddress").getStringValue();
        String namingUrl = pluginConfiguration.getSimple("namingURL").getStringValue();
        String namingPort = null;
        int colonIndex = namingUrl.lastIndexOf(58);
        if (colonIndex != -1 && colonIndex != namingUrl.length() - 1 && !(port = namingUrl.substring(colonIndex + 1)).equals(CHANGE_ME)) {
            namingPort = port;
        }
        JBossProductType productType = installInfo.getProductType();
        String description = productType.DESCRIPTION + " " + installInfo.getMajorVersion();
        boolean isRhqServer = this.isRhqServer(absoluteConfigPath);
        if (isRhqServer) {
            description = description + " hosting the RHQ Server";
            File rhqLogFile = JBossASServerComponent.resolvePathRelativeToHomeDir(pluginConfiguration, "../logs/rhq-server-log4j.log");
            if (rhqLogFile.exists() && !rhqLogFile.isDirectory()) {
                try {
                    PropertyMap serverLogEventSource = new PropertyMap("logEventSource");
                    serverLogEventSource.put((Property)new PropertySimple("logFilePath", (Object)rhqLogFile.getCanonicalPath()));
                    serverLogEventSource.put((Property)new PropertySimple("enabled", (Object)Boolean.FALSE));
                    serverLogEventSource.put((Property)new PropertySimple("minimumSeverity", (Object)EventSeverity.INFO.name().toLowerCase()));
                    PropertyList logEventSources = pluginConfiguration.getList("logEventSources");
                    logEventSources.add((Property)serverLogEventSource);
                }
                catch (IOException e) {
                    this.log.warn((Object)"Unable to setup RHQ Server log file monitoring.", (Throwable)e);
                }
            }
        }
        String name = this.formatServerName(bindingAddress, namingPort, discoveryContext.getSystemInformation().getHostname(), absoluteConfigPath.getName(), productType, isRhqServer);
        String version = productType.name() + " " + installInfo.getVersion();
        return new DiscoveredResourceDetails(discoveryContext.getResourceType(), key, name, version, description, pluginConfiguration, processInfo);
    }

    private boolean isRhqServer(File absoluteConfigPath) {
        File deployDir = new File(absoluteConfigPath, "deploy");
        File rhqInstallerWar = new File(deployDir, "rhq-installer.war");
        File rhqInstallerWarUndeployed = new File(deployDir, "rhq-installer.war.rej");
        boolean isInServer = rhqInstallerWar.exists() || rhqInstallerWarUndeployed.exists();
        return isInServer;
    }

    @Nullable
    private DiscoveredResourceDetails discoverJBossPcIsEmbeddedIn(ResourceDiscoveryContext context) {
        block7: {
            MBeanServer server = JBossMBeanUtility.getJBossMBeanServer();
            try {
                JBossInstallationInfo installInfo;
                ObjectName configObjectName;
                Set<ObjectName> set;
                String jnpAddress = null;
                String jnpPort = null;
                ObjectName namingObjectName = new ObjectName("jboss:service=Naming");
                Set<ObjectName> namingSet = server.queryNames(namingObjectName, null);
                if (namingSet.iterator().hasNext()) {
                    jnpAddress = (String)server.getAttribute(namingObjectName, "BindAddress");
                    jnpPort = String.valueOf(server.getAttribute(namingObjectName, "Port"));
                }
                String bindAddress = null;
                ObjectName systemPropertiesObjectName = new ObjectName("jboss:name=SystemProperties,type=Service");
                Set<ObjectName> systemPropertiesSet = server.queryNames(systemPropertiesObjectName, null);
                if (systemPropertiesSet.iterator().hasNext()) {
                    bindAddress = (String)server.invoke(systemPropertiesObjectName, "get", new Object[]{"jboss.bind.address"}, new String[]{String.class.getName()});
                }
                if (bindAddress == null) {
                    bindAddress = jnpAddress;
                }
                if (!(set = server.queryNames(configObjectName = new ObjectName("jboss.system:type=ServerConfig"), null)).iterator().hasNext()) break block7;
                File homeDir = (File)server.getAttribute(configObjectName, "HomeDir");
                try {
                    installInfo = new JBossInstallationInfo(homeDir);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to determine installation info for JBoss home dir [" + homeDir + "].", e);
                }
                File configDir = (File)server.getAttribute(configObjectName, "ServerHomeDir");
                String configName = (String)server.getAttribute(configObjectName, "ServerName");
                String version = (String)server.getAttribute(configObjectName, "SpecificationVersion");
                Configuration pluginConfiguration = context.getDefaultPluginConfiguration();
                pluginConfiguration.put((Property)new PropertySimple("type", (Object)InternalVMTypeDescriptor.class.getName()));
                pluginConfiguration.put((Property)new PropertySimple("jbossHomeDir", (Object)homeDir));
                pluginConfiguration.put((Property)new PropertySimple("configurationPath", (Object)configDir));
                pluginConfiguration.put((Property)new PropertySimple("configurationSet", (Object)configName));
                this.setPluginConfigurationDefaults(pluginConfiguration);
                JBossProductType productType = installInfo.getProductType();
                String name = this.formatServerName(bindAddress, jnpPort, context.getSystemInformation().getHostname(), configName, productType, this.isRhqServer(configDir));
                String description = productType.NAME + " server that the RHQ Plugin Container is running within";
                DiscoveredResourceDetails resource = new DiscoveredResourceDetails(context.getResourceType(), configDir.getAbsolutePath(), name, version, description, pluginConfiguration, null);
                return resource;
            }
            catch (Exception e) {
                this.log.debug((Object)"Not detected to be embedded in a JBoss AS Server", (Throwable)e);
            }
        }
        return null;
    }

    public String formatServerName(String bindingAddress, String jnpPort, String hostname, String configurationName, JBossProductType productType, boolean isRhq) {
        String bindingHostname;
        StringBuilder serverName = new StringBuilder();
        if (!isRhq) {
            serverName.append(productType.name()).append(' ');
        }
        if ((bindingHostname = this.getBindingHostname(bindingAddress)) != null) {
            serverName.append(bindingHostname);
        } else {
            serverName.append(hostname);
        }
        if (jnpPort != null && !jnpPort.equals(CHANGE_ME)) {
            serverName.append(':').append(jnpPort);
        }
        serverName.append(' ');
        if (isRhq) {
            serverName.append("RHQ Server");
        } else {
            serverName.append(configurationName);
        }
        return serverName.toString();
    }

    private String getBindingHostname(String bindingAddress) {
        String bindingHostname = null;
        if (bindingAddress != null) {
            try {
                InetAddress bindAddr = InetAddress.getByName(bindingAddress);
                if (!bindAddr.isAnyLocalAddress()) {
                    bindingHostname = bindAddr.getHostName();
                }
            }
            catch (UnknownHostException e) {
                this.log.warn((Object)("Unknown hostname passed in as the binding address for JBoss AS instance: " + bindingAddress));
            }
        }
        return bindingHostname;
    }

    private static String getJnpURL(JBossInstanceInfo cmdLine, File installHome, File configDir) {
        String jnpAddress;
        JnpConfig jnpConfig = JBossASDiscoveryComponent.getJnpConfig(installHome, configDir, cmdLine.getSystemProperties());
        String string = jnpAddress = jnpConfig.getJnpAddress() != null ? jnpConfig.getJnpAddress() : CHANGE_ME;
        if (jnpAddress.equals(ANY_ADDRESS)) {
            jnpAddress = LOCALHOST;
        }
        String jnpPort = jnpConfig.getJnpPort() != null ? String.valueOf(jnpConfig.getJnpPort()) : CHANGE_ME;
        return "jnp://" + jnpAddress + ":" + jnpPort;
    }
}

