/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.Stack;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.content.PackageDetails;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.pluginapi.util.FileUtils;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.ZipUtil;
import org.rhq.core.util.file.FileUtil;

public class FileContentDelegate {
    private static final String RHQ_SHA_256 = "RHQ-Sha256";
    private static final String MANIFEST_RELATIVE_PATH = "META-INF/MANIFEST.MF";
    private Log log = LogFactory.getLog(FileContentDelegate.class);
    protected File directory;
    private String fileEnding;
    private String packageTypeName;

    public FileContentDelegate(File directory, String fileEnding, String packageTypeName) {
        this.directory = directory;
        this.fileEnding = fileEnding;
        this.packageTypeName = packageTypeName;
    }

    public String getFileEnding() {
        return this.fileEnding;
    }

    public String getPackageTypeName() {
        return this.packageTypeName;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void createContent(PackageDetails details, File sourceContentFile, boolean unzip, boolean createBackup) {
        File destinationContentFile = this.getPath(details);
        try {
            if (createBackup) {
                this.moveToBackup(destinationContentFile, ".bak");
            }
            if (unzip) {
                ZipUtil.unzipFile((File)sourceContentFile, (File)destinationContentFile);
                String shaString = new MessageDigestGenerator("SHA-256").calcDigestString(sourceContentFile);
                this.writeSHAToManifest(destinationContentFile, shaString);
            } else {
                FileUtil.copyFile((File)sourceContentFile, (File)destinationContentFile);
            }
            details.setFileName(destinationContentFile.getPath());
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating artifact from details: " + destinationContentFile, e);
        }
    }

    @Deprecated
    public void createContent(PackageDetails details, InputStream content, boolean unzip, boolean createBackup) {
        File destinationContentFile = this.getPath(details);
        try {
            if (createBackup) {
                this.moveToBackup(destinationContentFile, ".bak");
            }
            if (unzip) {
                ZipUtil.unzipFile((InputStream)content, (File)destinationContentFile);
                this.computeAndSaveSHA(destinationContentFile);
            } else {
                FileUtil.writeFile((InputStream)content, (File)destinationContentFile);
            }
            details.setFileName(destinationContentFile.getPath());
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating artifact from details: " + destinationContentFile, e);
        }
    }

    private void moveToBackup(File contentFile, String suffix) {
        File backupFile = new File(contentFile.getAbsolutePath() + suffix);
        if (backupFile.exists() && !backupFile.delete()) {
            this.log.warn((Object)("Removing of old backup file " + backupFile + " failed "));
        }
        if (!contentFile.renameTo(backupFile)) {
            this.log.warn((Object)("Moving " + contentFile + " to backup " + backupFile + " failed"));
        }
    }

    public File getPath(PackageDetails details) {
        PackageDetailsKey key = details.getKey();
        String fileName = key.getName();
        int lastPathStart = fileName.lastIndexOf(File.separatorChar);
        if (lastPathStart > -1) {
            fileName = fileName.substring(lastPathStart + 1);
        }
        if (!fileName.endsWith(this.fileEnding)) {
            fileName = fileName + this.fileEnding;
        }
        return new File(this.directory, fileName);
    }

    public InputStream getContent(PackageDetails details) {
        File contentFile = this.getPath(details);
        try {
            return new BufferedInputStream(new FileInputStream(contentFile));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Package content not found for package " + contentFile, e);
        }
    }

    public void deleteContent(PackageDetails details) {
        File contentFile = this.getPath(details);
        if (!contentFile.exists()) {
            return;
        }
        try {
            FileUtils.purge((File)contentFile, (boolean)true);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to delete underlying file [" + contentFile + "] for " + details + ".", e);
        }
    }

    public Set<ResourcePackageDetails> discoverDeployedPackages() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSHA(File deploymentFile) {
        String sha;
        block9: {
            sha = null;
            try {
                if (deploymentFile.isDirectory()) {
                    File manifestFile = new File(deploymentFile.getAbsolutePath(), MANIFEST_RELATIVE_PATH);
                    if (manifestFile.exists()) {
                        FileInputStream manifestStream = new FileInputStream(manifestFile);
                        Manifest manifest = null;
                        try {
                            manifest = new Manifest(manifestStream);
                            sha = manifest.getMainAttributes().getValue(RHQ_SHA_256);
                        }
                        finally {
                            ((InputStream)manifestStream).close();
                        }
                    }
                    if (sha == null || sha.trim().isEmpty()) {
                        sha = this.computeAndSaveSHA(deploymentFile);
                    }
                    break block9;
                }
                sha = new MessageDigestGenerator("SHA-256").calcDigestString(deploymentFile);
            }
            catch (IOException ex) {
                throw new RuntimeException("Problem calculating digest of package [" + deploymentFile.getPath() + "].", ex);
            }
        }
        return sha;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String computeAndSaveSHA(File deploymentDirectory) {
        String sha = null;
        try {
            if (deploymentDirectory.isDirectory()) {
                MessageDigestGenerator messageDigest = new MessageDigestGenerator("SHA-256");
                Stack<File> unvisitedFolders = new Stack<File>();
                unvisitedFolders.add(deploymentDirectory);
                while (!unvisitedFolders.empty()) {
                    File[] files = ((File)unvisitedFolders.pop()).listFiles();
                    Arrays.sort(files, new Comparator<File>(){

                        @Override
                        public int compare(File f1, File f2) {
                            try {
                                return f1.getCanonicalPath().compareTo(f2.getCanonicalPath());
                            }
                            catch (IOException iOException) {
                                return 0;
                            }
                        }
                    });
                    for (File file : files) {
                        if (file.isDirectory()) {
                            unvisitedFolders.add(file);
                            continue;
                        }
                        FileInputStream inputStream = null;
                        try {
                            inputStream = new FileInputStream(file);
                            messageDigest.add((InputStream)inputStream);
                        }
                        finally {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                    }
                }
                sha = messageDigest.getDigestString();
                this.writeSHAToManifest(deploymentDirectory, sha);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating artifact for contentFile: " + deploymentDirectory, e);
        }
        return sha;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSHAToManifest(File deploymentFolder, String sha) throws IOException {
        Manifest manifest;
        File manifestFile = new File(deploymentFolder, MANIFEST_RELATIVE_PATH);
        if (manifestFile.exists()) {
            FileInputStream inputStream = new FileInputStream(manifestFile);
            try {
                manifest = new Manifest(inputStream);
            }
            finally {
                inputStream.close();
            }
        } else {
            manifest = new Manifest();
            manifestFile.getParentFile().mkdirs();
            manifestFile.createNewFile();
        }
        Attributes attribs = manifest.getMainAttributes();
        if (!attribs.containsKey(Attributes.Name.MANIFEST_VERSION.toString()) && !attribs.containsKey(Attributes.Name.SIGNATURE_VERSION.toString())) {
            attribs.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
        }
        attribs.putValue(RHQ_SHA_256, sha);
        FileOutputStream outputStream = new FileOutputStream(manifestFile);
        try {
            manifest.write(outputStream);
        }
        finally {
            outputStream.close();
        }
    }
}

