/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core.jaas;

import java.security.acl.Group;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;

public class JDBCLoginModule
extends UsernamePasswordLoginModule {
    private Log log = LogFactory.getLog(JDBCLoginModule.class);
    private String dsJndiName;
    private String principalsQuery = "SELECT password FROM RHQ_PRINCIPAL WHERE principal=?";

    public void initialize(Subject subj, CallbackHandler handler, Map shared_state, Map opts) {
        Object tmpQuery;
        super.initialize(subj, handler, shared_state, opts);
        this.dsJndiName = (String)opts.get("dsJndiName");
        if (this.dsJndiName == null) {
            this.dsJndiName = "java:/RHQDS";
        }
        if ((tmpQuery = opts.get("principalsQuery")) != null) {
            this.principalsQuery = tmpQuery.toString();
        }
        this.log.debug((Object)("dsJndiName=" + this.dsJndiName));
        this.log.debug((Object)("prinipalsQuery=" + this.principalsQuery));
    }

    private Properties getProperties() {
        Properties props = new Properties();
        props.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        props.put("java.naming.provider.url", "jnp://localhost:1099");
        props.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
        return props;
    }

    protected String getUsersPassword() throws LoginException {
        String username = this.getUsername();
        if ("admin".equals(username)) {
            throw new FailedLoginException("Cannot log in as overlord");
        }
        String password = null;
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            Properties props = this.getProperties();
            InitialContext ctx = new InitialContext(props);
            DataSource ds = (DataSource)ctx.lookup(this.dsJndiName);
            conn = ds.getConnection();
            ps = conn.prepareStatement(this.principalsQuery);
            ps.setString(1, username);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new FailedLoginException("No matching username found in principals");
            }
            password = rs.getString(1);
        }
        catch (NamingException ex) {
            throw new LoginException(ex.toString(true));
        }
        catch (SQLException ex) {
            throw new LoginException(ex.toString());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ex) {}
            }
        }
        return password;
    }

    protected Group[] getRoleSets() throws LoginException {
        SimpleGroup roles = new SimpleGroup("Roles");
        Group[] roleSets = new Group[]{roles};
        return roleSets;
    }
}

