/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.spi.status;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.jboss.deployment.spi.status.DeploymentStatusImpl;

public class ProgressObjectImpl
implements ProgressObject {
    private List listeners = new ArrayList();
    private DeploymentStatusImpl deploymentStatus;
    private TargetModuleID[] targetModules;

    public ProgressObjectImpl(DeploymentStatus deploymentStatus, TargetModuleID[] targetModules) {
        this.deploymentStatus = (DeploymentStatusImpl)deploymentStatus;
        this.targetModules = targetModules;
    }

    public void sendProgressEvent(StateType stateType, String message, TargetModuleID moduleID) {
        this.deploymentStatus.setStateType(stateType);
        this.deploymentStatus.setMessage(message);
        ProgressEvent progressEvent = new ProgressEvent((Object)this, moduleID, (DeploymentStatus)this.deploymentStatus);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ProgressListener progressListener = (ProgressListener)this.listeners.get(i);
            progressListener.handleProgressEvent(progressEvent);
        }
    }

    public DeploymentStatus getDeploymentStatus() {
        return this.deploymentStatus;
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        return this.targetModules;
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID id) {
        return null;
    }

    public boolean isCancelSupported() {
        return false;
    }

    public void cancel() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("cancel not supported");
    }

    public boolean isStopSupported() {
        return false;
    }

    public void stop() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("stop not supported");
    }

    public void addProgressListener(ProgressListener listener) {
        this.listeners.add(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.listeners.remove(listener);
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("[ deploymentStatus=").append(this.deploymentStatus);
        for (int i = 0; i < this.targetModules.length; ++i) {
            sbuf.append(", ").append(this.targetModules[i]);
        }
        sbuf.append(" ]");
        return sbuf.toString();
    }
}

