/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.xmlschema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.util.ValidationEventCollector;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.rhq.core.domain.plugin.ServerPlugin;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.ServerPluginDescriptorType;

public abstract class ServerPluginDescriptorUtil {
    private static final Log LOG = LogFactory.getLog(ServerPluginDescriptorUtil.class);
    private static final String PLUGIN_DESCRIPTOR_PATH = "META-INF/rhq-serverplugin.xml";
    private static final Map<String, String> PLUGIN_SCHEMA_PACKAGES = new HashMap<String, String>();
    private static final String PLUGIN_CONTEXT_PATH;

    public static ServerPlugin determineObsoletePlugin(ServerPlugin plugin1, ServerPlugin plugin2) {
        String version2Str;
        ComparableVersion plugin2Version;
        if (!plugin1.getName().equals(plugin2.getName())) {
            throw new IllegalArgumentException("The two plugins don't have the same name:" + plugin1 + ":" + plugin2);
        }
        if (!plugin1.getType().equals(plugin2.getType())) {
            throw new IllegalArgumentException("The two plugins don't have the same type:" + plugin1 + ":" + plugin2);
        }
        if (plugin1.getMd5().equals(plugin2.getMd5())) {
            return null;
        }
        String version1Str = plugin1.getVersion();
        ComparableVersion plugin1Version = new ComparableVersion(version1Str != null ? version1Str : "0");
        if (plugin1Version.equals((Object)(plugin2Version = new ComparableVersion((version2Str = plugin2.getVersion()) != null ? version2Str : "0")))) {
            if (plugin1.getMtime() == plugin2.getMtime()) {
                LOG.info((Object)("Plugins [" + plugin1 + ", " + plugin2 + "] are the same logical plugin but have different content. The plugin [" + plugin1 + "] will be considered obsolete."));
                return plugin1;
            }
            if (plugin1.getMtime() < plugin2.getMtime()) {
                return plugin1;
            }
            return plugin2;
        }
        if (plugin1Version.compareTo((Object)plugin2Version) < 0) {
            return plugin1;
        }
        return plugin2;
    }

    public static ComparableVersion getPluginVersion(File pluginFile, ServerPluginDescriptorType descriptor) throws Exception {
        Manifest manifest;
        if (descriptor == null && (descriptor = ServerPluginDescriptorUtil.loadPluginDescriptorFromUrl(pluginFile.toURI().toURL())) == null) {
            throw new Exception("Plugin is missing a descriptor: " + pluginFile);
        }
        String version = descriptor.getVersion();
        if (version == null && (manifest = ServerPluginDescriptorUtil.getManifest(pluginFile)) != null) {
            version = manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        }
        if (version == null) {
            throw new Exception("No version is defined for plugin jar [" + pluginFile + "]. A version must be defined either via the MANIFEST.MF [" + Attributes.Name.IMPLEMENTATION_VERSION + "] attribute or via the plugin descriptor 'version' attribute.");
        }
        try {
            return new ComparableVersion(version);
        }
        catch (RuntimeException e) {
            throw new Exception("Version [" + version + "] for [" + pluginFile + "] did not parse", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerPluginDescriptorType loadPluginDescriptorFromUrl(URL pluginJarFileUrl) throws Exception {
        Log logger = LogFactory.getLog(ServerPluginDescriptorUtil.class);
        if (pluginJarFileUrl == null) {
            throw new Exception("A valid plugin JAR URL must be supplied.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Loading plugin descriptor from plugin jar at [" + pluginJarFileUrl + "]..."));
        }
        ServerPluginDescriptorUtil.testPluginJarIsReadable(pluginJarFileUrl);
        JarInputStream jis = null;
        JarEntry descriptorEntry = null;
        try {
            jis = new JarInputStream(pluginJarFileUrl.openStream());
            JarEntry nextEntry = jis.getNextJarEntry();
            while (nextEntry != null && descriptorEntry == null) {
                if (PLUGIN_DESCRIPTOR_PATH.equals(nextEntry.getName())) {
                    descriptorEntry = nextEntry;
                    continue;
                }
                jis.closeEntry();
                nextEntry = jis.getNextJarEntry();
            }
            ServerPluginDescriptorType pluginDescriptor = null;
            if (descriptorEntry != null) {
                Unmarshaller unmarshaller = null;
                try {
                    unmarshaller = ServerPluginDescriptorUtil.getServerPluginDescriptorUnmarshaller();
                    Object jaxbElement = unmarshaller.unmarshal((InputStream)jis);
                    pluginDescriptor = (ServerPluginDescriptorType)((JAXBElement)jaxbElement).getValue();
                }
                finally {
                    if (unmarshaller != null) {
                        ValidationEventCollector validationEventCollector = (ValidationEventCollector)unmarshaller.getEventHandler();
                        ServerPluginDescriptorUtil.logValidationEvents(pluginJarFileUrl, validationEventCollector);
                    }
                }
            }
            ServerPluginDescriptorType serverPluginDescriptorType = pluginDescriptor;
            return serverPluginDescriptorType;
        }
        catch (Exception e) {
            throw new Exception("Could not successfully parse the plugin descriptor [META-INF/rhq-serverplugin.xml] found in plugin jar at [" + pluginJarFileUrl + "]", e);
        }
        finally {
            if (jis != null) {
                try {
                    jis.close();
                }
                catch (Exception e) {
                    logger.warn((Object)("Cannot close jar stream [" + pluginJarFileUrl + "]. Cause: " + e));
                }
            }
        }
    }

    public static Unmarshaller getServerPluginDescriptorUnmarshaller() throws Exception {
        JAXBContext jaxbContext;
        try {
            jaxbContext = JAXBContext.newInstance((String)PLUGIN_CONTEXT_PATH);
        }
        catch (Exception e) {
            throw new Exception("Failed to create JAXB Context.", e);
        }
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        ClassLoader cl = ServerPluginDescriptorUtil.class.getClassLoader();
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Source[] schemaSources = new StreamSource[PLUGIN_SCHEMA_PACKAGES.size()];
        int i = 0;
        for (String schemaPath : PLUGIN_SCHEMA_PACKAGES.keySet()) {
            URL schemaURL = cl.getResource(schemaPath);
            schemaSources[i++] = new StreamSource(schemaURL.toExternalForm());
        }
        Schema pluginSchema = schemaFactory.newSchema(schemaSources);
        unmarshaller.setSchema(pluginSchema);
        ValidationEventCollector vec = new ValidationEventCollector();
        unmarshaller.setEventHandler((ValidationEventHandler)vec);
        return unmarshaller;
    }

    private static void testPluginJarIsReadable(URL pluginJarFileUrl) throws Exception {
        InputStream inputStream = null;
        try {
            inputStream = pluginJarFileUrl.openStream();
        }
        catch (IOException e) {
            throw new Exception("Unable to open plugin jar at [" + pluginJarFileUrl + "] for reading.");
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ignore) {}
        }
    }

    private static void logValidationEvents(URL pluginJarFileUrl, ValidationEventCollector validationEventCollector) {
        block9: for (ValidationEvent event : validationEventCollector.getEvents()) {
            StringBuilder message = new StringBuilder();
            String severity = null;
            switch (event.getSeverity()) {
                case 0: {
                    severity = "warning";
                    break;
                }
                case 1: {
                    severity = "error";
                    break;
                }
                case 2: {
                    severity = "fatal error";
                }
            }
            message.append("Validation ").append(severity);
            File pluginJarFile = new File(pluginJarFileUrl.getPath());
            message.append(" while parsing [").append(pluginJarFile.getName()).append(":").append(PLUGIN_DESCRIPTOR_PATH).append("]");
            ValidationEventLocator locator = event.getLocator();
            message.append(" at line ").append(locator.getLineNumber());
            message.append(", column ").append(locator.getColumnNumber());
            message.append(": ").append(event.getMessage());
            switch (event.getSeverity()) {
                case 0: 
                case 1: {
                    LOG.warn((Object)message);
                    continue block9;
                }
                case 2: {
                    LOG.error((Object)message);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Manifest getManifest(File pluginFile) {
        Manifest manifest;
        JarFile jarFile = new JarFile(pluginFile);
        try {
            Manifest manifest2;
            manifest = manifest2 = jarFile.getManifest();
        }
        catch (Throwable throwable) {
            try {
                jarFile.close();
                throw throwable;
            }
            catch (Exception ignored) {
                return null;
            }
        }
        jarFile.close();
        return manifest;
    }

    static {
        PLUGIN_SCHEMA_PACKAGES.put("rhq-serverplugin.xsd", "org.rhq.enterprise.server.xmlschema.generated.serverplugin");
        PLUGIN_SCHEMA_PACKAGES.put("rhq-serverplugin-generic.xsd", "org.rhq.enterprise.server.xmlschema.generated.serverplugin.generic");
        PLUGIN_SCHEMA_PACKAGES.put("rhq-serverplugin-content.xsd", "org.rhq.enterprise.server.xmlschema.generated.serverplugin.content");
        PLUGIN_SCHEMA_PACKAGES.put("rhq-serverplugin-perspective.xsd", "org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective");
        PLUGIN_SCHEMA_PACKAGES.put("rhq-serverplugin-alert.xsd", "org.rhq.enterprise.server.xmlschema.generated.serverplugin.alert");
        PLUGIN_SCHEMA_PACKAGES.put("rhq-serverplugin-entitlement.xsd", "org.rhq.enterprise.server.xmlschema.generated.serverplugin.entitlement");
        PLUGIN_SCHEMA_PACKAGES.put("rhq-serverplugin-bundle.xsd", "org.rhq.enterprise.server.xmlschema.generated.serverplugin.bundle");
        PLUGIN_SCHEMA_PACKAGES.put("rhq-serverplugin-packagetype.xsd", "org.rhq.enterprise.server.xmlschema.generated.serverplugin.packagetype");
        PLUGIN_SCHEMA_PACKAGES.put("rhq-serverplugin-drift.xsd", "org.rhq.enterprise.server.xmlschema.generated.serverplugin.drift");
        StringBuilder packages = new StringBuilder();
        for (String packageName : PLUGIN_SCHEMA_PACKAGES.values()) {
            packages.append(packageName).append(':');
        }
        packages.setLength(packages.length() - 1);
        PLUGIN_CONTEXT_PATH = packages.toString();
    }
}

