/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.oracle;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.plugins.database.AbstractDatabaseComponent;
import org.rhq.plugins.database.DatabaseQueryUtility;

public class OracleAsmDiskGroupComponent
extends AbstractDatabaseComponent
implements MeasurementFacet {
    private static final String SQL_AVAILABLE = "SELECT COUNT(*) FROM v$asm_diskgroup WHERE group_number = ? and STATE <> 'BROKEN'";
    private static final String SQL_VALUES = "SELECT GROUP_NUMBER, NAME, SECTOR_SIZE sectorSize, BLOCK_SIZE blockSize, ALLOCATION_UNIT_SIZE allocationUnitSize, STATE state, TYPE type, TOTAL_MB totalMb, FREE_MB freeMb, ((TOTAL_MB-FREE_MB)/TOTAL_MB) usedPercent, REQUIRED_MIRROR_FREE_MB requiredMirrorFreeMb, USABLE_FILE_MB usableFileMb, OFFLINE_DISKS offlineDisks, COMPATIBILITY compatibility, DATABASE_COMPATIBILITY databaseCompatibility FROM v$asm_diskgroup WHERE group_number = ?";
    private static Log log = LogFactory.getLog(OracleAsmDiskGroupComponent.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvailabilityType getAvailability() {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.getConnection().prepareStatement(SQL_AVAILABLE);
            statement.setString(1, this.resourceContext.getResourceKey());
            resultSet = statement.executeQuery();
            if (resultSet.next() && resultSet.getInt(1) == 1) {
                AvailabilityType availabilityType = AvailabilityType.UP;
                JDBCUtil.safeClose((Statement)statement, (ResultSet)resultSet);
                return availabilityType;
            }
            JDBCUtil.safeClose((Statement)statement, (ResultSet)resultSet);
        }
        catch (SQLException e) {
            log.debug((Object)"unable to query", (Throwable)e);
        }
        finally {
            JDBCUtil.safeClose((Statement)statement, resultSet);
        }
        return AvailabilityType.DOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.getConnection().prepareStatement(SQL_VALUES);
            statement.setString(1, this.resourceContext.getResourceKey());
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                for (MeasurementScheduleRequest request : metrics) {
                    String name = request.getName().toUpperCase(Locale.US);
                    if (request.getDataType().equals((Object)DataType.TRAIT)) {
                        report.addData(new MeasurementDataTrait(request, resultSet.getString(name)));
                        continue;
                    }
                    try {
                        report.addData(new MeasurementDataNumeric(request, Double.valueOf(resultSet.getDouble(name))));
                    }
                    catch (SQLException e) {
                        log.warn((Object)("Ignoring metric " + name + " as it cannot be read as a double"));
                    }
                }
            }
            DatabaseQueryUtility.close((Statement)statement, (ResultSet)resultSet);
        }
        catch (SQLException e) {
            log.debug((Object)"Unable to read value", (Throwable)e);
            this.removeConnection();
        }
        finally {
            DatabaseQueryUtility.close((Statement)statement, resultSet);
        }
    }
}

