/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.modcluster;

import java.util.Set;
import org.mc4j.ems.connection.bean.EmsBean;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.plugins.jmx.MBeanResourceComponent;
import org.rhq.plugins.modcluster.helper.JBossHelper;
import org.rhq.plugins.modcluster.model.ProxyInfo;

public class ModClusterServerComponent
extends MBeanResourceComponent {
    public AvailabilityType getAvailability() {
        String rawProxyInfo = JBossHelper.getRawProxyInfo(this.getEmsBean());
        if (rawProxyInfo == null) {
            return AvailabilityType.DOWN;
        }
        ProxyInfo proxyInfo = new ProxyInfo(rawProxyInfo);
        if (proxyInfo.getAvailableNodes().size() == 0) {
            return AvailabilityType.DOWN;
        }
        return super.getAvailability();
    }

    protected void getValues(MeasurementReport report, Set requests, EmsBean bean) {
        for (MeasurementScheduleRequest request : requests) {
            if (!request.getName().equals("ProxyInformation")) continue;
            String rawProxyInfo = JBossHelper.getRawProxyInfo(bean);
            report.addData(new MeasurementDataTrait(request, rawProxyInfo));
            requests.remove(request);
            break;
        }
        super.getValues(report, requests, bean);
    }
}

