/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bindings.output;

import au.com.bytecode.opencsv.CSVWriter;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rhq.bindings.util.LazyLoadScenario;
import org.rhq.bindings.util.ShortOutput;
import org.rhq.bindings.util.SummaryFilter;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.ResourceAvailability;
import org.rhq.core.domain.resource.ResourceType;

public class TabularWriter {
    private static final String CSV = "csv";
    String[] headers;
    int[] maxColumnLength;
    boolean[] noShrinkColumns;
    int width = 160;
    PrintWriter out;
    private String format = "raw";
    private CSVWriter csvWriter;
    private SummaryFilter summaryFilter = new SummaryFilter();
    boolean exportMode;
    boolean hideRowCount;
    static Set<String> IGNORED_PROPS = new HashSet<String>();
    static Set<Class> SIMPLE_TYPES;

    public TabularWriter(PrintWriter out, String ... headers) {
        this.headers = headers;
        this.out = out;
    }

    public TabularWriter(PrintWriter out) {
        this.out = out;
    }

    public TabularWriter(PrintWriter out, String format) {
        this.out = out;
        this.format = format;
        if (CSV.equals(format)) {
            this.csvWriter = new CSVWriter((Writer)out);
        }
    }

    public void setHideRowCount(boolean hideRowCount) {
        this.hideRowCount = hideRowCount;
    }

    public void print(Object object) {
        if (object instanceof Map) {
            this.print((Map)object);
            return;
        }
        if (object instanceof Collection) {
            this.print((Collection)object);
            return;
        }
        if (object instanceof Configuration) {
            this.print((Configuration)object);
            return;
        }
        if (object != null && object.getClass().isArray()) {
            if (!object.getClass().getComponentType().isPrimitive()) {
                this.print((Object[])object);
            } else {
                Class<?> oClass = object.getClass();
                this.out.println("Array of " + oClass.getComponentType().getName());
                if (oClass == byte[].class) {
                    for (byte i : (byte[])object) {
                        this.out.println(i);
                    }
                } else if (oClass == short[].class) {
                    for (short i : (short[])object) {
                        this.out.println(i);
                    }
                } else if (oClass == int[].class) {
                    for (int i : (int[])object) {
                        this.out.println(i);
                    }
                } else if (oClass == long[].class) {
                    for (long i : (long[])object) {
                        this.out.println(i);
                    }
                } else if (oClass == char[].class) {
                    for (char i : (char[])object) {
                        this.out.println(i);
                    }
                } else if (oClass == float[].class) {
                    for (float i : (float[])object) {
                        this.out.println(i);
                    }
                } else if (oClass == double[].class) {
                    for (double i : (double[])object) {
                        this.out.println(i);
                    }
                } else if (oClass == boolean[].class) {
                    for (boolean i : (boolean[])object) {
                        this.out.println(i);
                    }
                } else {
                    this.out.println("*Printing of this data type is not supported*");
                }
            }
            return;
        }
        try {
            if (SIMPLE_TYPES.contains(object.getClass())) {
                this.out.println(String.valueOf(object));
                return;
            }
            this.out.println(object.getClass().getSimpleName() + ":");
            LinkedHashMap<String, PropertyInfo> properties = new LinkedHashMap<String, PropertyInfo>();
            int maxLength = 0;
            for (PropertyDescriptor pd : this.summaryFilter.getPropertyDescriptors(object, this.exportMode)) {
                Method m = pd.getReadMethod();
                Object val = null;
                if (m != null) {
                    val = TabularWriter.invoke(object, m);
                }
                if (val == null) {
                    maxLength = Math.max(maxLength, pd.getName().length());
                    properties.put(pd.getName(), new PropertyInfo(pd.getName(), null));
                    continue;
                }
                try {
                    String str = TabularWriter.shortVersion(val);
                    maxLength = Math.max(maxLength, pd.getName().length());
                    properties.put(pd.getName(), new PropertyInfo(str, pd.getPropertyType()));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            for (String key : properties.keySet()) {
                this.printProperty(key, (PropertyInfo)properties.get(key), maxLength);
            }
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
    }

    private void printProperty(String name, PropertyInfo propertyInfo, int maxLength) {
        this.out.print("\t");
        this.printPreSpaced(this.out, name, maxLength);
        this.out.print(": ");
        if (propertyInfo.type == null) {
            this.out.println("");
        } else if (this.exportMode || !String.class.equals(propertyInfo.type)) {
            this.out.println(propertyInfo.value);
        } else {
            this.out.println(this.abbreviate(propertyInfo.value, this.width - 12 - maxLength));
        }
    }

    private String abbreviate(String string, int maxWidth) {
        int offset = 0;
        if (string == null) {
            return null;
        }
        if (maxWidth < 4) {
            throw new IllegalArgumentException("Minimum abbreviation width is 4");
        }
        if (string.length() <= maxWidth) {
            return string;
        }
        if (offset > string.length()) {
            offset = string.length();
        }
        if (string.length() - offset < maxWidth - 3) {
            offset = string.length() - (maxWidth - 3);
        }
        if (offset <= 4) {
            return string.substring(0, maxWidth - 3) + "...";
        }
        if (maxWidth < 7) {
            throw new IllegalArgumentException("Minimum abbreviation width with offset is 7");
        }
        if (offset + (maxWidth - 3) < string.length()) {
            return "..." + this.abbreviate(string.substring(offset), maxWidth - 3);
        }
        return "..." + string.substring(string.length() - (maxWidth - 3));
    }

    public void print(Map map) {
        String[][] data = new String[map.size()][];
        int i = 0;
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            data[i] = new String[2];
            data[i][0] = TabularWriter.shortVersion(key);
            data[i][1] = TabularWriter.shortVersion(value);
            ++i;
        }
        this.headers = new String[]{"Key", "Value"};
        this.print(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Collection list) {
        if (list == null || list.size() == 0) {
            if (!this.hideRowCount) {
                this.out.println("0 rows");
            }
        } else if (list.size() == 1 && !CSV.equals(this.format)) {
            if (!this.hideRowCount) {
                this.out.println("one row");
            }
            this.print(list.iterator().next());
        } else if (!this.allOneType(list)) {
            this.printStrings(list);
        } else {
            Object firstObject = list.iterator().next();
            try {
                if (firstObject instanceof String) {
                    this.headers = new String[]{"Value"};
                    String[][] data = new String[list.size()][1];
                    int i = 0;
                    for (Object object : list) {
                        data[i++][0] = (String)object;
                    }
                    this.print(data);
                } else if (this.consistentMaps(list)) {
                } else {
                    int i = 0;
                    ArrayList<PropertyDescriptor> pdList = new ArrayList<PropertyDescriptor>();
                    for (PropertyDescriptor pd : this.summaryFilter.getPropertyDescriptors(firstObject, this.exportMode)) {
                        try {
                            boolean allNull = true;
                            for (Object row : list) {
                                Method m = pd.getReadMethod();
                                Object val = null;
                                if (m != null) {
                                    val = TabularWriter.invoke(row, pd.getReadMethod());
                                }
                                if ((val == null || val instanceof Collection) && (val == null || !(val instanceof Collection) || ((Collection)val).isEmpty())) continue;
                                allNull = false;
                            }
                            if (allNull || IGNORED_PROPS.contains(pd.getName())) continue;
                            pdList.add(pd);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (pdList.isEmpty()) {
                        this.printStrings(list);
                    } else {
                        this.headers = new String[pdList.size()];
                        String[][] data = new String[list.size()][pdList.size()];
                        for (PropertyDescriptor pd : pdList) {
                            this.headers[i++] = pd.getName();
                        }
                        i = 0;
                        for (Object row : list) {
                            int j = 0;
                            for (PropertyDescriptor pd : pdList) {
                                Object val = "?";
                                val = TabularWriter.invoke(row, pd.getReadMethod());
                                if (val == null) {
                                    data[i][j++] = "";
                                    continue;
                                }
                                data[i][j++] = TabularWriter.shortVersion(val);
                            }
                            ++i;
                        }
                        this.print(data);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.headers = null;
            }
        }
    }

    private boolean consistentMaps(Collection list) {
        ArrayList<String> keys = null;
        String[][] data = new String[list.size()][];
        int i = 0;
        for (Object row : list) {
            if (!(row instanceof Map) && !(row instanceof PropertyMap)) {
                return false;
            }
            if (keys == null) {
                String headerKey;
                keys = new ArrayList<String>();
                if (row instanceof PropertyMap) {
                    for (String string : ((PropertyMap)row).getMap().keySet()) {
                        headerKey = TabularWriter.stringValueOf(string);
                        keys.add(headerKey);
                    }
                } else {
                    for (Object object : ((Map)row).keySet()) {
                        headerKey = TabularWriter.stringValueOf(object);
                        keys.add(headerKey);
                    }
                }
                if (keys.contains("pid")) {
                    String[] processAttribute = new String[]{"pid", "name", "size", "userTime", "kernelTime"};
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (String attribute : processAttribute) {
                        arrayList.add(attribute);
                        keys.remove(attribute);
                    }
                    for (String key : keys) {
                        arrayList.add(key);
                    }
                    keys = arrayList;
                }
            }
            data[i] = new String[keys.size()];
            if (row instanceof PropertyMap) {
                for (String string : keys) {
                    if (!keys.contains(TabularWriter.stringValueOf(string))) {
                        return false;
                    }
                    data[i][keys.lastIndexOf((Object)TabularWriter.stringValueOf((Object)string))] = TabularWriter.shortVersion(((PropertyMap)row).get(String.valueOf(string)));
                }
            } else {
                for (Object object : ((Map)row).keySet()) {
                    if (!keys.contains(TabularWriter.stringValueOf(object))) {
                        return false;
                    }
                    data[i][keys.lastIndexOf((Object)TabularWriter.stringValueOf((Object)object))] = TabularWriter.shortVersion(((Map)row).get(object));
                }
            }
            ++i;
        }
        if (keys != null) {
            this.headers = keys.toArray(new String[keys.size()]);
            this.print(data);
            return true;
        }
        return false;
    }

    public void print(Configuration config) {
        this.out.println("Configuration [" + config.getId() + "] - " + config.getNotes());
        for (PropertySimple p : config.getSimpleProperties().values()) {
            this.print(p, 1);
        }
        for (PropertySimple p : config.getListProperties().values()) {
            this.print((PropertyList)p, 1);
        }
        for (PropertySimple p : config.getMapProperties().values()) {
            this.print((PropertyMap)p, 1);
        }
    }

    public void print(PropertySimple p, int depth) {
        this.out.println(this.indent(depth) + p.getName() + " = " + p.getStringValue());
    }

    public void print(PropertyList p, int depth) {
        this.out.println(this.indent(depth) + p.getName() + " [" + p.getList().size() + "] {");
        if (p.getList().size() > 0 && p.getList().get(0) instanceof PropertyMap) {
            this.consistentMaps(p.getList());
        } else {
            for (Property entry : p.getList()) {
                if (entry instanceof PropertySimple) {
                    this.print((PropertySimple)entry, depth + 1);
                    continue;
                }
                if (!(entry instanceof PropertyMap)) continue;
                this.print((PropertyMap)entry, depth + 1);
            }
        }
        this.out.println(this.indent(depth) + "}");
    }

    public void print(PropertyMap p, int depth) {
        this.out.println(this.indent(depth) + p.getName() + " [" + p.getMap().size() + "] {");
        for (String key : p.getMap().keySet()) {
            Property entry = (Property)p.getMap().get(key);
            if (entry instanceof PropertySimple) {
                this.print((PropertySimple)entry, depth + 1);
                continue;
            }
            if (!(entry instanceof PropertyMap)) continue;
            this.print((PropertyMap)entry, depth + 1);
        }
        this.out.println(this.indent(depth) + "}");
    }

    private String indent(int x) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < x; ++i) {
            buf.append("  ");
        }
        return buf.toString();
    }

    private void printStrings(Collection list) {
        for (Object object : list) {
            this.out.println(TabularWriter.stringValueOf(object));
        }
    }

    private boolean allOneType(Collection list) {
        Class<?> lastClass = null;
        for (Object object : list) {
            if (lastClass == null) {
                lastClass = object.getClass();
                continue;
            }
            if (object.getClass().equals(lastClass)) continue;
            return false;
        }
        return true;
    }

    public void print(Object[] data) {
        if (data == null || data.length == 0) {
            if (!this.hideRowCount) {
                this.out.println("0 rows");
            }
            return;
        }
        this.out.println("Array of " + data.getClass().getComponentType().getName());
        this.print(Arrays.asList(data));
    }

    private void resizeColumns(int[] actualColumnWidths, int maxColumnWidth, List<Integer> columns) {
        int extraSpace = 0;
        Iterator<Integer> iterator = columns.iterator();
        while (iterator.hasNext()) {
            int col = iterator.next();
            if (actualColumnWidths[col] >= maxColumnWidth) continue;
            extraSpace += maxColumnWidth - actualColumnWidths[col];
            iterator.remove();
        }
        if (extraSpace == 0) {
            for (Integer col : columns) {
                actualColumnWidths[col.intValue()] = maxColumnWidth;
            }
        } else {
            if (columns.size() == 0) {
                return;
            }
            if (extraSpace > 0) {
                int newMaxColumnWidth = (maxColumnWidth + extraSpace) / columns.size();
                this.resizeColumns(actualColumnWidths, newMaxColumnWidth, columns);
            }
        }
    }

    public void print(String[][] data) {
        if (data == null || data.length == 0) {
            if (!this.hideRowCount) {
                this.out.println("0 rows");
            }
            return;
        }
        int numberOfColumns = data[0].length;
        int maxColumnWidth = this.width / numberOfColumns;
        int[] actualColumnWidths = new int[numberOfColumns];
        for (String[] row : data) {
            for (int col = 0; col < row.length; ++col) {
                if (row[col] == null) {
                    row[col] = "";
                }
                actualColumnWidths[col] = Math.max(actualColumnWidths[col], row[col].length());
            }
        }
        if (this.headers != null) {
            for (int col = 0; col < this.headers.length; ++col) {
                actualColumnWidths[col] = Math.max(actualColumnWidths[col], this.headers[col].length());
            }
        }
        LinkedList<Integer> columns = new LinkedList<Integer>();
        for (int col = 0; col < actualColumnWidths.length; ++col) {
            columns.add(col);
        }
        this.resizeColumns(actualColumnWidths, maxColumnWidth, columns);
        if (this.headers != null) {
            if (CSV.equals(this.format)) {
                this.csvWriter.writeNext(this.headers);
            } else {
                int i;
                for (i = 0; i < actualColumnWidths.length; ++i) {
                    int colSize = actualColumnWidths[i];
                    this.printSpaced(this.out, this.headers[i], colSize);
                    if (i >= actualColumnWidths.length - 1) continue;
                    this.out.print(" ");
                }
                this.out.print("\n");
                for (i = 1; i < this.width; ++i) {
                    this.out.print("-");
                }
            }
            this.out.print("\n");
        }
        if (CSV.equals(this.format)) {
            for (String[] row : data) {
                this.csvWriter.writeNext(row);
            }
        } else {
            for (String[] row : data) {
                for (int i = 0; i < actualColumnWidths.length; ++i) {
                    int colSize = actualColumnWidths[i];
                    this.printSpaced(this.out, row[i], colSize);
                    if (i >= actualColumnWidths.length - 1) continue;
                    this.out.print(" ");
                }
                this.out.print("\n");
            }
        }
        if (!this.hideRowCount) {
            this.out.print(data.length + " rows\n");
        }
    }

    private void printSpaced(PrintWriter out, String data, int length) {
        int dataLength = data.length();
        if (dataLength > length) {
            out.print(data.substring(0, length));
        } else {
            out.print(data);
            for (int i = dataLength; i < length; ++i) {
                out.print(" ");
            }
        }
    }

    private void printPreSpaced(PrintWriter out, String data, int length) {
        int dataLength = data.length();
        if (dataLength > length) {
            out.print(data.substring(0, length));
        } else {
            for (int i = dataLength; i < length; ++i) {
                out.print(" ");
            }
            out.print(data);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean isExportMode() {
        return this.exportMode;
    }

    public void setExportMode(boolean exportMode) {
        this.exportMode = exportMode;
    }

    private static String shortVersion(Object object) {
        if (object instanceof ShortOutput) {
            return ((ShortOutput)object).getShortOutput();
        }
        if (object instanceof PropertySimple) {
            return ((PropertySimple)object).getStringValue();
        }
        if (object instanceof ResourceType) {
            return ((ResourceType)object).getName();
        }
        if (object instanceof ResourceAvailability) {
            AvailabilityType availType = ((ResourceAvailability)object).getAvailabilityType();
            return availType == null ? "?" : availType.getName();
        }
        if (object != null && object.getClass().isArray()) {
            return Arrays.toString((Object[])object);
        }
        return TabularWriter.stringValueOf(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object invoke(Object o, Method m) throws IllegalAccessException, InvocationTargetException {
        boolean access = m.isAccessible();
        m.setAccessible(true);
        try {
            LazyLoadScenario.setShouldLoad(false);
            Object object = m.invoke(o, new Object[0]);
            return object;
        }
        catch (Exception e) {
            Object var4_5 = null;
            return var4_5;
        }
        finally {
            LazyLoadScenario.setShouldLoad(true);
            m.setAccessible(access);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String stringValueOf(Object object) {
        try {
            LazyLoadScenario.setShouldLoad(false);
            String string = String.valueOf(object);
            return string;
        }
        catch (Exception e) {
            String string = "null";
            return string;
        }
        finally {
            LazyLoadScenario.setShouldLoad(true);
        }
    }

    static {
        IGNORED_PROPS.add("mtime");
        IGNORED_PROPS.add("ctime");
        IGNORED_PROPS.add("itime");
        IGNORED_PROPS.add("uuid");
        IGNORED_PROPS.add("parentResource");
        SIMPLE_TYPES = new HashSet<Class>();
        SIMPLE_TYPES.add(Byte.class);
        SIMPLE_TYPES.add(Byte.TYPE);
        SIMPLE_TYPES.add(Character.class);
        SIMPLE_TYPES.add(Character.TYPE);
        SIMPLE_TYPES.add(Short.class);
        SIMPLE_TYPES.add(Short.TYPE);
        SIMPLE_TYPES.add(Integer.class);
        SIMPLE_TYPES.add(Integer.TYPE);
        SIMPLE_TYPES.add(Long.class);
        SIMPLE_TYPES.add(Long.TYPE);
        SIMPLE_TYPES.add(Float.class);
        SIMPLE_TYPES.add(Float.TYPE);
        SIMPLE_TYPES.add(Double.class);
        SIMPLE_TYPES.add(Double.TYPE);
        SIMPLE_TYPES.add(Boolean.class);
        SIMPLE_TYPES.add(Boolean.TYPE);
        SIMPLE_TYPES.add(String.class);
    }

    private static class PropertyInfo {
        String value;
        Class<?> type;

        PropertyInfo(String propertyValue, Class<?> propertyType) {
            this.value = propertyValue;
            this.type = propertyType;
        }
    }
}

