/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.srp;

import java.io.Serializable;
import java.util.Arrays;
import org.jboss.security.Util;

public class SRPParameters
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 6438772808805276693L;
    public final byte[] N;
    public final byte[] g;
    public final byte[] s;
    public final String hashAlgorithm;
    public final String cipherAlgorithm;
    public byte[] cipherIV;

    public SRPParameters(byte[] N, byte[] g, byte[] s) {
        this(N, g, s, "SHA_Interleave", null);
    }

    public SRPParameters(byte[] N, byte[] g, byte[] s, String hashAlgorithm) {
        this(N, g, s, hashAlgorithm, null);
    }

    public SRPParameters(byte[] N, byte[] g, byte[] s, String hashAlgorithm, String cipherAlgorithm) {
        this(N, g, s, hashAlgorithm, cipherAlgorithm, null);
    }

    public SRPParameters(byte[] N, byte[] g, byte[] s, String hashAlgorithm, String cipherAlgorithm, byte[] cipherIV) {
        this.N = N;
        this.g = g;
        this.s = s;
        if (hashAlgorithm == null) {
            hashAlgorithm = "SHA_Interleave";
        }
        this.hashAlgorithm = hashAlgorithm;
        this.cipherAlgorithm = cipherAlgorithm;
        this.cipherIV = cipherIV;
    }

    public Object clone() {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public int hashCode() {
        int i;
        int hashCode = this.hashAlgorithm.hashCode();
        for (i = 0; i < this.N.length; ++i) {
            hashCode += this.N[i];
        }
        for (i = 0; i < this.g.length; ++i) {
            hashCode += this.g[i];
        }
        for (i = 0; i < this.s.length; ++i) {
            hashCode += this.s[i];
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof SRPParameters) {
            SRPParameters p = (SRPParameters)obj;
            equals = this.hashAlgorithm.equals(p.hashAlgorithm);
            if (equals) {
                equals = Arrays.equals(this.N, p.N);
            }
            if (equals) {
                equals = Arrays.equals(this.g, p.g);
            }
            if (equals) {
                equals = Arrays.equals(this.s, p.s);
            }
        }
        return equals;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer(super.toString());
        tmp.append('{');
        tmp.append("N: ");
        tmp.append(Util.encodeBase64((byte[])this.N));
        tmp.append("|g: ");
        tmp.append(Util.encodeBase64((byte[])this.g));
        tmp.append("|s: ");
        tmp.append(Util.encodeBase64((byte[])this.s));
        tmp.append("|hashAlgorithm: ");
        tmp.append(this.hashAlgorithm);
        tmp.append("|cipherAlgorithm: ");
        tmp.append(this.cipherAlgorithm);
        tmp.append("|cipherIV: ");
        tmp.append(this.cipherIV);
        tmp.append('}');
        return tmp.toString();
    }
}

