/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.mysql;

import java.io.File;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.system.AggregateProcessInfo;
import org.rhq.core.system.ProcessInfo;
import org.rhq.plugins.database.DatabaseComponent;
import org.rhq.plugins.database.DatabaseQueryUtility;
import org.rhq.plugins.mysql.MySqlConnectionInfo;
import org.rhq.plugins.mysql.MySqlConnectionManager;
import org.rhq.plugins.mysql.MySqlDiscoveryComponent;

public class MySqlComponent
implements DatabaseComponent<ResourceComponent<?>>,
ResourceComponent<ResourceComponent<?>>,
MeasurementFacet {
    private ResourceContext resourceContext;
    private AggregateProcessInfo aggregateProcessInfo;
    private MySqlConnectionInfo info;
    private Log log = LogFactory.getLog(this.getClass());
    private Map<String, String> globalStatusValues = new HashMap<String, String>();
    private Map<String, String> globalVariables = new HashMap<String, String>();

    public void start(ResourceContext resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = resourceContext;
        this.info = MySqlDiscoveryComponent.buildConnectionInfo(resourceContext.getPluginConfiguration());
        ProcessInfo processInfo = resourceContext.getNativeProcess();
        if (processInfo != null) {
            this.aggregateProcessInfo = processInfo.getAggregateProcessTree();
        }
    }

    public void stop() {
        MySqlConnectionManager.getConnectionManager().closeConnection(this.info);
    }

    public AvailabilityType getAvailability() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Doing an availability check on " + this.info.buildURL()));
        }
        Connection conn = this.getConnection();
        AvailabilityType result = AvailabilityType.DOWN;
        if (conn != null) {
            result = AvailabilityType.UP;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Availability check on " + this.info.buildURL() + " gives " + result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        Connection conn = this.getConnection();
        if (conn != null) {
            ResultSet rs = null;
            Statement stmt = null;
            try {
                stmt = conn.createStatement();
                rs = stmt.executeQuery("SHOW GLOBAL STATUS");
                while (rs.next()) {
                    this.globalStatusValues.put(rs.getString(1), rs.getString(2));
                }
                rs.close();
                rs = stmt.executeQuery("select * from information_schema.global_variables");
                while (rs.next()) {
                    this.globalVariables.put(rs.getString(1), rs.getString(2));
                }
            }
            catch (SQLException sqle) {
                DatabaseQueryUtility.close((Statement)stmt, rs);
                catch (Throwable throwable) {
                    DatabaseQueryUtility.close((Statement)stmt, rs);
                    throw throwable;
                }
            }
            DatabaseQueryUtility.close((Statement)stmt, (ResultSet)rs);
        }
        this.aggregateProcessInfo = this.findProcessInfo();
        for (MeasurementScheduleRequest request : metrics) {
            String requestName = request.getName();
            if (requestName.startsWith("Process") && this.aggregateProcessInfo != null) {
                this.aggregateProcessInfo.refresh();
                if ("Process.aggregateMemory.resident".equals(requestName)) {
                    long mem = this.aggregateProcessInfo.getAggregateMemory().getResident();
                    report.addData(new MeasurementDataNumeric(request, new Double(mem)));
                    continue;
                }
                if ("Process.aggregateMemory.size".equals(requestName)) {
                    long value = this.aggregateProcessInfo.getAggregateMemory().getSize();
                    report.addData(new MeasurementDataNumeric(request, new Double(value)));
                    continue;
                }
                if ("Process.aggregateMemory.pageFaults".equals(requestName)) {
                    long value = this.aggregateProcessInfo.getAggregateMemory().getPageFaults();
                    report.addData(new MeasurementDataNumeric(request, new Double(value)));
                    continue;
                }
                if ("Process.aggregateCpu.user".equals(requestName)) {
                    long value = this.aggregateProcessInfo.getAggregateCpu().getUser();
                    report.addData(new MeasurementDataNumeric(request, new Double(value)));
                    continue;
                }
                if ("Process.aggregateCpu.sys".equals(requestName)) {
                    long value = this.aggregateProcessInfo.getAggregateCpu().getSys();
                    report.addData(new MeasurementDataNumeric(request, new Double(value)));
                    continue;
                }
                if ("Process.aggregateCpu.percent".equals(requestName)) {
                    double value = this.aggregateProcessInfo.getAggregateCpu().getPercent();
                    report.addData(new MeasurementDataNumeric(request, new Double(value)));
                    continue;
                }
                if ("Process.aggregateCpu.total".equals(requestName)) {
                    long value = this.aggregateProcessInfo.getAggregateCpu().getTotal();
                    report.addData(new MeasurementDataNumeric(request, new Double(value)));
                    continue;
                }
                if (!"Process.aggregateFileDescriptor.total".equals(requestName)) continue;
                long value = this.aggregateProcessInfo.getAggregateFileDescriptor().getTotal();
                report.addData(new MeasurementDataNumeric(request, new Double(value)));
                continue;
            }
            if (request.getDataType() != DataType.MEASUREMENT) continue;
            try {
                String strVal = this.globalStatusValues.get(request.getName());
                double val = Double.parseDouble(strVal);
                report.addData(new MeasurementDataNumeric(request, Double.valueOf(val)));
            }
            catch (Exception e) {}
        }
    }

    public Connection getConnection() {
        try {
            return MySqlConnectionManager.getConnectionManager().getConnection(this.info);
        }
        catch (SQLException ex) {
            this.log.warn((Object)"Unable to obtain database connection ", (Throwable)ex);
            return null;
        }
    }

    public void removeConnection() {
        MySqlConnectionManager.getConnectionManager().closeConnection(this.info);
    }

    private AggregateProcessInfo findProcessInfo() {
        AggregateProcessInfo result = null;
        if (this.aggregateProcessInfo != null && this.aggregateProcessInfo.isRunning()) {
            result = this.aggregateProcessInfo;
        } else {
            long pid = this.findPID();
            if (pid != -1L) {
                List processes = this.resourceContext.getSystemInformation().getAllProcesses();
                for (ProcessInfo pi : processes) {
                    if (pid != pi.getPid()) continue;
                    result = pi.getAggregateProcessTree();
                    break;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long findPID() {
        long result = -1L;
        String pidFile = this.globalVariables.get("PID_FILE");
        File file = new File(pidFile);
        if (file.canRead()) {
            try {
                FileReader pidFileReader = new FileReader(file);
                try {
                    char[] pidData = new char[(int)file.length()];
                    pidFileReader.read(pidData);
                    String pidString = new String(pidData);
                    pidString = pidString.trim();
                    result = Long.valueOf(pidString);
                }
                finally {
                    pidFileReader.close();
                }
            }
            catch (Exception ex) {
                this.log.warn((Object)("Unable to read MySQL pid file " + pidFile));
            }
        }
        return result;
    }
}

