/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.configuration.ConfigurationUpdateRequest;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.discovery.AvailabilityReport;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementData;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.core.pc.ServerServices;
import org.rhq.core.pc.configuration.ConfigurationManager;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pc.measurement.MeasurementManager;
import org.rhq.core.pc.operation.OperationContextImpl;
import org.rhq.core.pc.plugin.FileSystemPluginFinder;
import org.rhq.core.pc.standaloneContainer.Command;
import org.rhq.core.pc.standaloneContainer.History;
import org.rhq.core.pluginapi.operation.OperationContext;
import org.rhq.core.pluginapi.operation.OperationServices;
import org.rhq.core.pluginapi.operation.OperationServicesResult;
import org.rhq.core.pluginapi.operation.OperationServicesResultCode;
import org.rhq.core.system.SystemInfoFactory;

public class StandaloneContainer {
    private PluginContainer pc;
    private int resourceId;
    private Resource platform;
    InventoryManager inventoryManager;
    Integer opId = 0;
    int dollarR = 0;
    static boolean isStdin;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        StandaloneContainer sc = new StandaloneContainer();
        BufferedReader br = null;
        if (argv.length == 0) {
            br = new BufferedReader(new InputStreamReader(System.in));
            isStdin = true;
            sc.run(br);
        } else {
            try {
                br = new BufferedReader(new InputStreamReader(new FileInputStream(argv[0])));
                try {
                    isStdin = false;
                    sc.run(br);
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        System.err.println("IOException happened: " + e + "\n");
                    }
                }
            }
            catch (FileNotFoundException fnfe) {
                System.err.println("File " + argv[0] + " not found");
                System.exit(1);
            }
        }
    }

    private void run(BufferedReader br) {
        boolean shouldQuit = false;
        System.out.println("\nStarting the plugin container.");
        this.pc = PluginContainer.getInstance();
        File pluginDir = new File("plugins");
        File dataDir = new File("data");
        PluginContainerConfiguration pcConfig = new PluginContainerConfiguration();
        pcConfig.setPluginFinder(new FileSystemPluginFinder(pluginDir));
        pcConfig.setPluginDirectory(pluginDir);
        pcConfig.setDataDirectory(dataDir);
        pcConfig.setInsideAgent(false);
        pcConfig.setRootPluginClassLoaderRegex(PluginContainerConfiguration.getDefaultClassLoaderFilter());
        pcConfig.setCreateResourceClassloaders(true);
        pcConfig.setServerServices(new ServerServices());
        this.pc.setConfiguration(pcConfig);
        System.out.println("Loading plugins");
        this.pc.initialize();
        for (String plugin : this.pc.getPluginManager().getMetadataManager().getPluginNames()) {
            System.out.println("...Loaded plugin: " + plugin);
        }
        this.inventoryManager = this.pc.getInventoryManager();
        this.platform = this.inventoryManager.getPlatform();
        System.out.println("\nReady.");
        History history = new History();
        while (!shouldQuit) {
            try {
                String[] tokens;
                System.out.print("[" + history.size() + "]:" + this.resourceId + " > ");
                String answer = br.readLine();
                if (answer == null) break;
                if (!isStdin) {
                    System.out.println(answer);
                }
                if (answer.equalsIgnoreCase(Command.STDIN.toString())) {
                    br = new BufferedReader(new InputStreamReader(System.in));
                    isStdin = true;
                }
                if ((answer = history.handleHistory(answer)).startsWith("!") || (tokens = answer.split(" ")).length <= 0) continue;
                shouldQuit = this.dispatchCommand(tokens);
            }
            catch (Throwable throwable) {
                System.err.println("Exception happened: " + throwable + "\n");
            }
        }
        System.out.println("Shutting down ...");
        this.pc.shutdown();
    }

    private boolean dispatchCommand(String[] tokens) throws Exception {
        if (tokens.length == 0) {
            return false;
        }
        if (tokens[0].startsWith("#")) {
            return false;
        }
        if (tokens[0].isEmpty()) {
            return false;
        }
        Command com = Command.get(tokens[0]);
        if (com == null) {
            System.err.println("Command " + tokens[0] + " is unknown");
            return false;
        }
        int minArgs = com.getMinArgs();
        if (tokens.length < minArgs + 1) {
            System.err.println("Command " + (Object)((Object)com) + " needs " + minArgs + " parameter(s): " + com.getArgs());
            return false;
        }
        switch (com) {
            case ASCAN: {
                AvailabilityReport aReport = this.pc.getDiscoveryAgentService().executeAvailabilityScanImmediately(false);
                System.out.println(aReport);
                break;
            }
            case AVAIL: {
                this.avail(tokens);
                break;
            }
            case CHILDREN: {
                this.children(tokens);
                break;
            }
            case DISCOVER: {
                this.discover(tokens);
                break;
            }
            case FIND: {
                this.find(tokens);
                break;
            }
            case HELP: {
                for (Command comm : EnumSet.allOf(Command.class)) {
                    System.out.println((Object)((Object)comm) + " ( " + comm.getAbbrev() + " ), " + comm.getArgs() + " : " + comm.getHelp());
                }
                System.out.println("Also check out !h for help on history commands");
                break;
            }
            case INVOKE: {
                this.invokeOps(tokens);
                break;
            }
            case MEASURE: {
                this.measure(tokens);
                break;
            }
            case NATIVE: {
                this.doNative(tokens);
                break;
            }
            case PRINT: {
                this.printResource(tokens);
                break;
            }
            case QUIT: {
                System.out.println("Terminating ..");
                return true;
            }
            case RESOURCES: {
                this.resources();
                break;
            }
            case SET: {
                this.set(tokens);
                break;
            }
            case STDIN: {
                break;
            }
            case WAIT: {
                Thread.sleep(Integer.valueOf(tokens[1]).intValue());
                break;
            }
            case P_CONFIG: {
                this.showPluginConfig(tokens);
                break;
            }
            case R_CONFIG: {
                this.showResourceConfig(tokens);
                break;
            }
            case SR_CONFIG: {
                this.setResourcePluginConfig(tokens, false);
                break;
            }
            case SP_CONFIG: {
                this.setResourcePluginConfig(tokens, true);
            }
        }
        return false;
    }

    private void printResource(String[] tokens) {
        int id = this.getResourceIdFromTokens(tokens, this.resourceId);
        ResourceContainer resourceContainer = this.inventoryManager.getResourceContainer(id);
        if (resourceContainer != null) {
            Resource r = resourceContainer.getResource();
            System.out.println(r);
        } else {
            System.err.println("There is no resource with id " + id);
        }
    }

    private void invokeOps(String[] tokens) throws Exception {
        OperationServicesResult res;
        if (this.resourceId == 0) {
            System.err.println("No resource selected");
            return;
        }
        String operation = tokens[1];
        if (operation.equals("-list")) {
            ResourceType rt = this.getTypeForResourceId();
            Set opDefs = rt.getOperationDefinitions();
            for (OperationDefinition def : opDefs) {
                System.out.println(def.getName() + " : " + def.getDescription());
                ConfigurationDefinition params = def.getParametersConfigurationDefinition();
                if (params == null || params.getPropertyDefinitions() == null || params.getPropertyDefinitions().isEmpty()) continue;
                System.out.println("  Parameters:");
                for (Map.Entry param : params.getPropertyDefinitions().entrySet()) {
                    System.out.println("    " + (String)param.getKey());
                }
            }
            if (opDefs.isEmpty()) {
                System.out.println("Resource has no operations");
            }
            return;
        }
        OperationContextImpl operationContext = new OperationContextImpl(this.resourceId);
        OperationServices operationServices = operationContext.getOperationServices();
        Integer i$ = this.opId;
        Integer def = this.opId = Integer.valueOf(this.opId + 1);
        Configuration config = null;
        if (tokens.length > 2) {
            config = this.createConfigurationFromString(tokens[2]);
        }
        if ((res = operationServices.invokeOperation((OperationContext)operationContext, tokens[1], config, 2000L)).getResultCode() == OperationServicesResultCode.FAILURE) {
            System.err.println("Failure executing the operation: \n" + res.getErrorStackTrace());
        } else if (res.getResultCode() == OperationServicesResultCode.TIMED_OUT) {
            System.err.println("Operation timed out ");
        } else if (res.getResultCode() == OperationServicesResultCode.CANCELED) {
            System.err.println("Operation was canceled ");
        } else {
            Configuration result = res.getComplexResults();
            if (result == null) {
                System.out.println("Operation did not return a result");
            } else {
                System.out.println(result.getProperties());
            }
        }
    }

    private void setResourcePluginConfig(String[] tokens, boolean isPluginConfig) throws PluginContainerException {
        if (this.resourceId == 0) {
            System.err.println("No resource set");
            return;
        }
        Configuration newConfig = null;
        Configuration config = null;
        boolean merge = false;
        int pos = 1;
        if (tokens.length < 2) {
            System.err.println("Need at least 1 token");
            return;
        }
        if (tokens[1].equals("-m")) {
            merge = true;
            ++pos;
        }
        if (tokens.length < pos + 1) {
            System.err.println("Need at least 1 token");
            return;
        }
        newConfig = this.createConfigurationFromString(tokens[pos]);
        ConfigurationManager cm = this.pc.getConfigurationManager();
        if (isPluginConfig) {
            Resource targetResource = this.pc.getInventoryManager().getResourceContainer(this.resourceId).getResource();
            config = targetResource.getPluginConfiguration();
            if (merge) {
                for (Property p : config.getProperties()) {
                    if (newConfig.get(p.getName()) != null) continue;
                    newConfig.put(p);
                }
            }
            targetResource.setPluginConfiguration(newConfig);
        } else {
            config = this.pc.getConfigurationManager().loadResourceConfiguration(this.resourceId);
            if (merge) {
                for (Property p : config.getProperties()) {
                    if (newConfig.get(p.getName()) != null) continue;
                    newConfig.put(p);
                }
            }
            ConfigurationUpdateRequest request = new ConfigurationUpdateRequest(1, newConfig, this.resourceId);
            cm.updateResourceConfiguration(request);
        }
    }

    private ResourceType getTypeForResourceId() {
        ResourceContainer rc = this.inventoryManager.getResourceContainer(this.resourceId);
        Resource res = rc.getResource();
        return res.getResourceType();
    }

    private void doNative(String[] tokens) {
        String what = tokens[1];
        if (what.startsWith("e")) {
            SystemInfoFactory.enableNativeSystemInfo();
            System.out.println("Native layer enabled.");
        } else if (what.startsWith("d")) {
            SystemInfoFactory.disableNativeSystemInfo();
            System.out.println("Native layer disabled.");
        } else if (what.startsWith("s")) {
            System.out.println(SystemInfoFactory.isNativeSystemInfoAvailable() ? "Available" : "Not Available");
            System.out.println(SystemInfoFactory.isNativeSystemInfoDisabled() ? "Disabled" : "Enabled");
            System.out.println(SystemInfoFactory.isNativeSystemInfoInitialized() ? "Initialized" : "Not initialized");
        } else {
            System.err.println("Unknown option. Only 'e', 'd' and 's' are applicable (enable/disable/status)");
            return;
        }
    }

    private void event(String[] tokens) {
        if (this.resourceId == 0) {
            return;
        }
        System.err.println("Not yet implemented");
    }

    private void resources() {
        Set<Resource> resources = this.getResources();
        for (Resource res : resources) {
            System.out.println(res);
        }
    }

    private void avail(String[] tokens) {
        Set<Resource> resources = this.getResources();
        int id = this.getResourceIdFromTokens(tokens, 0);
        for (Resource res : resources) {
            if (id != 0 && res.getId() != id) continue;
            Availability availability = this.inventoryManager.getCurrentAvailability(res);
            System.out.println(res.getName() + "( " + res.getId() + " ):" + availability.getAvailabilityType());
        }
    }

    private int getResourceIdFromTokens(String[] tokens, int defaultId) {
        int id = defaultId;
        if (tokens.length > 1) {
            id = tokens[1].equals(".") ? this.resourceId : Integer.valueOf(tokens[1]);
        }
        return id;
    }

    private void children(String[] tokens) {
        int id = this.getResourceIdFromTokens(tokens, this.resourceId);
        ResourceContainer resourceContainer = this.inventoryManager.getResourceContainer(id);
        if (resourceContainer != null) {
            Resource r = resourceContainer.getResource();
            Set resources = r.getChildResources();
            for (Resource res : resources) {
                System.out.println(res);
            }
        } else {
            System.err.println("There is no resource with id " + id);
        }
    }

    private Set<Resource> getResources() {
        HashSet<Resource> resources = new HashSet<Resource>();
        Stack<Resource> stack = new Stack<Resource>();
        stack.push(this.platform);
        while (!stack.isEmpty()) {
            Resource r = (Resource)stack.pop();
            resources.add(r);
            stack.addAll(r.getChildResources());
        }
        return resources;
    }

    private void find(String[] tokens) {
        StringBuilder builder = new StringBuilder();
        int len = tokens.length;
        for (int i = 2; i < len; ++i) {
            builder.append(tokens[i]);
            if (i >= len - 1) continue;
            builder.append(" ");
        }
        String pattern = builder.toString();
        pattern = pattern.replaceAll("\\*", "\\.\\*");
        if (tokens[1].equals("r") || tokens[1].startsWith("res")) {
            Set<Resource> resources = this.getResources();
            for (Resource res : resources) {
                if (!res.getName().matches(pattern)) continue;
                System.out.println(res.getId() + ": " + res.getName() + " (parent= " + res.getParentResource() + " )");
                this.dollarR = res.getId();
            }
        } else if (tokens[1].equals("t")) {
            Set types = this.pc.getPluginManager().getMetadataManager().getAllTypes();
            for (ResourceType type : types) {
                if (!type.getName().matches(pattern)) continue;
                System.out.println(type.getId() + ": " + type.getName() + " (" + type.getPlugin() + " )");
            }
        } else if (tokens[1].equals("rt")) {
            Set types = this.pc.getPluginManager().getMetadataManager().getAllTypes();
            Set<Resource> resources = this.getResources();
            for (ResourceType type : types) {
                if (!type.getName().matches(pattern)) continue;
                for (Resource res : resources) {
                    if (!res.getResourceType().equals((Object)type)) continue;
                    System.out.println(res.getId() + ": " + res.getName() + " ( " + res.getParentResource() + " )");
                    this.dollarR = res.getId();
                }
            }
        } else {
            System.err.println("'" + tokens[1] + "' is no valid option for find");
        }
    }

    private void set(String[] tokens) {
        String comm = tokens[1].toLowerCase();
        String arg = tokens[2];
        if (!comm.startsWith("plu")) {
            if (comm.startsWith("r") || comm.equals("id")) {
                try {
                    this.resourceId = arg.equals("$r") ? this.dollarR : Integer.valueOf(arg);
                }
                catch (NumberFormatException nfe) {
                    System.err.println("Sorry, but [" + arg + "] is no valid number");
                }
                ResourceContainer rc = this.inventoryManager.getResourceContainer(this.resourceId);
                if (rc == null) {
                    System.err.println("No resource with that id exists");
                    this.resourceId = 0;
                }
            } else {
                System.err.println("Bad command " + tokens[1]);
            }
        }
    }

    private void discover(String[] tokens) {
        Set<Resource> existing = this.getResources();
        String what = tokens[1];
        long t1 = System.currentTimeMillis();
        if (what.startsWith("s")) {
            this.pc.getInventoryManager().executeServerScanImmediately();
        } else if (what.startsWith("i")) {
            this.pc.getInventoryManager().executeServiceScanImmediately();
        } else if (what.startsWith("all")) {
            this.pc.getInventoryManager().executeServerScanImmediately();
            this.pc.getInventoryManager().executeServiceScanImmediately();
        } else {
            System.err.println("Unknown option. Only 's' and 'i' are applicable");
            return;
        }
        long t2 = System.currentTimeMillis();
        System.out.println("Discovery took: " + (t2 - t1) + "ms");
        Set<Resource> newOnes = this.getResources();
        newOnes.removeAll(existing);
        System.out.println(newOnes);
    }

    private void measure(String[] tokens) {
        if (this.resourceId == 0) {
            System.err.println("No resource set");
            return;
        }
        MeasurementManager mm = this.pc.getMeasurementManager();
        if (tokens[1].equals("-list")) {
            ResourceType rt = this.getTypeForResourceId();
            Set defs = rt.getMetricDefinitions();
            if (defs == null || defs.isEmpty()) {
                System.out.println("Resource has no metrics");
                return;
            }
            for (MeasurementDefinition def : defs) {
                System.out.println(def.getName() + " : " + def.getDataType() + ", " + def.getDescription());
            }
            return;
        }
        if (tokens.length < 3) {
            System.err.println("measure needs at least two parameters");
            return;
        }
        DataType dataType = this.getDataType(tokens[1]);
        if (dataType == null) {
            System.err.println("Unknown DataType " + tokens[1]);
            System.err.println("Valid ones are measurement, trait, calltime, complex");
        }
        String[] metricNames = new String[tokens.length - 2];
        System.arraycopy(tokens, 2, metricNames, 0, tokens.length - 2);
        HashSet<MeasurementScheduleRequest> requests = new HashSet<MeasurementScheduleRequest>();
        for (String metric : metricNames) {
            requests.add(new MeasurementScheduleRequest(1, metric, 0L, true, dataType));
        }
        Set<MeasurementData> dataset = mm.getRealTimeMeasurementValue(this.resourceId, requests);
        if (dataset == null) {
            System.err.println("No data returned");
            return;
        }
        for (MeasurementData data : dataset) {
            System.out.println(data);
        }
    }

    private DataType getDataType(String token) {
        String c = token.toLowerCase();
        if (c.startsWith("m")) {
            return DataType.MEASUREMENT;
        }
        if (c.startsWith("t")) {
            return DataType.TRAIT;
        }
        if (c.startsWith("ca")) {
            return DataType.CALLTIME;
        }
        if (c.startsWith("co")) {
            return DataType.COMPLEX;
        }
        return null;
    }

    private Configuration createConfigurationFromString(String input) {
        String[] pairs;
        if (input == null) {
            return null;
        }
        Configuration config = new Configuration();
        for (String pair : pairs = input.split("\\|\\|")) {
            String[] kv = pair.split("=");
            if (kv.length % 2 == 1) {
                System.err.println("Token " + pair + " is invalid as it contains no '='");
                return null;
            }
            PropertySimple ps = new PropertySimple(kv[0], (Object)kv[1]);
            config.put((Property)ps);
        }
        return config;
    }

    private void showPluginConfig(String[] tokens) {
        if (this.resourceId == 0) {
            System.err.println("You must first set the resource to work with.");
            return;
        }
        Configuration config = this.pc.getInventoryManager().getResourceContainer(this.resourceId).getResource().getPluginConfiguration();
        this.showConfig(config, tokens);
    }

    private void showResourceConfig(String[] tokens) throws PluginContainerException {
        if (this.resourceId == 0) {
            System.err.println("You must first set the resource to work with.");
            return;
        }
        Configuration config = this.pc.getConfigurationManager().loadResourceConfiguration(this.resourceId);
        this.showConfig(config, tokens);
    }

    private void showConfig(Configuration config, String[] tokens) {
        if (tokens == null || tokens.length < 2) {
            for (Property p : config.getProperties()) {
                System.out.println(p);
            }
        } else {
            String[] props;
            String pList = tokens[1];
            for (String propName : props = pList.split(",")) {
                Property p = config.get(propName);
                if (p == null) {
                    System.err.println("Property " + propName + " not found");
                    continue;
                }
                System.out.println(p);
            }
        }
    }
}

